/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.screen;

import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.component.SimpleLabel;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.OptionButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.SimpleButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBoxInt;
import games.alejandrocoria.mapfrontiers.client.gui.hud.HUD;
import games.alejandrocoria.mapfrontiers.client.gui.hud.HUDWidget;
import games.alejandrocoria.mapfrontiers.client.gui.screen.StackeableScreen;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.platform.Services;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@ParametersAreNonnullByDefault
public class HUDSettings
extends StackeableScreen {
    private HUDWidget HUDWidget;
    private OptionButton buttonSlot1;
    private OptionButton buttonSlot2;
    private OptionButton buttonSlot3;
    private TextBoxInt textBannerSize;
    private OptionButton buttonAnchor;
    private TextBoxInt textPositionX;
    private TextBoxInt textPositionY;
    private OptionButton buttonAutoAdjustAnchor;
    private OptionButton buttonSnapToBorder;
    private SimpleButton buttonDone;
    private final List<SimpleLabel> labels = new ArrayList<SimpleLabel>();
    private final Map<SimpleLabel, List<class_2561>> labelTooltips = new HashMap<SimpleLabel, List<class_2561>>();
    private final HUD hud = HUD.asPreview();
    private int anchorLineColor = -2236963;
    private int anchorLineColorTick = 0;

    public HUDSettings(@Nullable class_437 returnScreen) {
        super((class_2561)class_2561.method_43473(), returnScreen);
    }

    public void method_25426() {
        ClientEventHandler.postUpdatedConfigEvent();
        this.HUDWidget = new HUDWidget(this.hud, Services.JOURNEYMAP.isMinimapEnabled(), widget -> this.HUDUpdated());
        this.buttonSlot1 = new OptionButton(this.field_22793, this.field_22789 / 2 - 104, this.field_22790 / 2 - 32, 64, this::buttonPressed);
        this.buttonSlot1.addOption(Config.getTranslatedEnum(Config.HUDSlot.None));
        this.buttonSlot1.addOption(Config.getTranslatedEnum(Config.HUDSlot.Name));
        this.buttonSlot1.addOption(Config.getTranslatedEnum(Config.HUDSlot.Owner));
        this.buttonSlot1.addOption(Config.getTranslatedEnum(Config.HUDSlot.Banner));
        this.buttonSlot1.setSelected(Config.hudSlot1.ordinal());
        this.buttonSlot2 = new OptionButton(this.field_22793, this.field_22789 / 2 - 104, this.field_22790 / 2 - 16, 64, this::buttonPressed);
        this.buttonSlot2.addOption(Config.getTranslatedEnum(Config.HUDSlot.None));
        this.buttonSlot2.addOption(Config.getTranslatedEnum(Config.HUDSlot.Name));
        this.buttonSlot2.addOption(Config.getTranslatedEnum(Config.HUDSlot.Owner));
        this.buttonSlot2.addOption(Config.getTranslatedEnum(Config.HUDSlot.Banner));
        this.buttonSlot2.setSelected(Config.hudSlot2.ordinal());
        this.buttonSlot3 = new OptionButton(this.field_22793, this.field_22789 / 2 - 104, this.field_22790 / 2, 64, this::buttonPressed);
        this.buttonSlot3.addOption(Config.getTranslatedEnum(Config.HUDSlot.None));
        this.buttonSlot3.addOption(Config.getTranslatedEnum(Config.HUDSlot.Name));
        this.buttonSlot3.addOption(Config.getTranslatedEnum(Config.HUDSlot.Owner));
        this.buttonSlot3.addOption(Config.getTranslatedEnum(Config.HUDSlot.Banner));
        this.buttonSlot3.setSelected(Config.hudSlot3.ordinal());
        this.textBannerSize = new TextBoxInt(3, 1, 8, this.field_22793, this.field_22789 / 2 - 104, this.field_22790 / 2 + 16, 64);
        this.textBannerSize.method_1852(String.valueOf(Config.hudBannerSize));
        this.textBannerSize.method_1880(1);
        this.textBannerSize.setValueChangedCallback(value -> {
            Config.hudBannerSize = value;
            ClientEventHandler.postUpdatedConfigEvent();
            this.updatePosition();
        });
        this.buttonAnchor = new OptionButton(this.field_22793, this.field_22789 / 2 + 96, this.field_22790 / 2 - 32, 134, this::buttonPressed);
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.ScreenTop));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.ScreenTopRight));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.ScreenRight));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.ScreenBottomRight));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.ScreenBottom));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.ScreenBottomLeft));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.ScreenLeft));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.ScreenTopLeft));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.Minimap));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.MinimapHorizontal));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.MinimapVertical));
        this.buttonAnchor.setSelected(Config.hudAnchor.ordinal());
        this.textPositionX = new TextBoxInt(0, Integer.MIN_VALUE, Integer.MAX_VALUE, this.field_22793, this.field_22789 / 2 + 96, this.field_22790 / 2 - 16, 61);
        this.textPositionX.method_1852(String.valueOf(Config.hudXPosition));
        this.textPositionX.method_1880(5);
        this.textPositionX.setValueChangedCallback(value -> {
            Config.hudXPosition = value;
            ClientEventHandler.postUpdatedConfigEvent();
        });
        this.textPositionY = new TextBoxInt(0, Integer.MIN_VALUE, Integer.MAX_VALUE, this.field_22793, this.field_22789 / 2 + 168, this.field_22790 / 2 - 16, 62);
        this.textPositionY.method_1852(String.valueOf(Config.hudYPosition));
        this.textPositionY.method_1880(5);
        this.textPositionY.setValueChangedCallback(value -> {
            Config.hudYPosition = value;
            ClientEventHandler.postUpdatedConfigEvent();
        });
        this.buttonAutoAdjustAnchor = new OptionButton(this.field_22793, this.field_22789 / 2 + 96, this.field_22790 / 2, 134, this::buttonPressed);
        this.buttonAutoAdjustAnchor.addOption((class_2561)class_2561.method_43471((String)"options.on"));
        this.buttonAutoAdjustAnchor.addOption((class_2561)class_2561.method_43471((String)"options.off"));
        this.buttonAutoAdjustAnchor.setSelected(Config.hudAutoAdjustAnchor ? 0 : 1);
        this.buttonSnapToBorder = new OptionButton(this.field_22793, this.field_22789 / 2 + 96, this.field_22790 / 2 + 16, 134, this::buttonPressed);
        this.buttonSnapToBorder.addOption((class_2561)class_2561.method_43471((String)"options.on"));
        this.buttonSnapToBorder.addOption((class_2561)class_2561.method_43471((String)"options.off"));
        this.buttonSnapToBorder.setSelected(Config.hudSnapToBorder ? 0 : 1);
        this.buttonDone = new SimpleButton(this.field_22793, this.field_22789 / 2 - 50, this.field_22790 / 2 + 36, 100, (class_2561)class_2561.method_43471((String)"mapfrontiers.done"), this::buttonPressed);
        this.method_37063((class_364)this.HUDWidget);
        this.method_37063((class_364)this.buttonSlot1);
        this.method_37063((class_364)this.buttonSlot2);
        this.method_37063((class_364)this.buttonSlot3);
        this.method_37063((class_364)this.textBannerSize);
        this.method_37063((class_364)this.buttonAnchor);
        this.method_37063((class_364)this.textPositionX);
        this.method_37063((class_364)this.textPositionY);
        this.method_37063((class_364)this.buttonAutoAdjustAnchor);
        this.method_37063((class_364)this.buttonSnapToBorder);
        this.method_37063((class_364)this.buttonDone);
        this.resetLabels();
        this.updatePosition();
    }

    public void method_25393() {
        ++this.anchorLineColorTick;
        if (this.anchorLineColorTick >= 3) {
            this.anchorLineColorTick = 0;
            this.anchorLineColor = this.anchorLineColor == -2236963 ? -14540254 : -2236963;
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (Services.JOURNEYMAP.isMinimapEnabled()) {
            Services.JOURNEYMAP.drawMinimapPreview(graphics);
        }
        this.drawAnchor(graphics, this.field_22787.method_22683());
        int x1 = this.field_22789 / 2 - 238;
        int x2 = this.field_22789 / 2 + 238;
        int y1 = this.field_22790 / 2 - 40;
        int y2 = this.field_22790 / 2 + 60;
        graphics.method_25294(x1, y1, x2, y2, -955248624);
        graphics.method_25292(x1, x2, y1, -8947849);
        graphics.method_25292(x1, x2, y2, -8947849);
        graphics.method_25301(x1, y1, y2, -8947849);
        graphics.method_25301(x2, y1, y2, -8947849);
        for (class_364 child : this.method_25396()) {
            if (!(child instanceof class_4068)) continue;
            class_4068 renderable = (class_4068)child;
            renderable.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
        for (SimpleLabel label : this.labels) {
            if (!label.field_22764) continue;
            label.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
        for (SimpleLabel label : this.labels) {
            if (!label.field_22764 || !label.method_49606()) continue;
            List<class_2561> tooltip = this.labelTooltips.get((Object)label);
            if (tooltip == null) break;
            graphics.method_51437(this.field_22793, tooltip, Optional.empty(), mouseX, mouseY);
            break;
        }
    }

    @Override
    public boolean method_25404(int key, int value, int modifier) {
        if (key == 69 && !(this.method_25399() instanceof class_342)) {
            this.closeAndReturn();
            return true;
        }
        return super.method_25404(key, value, modifier);
    }

    private void drawAnchor(class_332 graphics, class_1041 mainWindow) {
        float factor = (float)mainWindow.method_4495();
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22905(1.0f / factor, 1.0f / factor, 1.0f);
        int directionX = 0;
        int directionY = 0;
        int length = 25;
        Config.Point anchor = Config.getHUDAnchor(Config.hudAnchor);
        int displayWidth = mainWindow.method_4489();
        int displayHeight = mainWindow.method_4506();
        if (anchor.x < displayWidth / 2) {
            directionX = 1;
        } else if (anchor.x > displayWidth / 2) {
            directionX = -1;
            --anchor.x;
        }
        if (anchor.y < displayHeight / 2) {
            directionY = 1;
        } else if (anchor.y > displayHeight / 2) {
            directionY = -1;
            --anchor.y;
        }
        if (Config.hudAnchor == Config.HUDAnchor.Minimap) {
            directionX = -directionX;
            directionY = -directionY;
            if (directionX == 1) {
                ++anchor.x;
            }
            if (directionY == 1) {
                ++anchor.y;
            }
        }
        if (directionX == 0) {
            graphics.method_25292(anchor.x - length, anchor.x + length, anchor.y, this.anchorLineColor);
        } else {
            graphics.method_25292(anchor.x, anchor.x + length * directionX, anchor.y, this.anchorLineColor);
        }
        if (directionY == 0) {
            graphics.method_25301(anchor.x, anchor.y - length, anchor.y + length, this.anchorLineColor);
        } else {
            graphics.method_25301(anchor.x, anchor.y, anchor.y + length * directionY, this.anchorLineColor);
        }
        graphics.method_51448().method_22909();
    }

    protected void buttonPressed(class_4185 button) {
        if (button == this.buttonSlot1) {
            this.updateSlots();
        } else if (button == this.buttonSlot2) {
            this.updateSlots();
        } else if (button == this.buttonSlot3) {
            this.updateSlots();
        } else if (button == this.buttonAnchor) {
            Config.hudAnchor = Config.HUDAnchor.values()[this.buttonAnchor.getSelected()];
            ClientEventHandler.postUpdatedConfigEvent();
            this.updatePosition();
        } else if (button == this.buttonAutoAdjustAnchor) {
            Config.hudAutoAdjustAnchor = this.buttonAutoAdjustAnchor.getSelected() == 0;
            ClientEventHandler.postUpdatedConfigEvent();
        } else if (button == this.buttonSnapToBorder) {
            Config.hudSnapToBorder = this.buttonSnapToBorder.getSelected() == 0;
            ClientEventHandler.postUpdatedConfigEvent();
        } else if (button == this.buttonDone) {
            this.closeAndReturn();
        }
    }

    private void updateSlots() {
        this.updateSlotsValidity();
        boolean updated = false;
        if (this.buttonSlot1.getColor() == -2236963 || this.buttonSlot1.getColor() == -1) {
            Config.hudSlot1 = Config.HUDSlot.values()[this.buttonSlot1.getSelected()];
            updated = true;
        }
        if (this.buttonSlot2.getColor() == -2236963 || this.buttonSlot2.getColor() == -1) {
            Config.hudSlot2 = Config.HUDSlot.values()[this.buttonSlot2.getSelected()];
            updated = true;
        }
        if (this.buttonSlot3.getColor() == -2236963 || this.buttonSlot3.getColor() == -1) {
            Config.hudSlot3 = Config.HUDSlot.values()[this.buttonSlot3.getSelected()];
            updated = true;
        }
        if (updated) {
            ClientEventHandler.postUpdatedConfigEvent();
            this.updatePosition();
        }
    }

    private void updateSlotsValidity() {
        Config.HUDSlot slot1 = Config.HUDSlot.values()[this.buttonSlot1.getSelected()];
        Config.HUDSlot slot2 = Config.HUDSlot.values()[this.buttonSlot2.getSelected()];
        Config.HUDSlot slot3 = Config.HUDSlot.values()[this.buttonSlot3.getSelected()];
        this.buttonSlot1.setColor(-2236963, -1);
        this.buttonSlot2.setColor(-2236963, -1);
        this.buttonSlot3.setColor(-2236963, -1);
        if (slot1 != Config.HUDSlot.None && slot1 == slot2) {
            this.buttonSlot1.setColor(-2289391, -48060);
            this.buttonSlot2.setColor(-2289391, -48060);
        }
        if (slot1 != Config.HUDSlot.None && slot1 == slot3) {
            this.buttonSlot1.setColor(-2289391, -48060);
            this.buttonSlot3.setColor(-2289391, -48060);
        }
        if (slot2 != Config.HUDSlot.None && slot2 == slot3) {
            this.buttonSlot2.setColor(-2289391, -48060);
            this.buttonSlot3.setColor(-2289391, -48060);
        }
    }

    public void method_25432() {
        ClientEventHandler.postUpdatedConfigEvent();
    }

    private void resetLabels() {
        this.labels.clear();
        this.labelTooltips.clear();
        this.addLabelWithTooltip(new SimpleLabel(this.field_22793, this.field_22789 / 2 - 230, this.field_22790 / 2 - 30, SimpleLabel.Align.Left, Config.getTranslatedName("hud.slot1"), -2236963), Config.getTooltip("hud.slot1"));
        this.addLabelWithTooltip(new SimpleLabel(this.field_22793, this.field_22789 / 2 - 230, this.field_22790 / 2 - 14, SimpleLabel.Align.Left, Config.getTranslatedName("hud.slot2"), -2236963), Config.getTooltip("hud.slot2"));
        this.addLabelWithTooltip(new SimpleLabel(this.field_22793, this.field_22789 / 2 - 230, this.field_22790 / 2 + 2, SimpleLabel.Align.Left, Config.getTranslatedName("hud.slot3"), -2236963), Config.getTooltip("hud.slot3"));
        this.addLabelWithTooltip(new SimpleLabel(this.field_22793, this.field_22789 / 2 - 230, this.field_22790 / 2 + 18, SimpleLabel.Align.Left, Config.getTranslatedName("hud.bannerSize"), -2236963), Config.getTooltip("hud.bannerSize"));
        this.addLabelWithTooltip(new SimpleLabel(this.field_22793, this.field_22789 / 2 - 30, this.field_22790 / 2 - 30, SimpleLabel.Align.Left, Config.getTranslatedName("hud.anchor"), -2236963), Config.getTooltip("hud.anchor"));
        this.addLabelWithTooltip(new SimpleLabel(this.field_22793, this.field_22789 / 2 - 30, this.field_22790 / 2 - 14, SimpleLabel.Align.Left, (class_2561)class_2561.method_43471((String)"mapfrontiers.config.hud.position"), -2236963), Collections.singletonList(class_2561.method_43470((String)"HUD position relative to anchor.")));
        this.labels.add(new SimpleLabel(this.field_22793, this.field_22789 / 2 + 162, this.field_22790 / 2 - 14, SimpleLabel.Align.Center, (class_2561)class_2561.method_43470((String)"x"), -8947849));
        this.addLabelWithTooltip(new SimpleLabel(this.field_22793, this.field_22789 / 2 - 30, this.field_22790 / 2 + 2, SimpleLabel.Align.Left, Config.getTranslatedName("hud.autoAdjustAnchor"), -2236963), Config.getTooltip("hud.autoAdjustAnchor"));
        this.addLabelWithTooltip(new SimpleLabel(this.field_22793, this.field_22789 / 2 - 30, this.field_22790 / 2 + 18, SimpleLabel.Align.Left, Config.getTranslatedName("hud.snapToBorder"), -2236963), Config.getTooltip("hud.snapToBorder"));
    }

    private void addLabelWithTooltip(SimpleLabel label, List<class_2561> tooltip) {
        this.labels.add(label);
        this.labelTooltips.put(label, tooltip);
    }

    private void updatePosition() {
        Config.Point anchorPoint = Config.getHUDAnchor(Config.hudAnchor);
        Config.Point originPoint = Config.getHUDOrigin(Config.hudAnchor, this.hud.getWidth(), this.hud.getHeight());
        Config.Point positionPoint = new Config.Point();
        positionPoint.x = Config.hudXPosition + anchorPoint.x - originPoint.x;
        positionPoint.y = Config.hudYPosition + anchorPoint.y - originPoint.y;
        this.HUDWidget.setPositionHUD(positionPoint);
    }

    private void HUDUpdated() {
        this.buttonAnchor.setSelected(Config.hudAnchor.ordinal());
        this.textPositionX.method_1852(String.valueOf(Config.hudXPosition));
        this.textPositionY.method_1852(String.valueOf(Config.hudYPosition));
    }
}

