/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.screen;

import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.component.SimpleLabel;
import games.alejandrocoria.mapfrontiers.client.gui.component.TabbedBox;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.IconButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.LinkButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.OptionButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.PatreonButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.SimpleButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.GroupActionElement;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.GroupElement;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.ScrollBox;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.UserElement;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBox;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBoxDouble;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBoxInt;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBoxUser;
import games.alejandrocoria.mapfrontiers.client.gui.screen.HUDSettings;
import games.alejandrocoria.mapfrontiers.client.gui.screen.StackeableScreen;
import games.alejandrocoria.mapfrontiers.client.util.ScreenHelper;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.common.network.PacketFrontierSettings;
import games.alejandrocoria.mapfrontiers.common.network.PacketHandler;
import games.alejandrocoria.mapfrontiers.common.network.PacketRequestFrontierSettings;
import games.alejandrocoria.mapfrontiers.common.settings.FrontierSettings;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsGroup;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsProfile;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.platform.Services;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_407;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_634;
import net.minecraft.class_640;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class ModSettings
extends StackeableScreen {
    private float scaleFactor;
    private int actualWidth;
    private int actualHeight;
    private final class_437 returnScreen;
    private final boolean showKeyHint;
    private FrontierSettings settings;
    private TabbedBox tabbedBox;
    private LinkButton buttonWeb;
    private LinkButton buttonProject;
    private PatreonButton buttonPatreon;
    private OptionButton buttonFullscreenButtons;
    private OptionButton buttonFullscreenVisibility;
    private OptionButton buttonFullscreenNameVisibility;
    private OptionButton buttonFullscreenOwnerVisibility;
    private OptionButton buttonMinimapVisibility;
    private OptionButton buttonMinimapNameVisibility;
    private OptionButton buttonMinimapOwnerVisibility;
    private OptionButton ButtonTitleAnnouncementAboveHotbar;
    private OptionButton buttonAnnounceUnnamedFrontiers;
    private OptionButton buttonHideNamesThatDontFit;
    private TextBoxDouble textPolygonsOpacity;
    private TextBoxInt textSnapDistance;
    private OptionButton buttonHUDEnabled;
    private SimpleButton buttonEditHUD;
    private ScrollBox groups;
    private ScrollBox users;
    private ScrollBox groupsActions;
    private TextBox textNewGroupName;
    private IconButton buttonNewGroup;
    private TextBoxUser textNewUser;
    private IconButton buttonNewUser;
    private TextBox textGroupName;
    private SimpleButton buttonDone;
    private final List<SimpleLabel> labels;
    private final Map<SimpleLabel, List<class_2561>> labelTooltips;
    private boolean canEditGroups;
    private Tab tabSelected;
    private int ticksSinceLastUpdate = 0;

    public ModSettings(boolean showKeyHint, @Nullable class_437 returnScreen) {
        super((class_2561)class_2561.method_43471((String)"mapfrontiers.title_settings"), returnScreen);
        this.returnScreen = returnScreen;
        this.showKeyHint = showKeyHint;
        this.labels = new ArrayList<SimpleLabel>();
        this.labelTooltips = new HashMap<SimpleLabel, List<class_2561>>();
        ClientEventHandler.subscribeUpdatedSettingsProfileEvent((Object)this, profile -> {
            if (profile.updateSettings == SettingsProfile.State.Enabled == this.canEditGroups) {
                return;
            }
            if (this.tabSelected != null) {
                MapFrontiersClient.setLastSettingsTab(this.tabSelected);
            }
            this.field_22787.method_1507((class_437)new ModSettings(showKeyHint, returnScreen));
        });
    }

    private ModSettings() {
        super((class_2561)class_2561.method_43473(), null);
        this.returnScreen = null;
        this.showKeyHint = false;
        this.labels = null;
        this.labelTooltips = null;
    }

    public static ModSettings createDummy() {
        return new ModSettings();
    }

    public void method_25426() {
        this.scaleFactor = ScreenHelper.getScaleFactorThatFit(this.field_22787, this, 696, 366);
        this.actualWidth = (int)((float)this.field_22789 * this.scaleFactor);
        this.actualHeight = (int)((float)this.field_22790 * this.scaleFactor);
        boolean bl = this.canEditGroups = MapFrontiersClient.isModOnServer() && MapFrontiersClient.getSettingsProfile().updateSettings == SettingsProfile.State.Enabled;
        if (this.tabSelected == null) {
            this.tabSelected = MapFrontiersClient.getLastSettingsTab();
        }
        this.tabbedBox = new TabbedBox(this.field_22793, 40, 24, this.actualWidth - 80, this.actualHeight - 64, tab -> {
            this.tabSelected = Tab.values()[tab];
            if (this.tabSelected == Tab.Actions) {
                this.updateGroupsActions();
            }
            this.resetLabels();
            this.updateButtonsVisibility();
        });
        this.tabbedBox.addTab((class_2561)class_2561.method_43471((String)"mapfrontiers.credits"), true);
        this.tabbedBox.addTab((class_2561)class_2561.method_43471((String)"mapfrontiers.general"), true);
        this.tabbedBox.addTab((class_2561)class_2561.method_43471((String)"mapfrontiers.groups"), this.canEditGroups);
        this.tabbedBox.addTab((class_2561)class_2561.method_43471((String)"mapfrontiers.actions"), this.canEditGroups);
        if (!(this.canEditGroups || this.tabSelected != Tab.Groups && this.tabSelected != Tab.Actions)) {
            this.tabSelected = Tab.Credits;
        }
        this.tabbedBox.setTabSelected(this.tabSelected.ordinal());
        this.buttonWeb = new LinkButton(this.field_22793, this.actualWidth / 2, this.actualHeight / 2 - 98, (class_2561)class_2561.method_43470((String)"alejandrocoria.games"), b -> {
            MapFrontiersClient.setLastSettingsTab(this.tabSelected);
            class_407.method_60866((class_437)this, (String)"https://alejandrocoria.games", (boolean)false);
        });
        this.buttonProject = new LinkButton(this.field_22793, this.actualWidth / 2, this.actualHeight / 2 - 20, (class_2561)class_2561.method_43470((String)"curseforge.com/minecraft/mc-mods/mapfrontiers"), b -> {
            MapFrontiersClient.setLastSettingsTab(this.tabSelected);
            class_407.method_60866((class_437)this, (String)"https://www.curseforge.com/minecraft/mc-mods/mapfrontiers", (boolean)false);
        });
        this.buttonPatreon = new PatreonButton(this.actualWidth / 2, this.actualHeight / 2 + 36, b -> {
            MapFrontiersClient.setLastSettingsTab(this.tabSelected);
            class_407.method_60866((class_437)this, (String)"https://www.patreon.com/alejandrocoria", (boolean)false);
        });
        this.buttonFullscreenButtons = new OptionButton(this.field_22793, this.actualWidth / 2 + 80, 54, 40, this::buttonPressed);
        this.buttonFullscreenButtons.addOption((class_2561)class_2561.method_43471((String)"options.on"));
        this.buttonFullscreenButtons.addOption((class_2561)class_2561.method_43471((String)"options.off"));
        this.buttonFullscreenButtons.setSelected(Config.fullscreenButtons ? 0 : 1);
        this.buttonFullscreenVisibility = new OptionButton(this.field_22793, this.actualWidth / 2 - 120, 106, 80, this::buttonPressed);
        this.buttonFullscreenVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Custom));
        this.buttonFullscreenVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Always));
        this.buttonFullscreenVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Never));
        this.buttonFullscreenVisibility.setSelected(Config.fullscreenVisibility.ordinal());
        this.buttonFullscreenNameVisibility = new OptionButton(this.field_22793, this.actualWidth / 2 - 120, 122, 80, this::buttonPressed);
        this.buttonFullscreenNameVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Custom));
        this.buttonFullscreenNameVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Always));
        this.buttonFullscreenNameVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Never));
        this.buttonFullscreenNameVisibility.setSelected(Config.fullscreenNameVisibility.ordinal());
        this.buttonFullscreenOwnerVisibility = new OptionButton(this.field_22793, this.actualWidth / 2 - 120, 138, 80, this::buttonPressed);
        this.buttonFullscreenOwnerVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Custom));
        this.buttonFullscreenOwnerVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Always));
        this.buttonFullscreenOwnerVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Never));
        this.buttonFullscreenOwnerVisibility.setSelected(Config.fullscreenOwnerVisibility.ordinal());
        this.buttonMinimapVisibility = new OptionButton(this.field_22793, this.actualWidth / 2 + 140, 106, 80, this::buttonPressed);
        this.buttonMinimapVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Custom));
        this.buttonMinimapVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Always));
        this.buttonMinimapVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Never));
        this.buttonMinimapVisibility.setSelected(Config.minimapVisibility.ordinal());
        this.buttonMinimapNameVisibility = new OptionButton(this.field_22793, this.actualWidth / 2 + 140, 122, 80, this::buttonPressed);
        this.buttonMinimapNameVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Custom));
        this.buttonMinimapNameVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Always));
        this.buttonMinimapNameVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Never));
        this.buttonMinimapNameVisibility.setSelected(Config.minimapNameVisibility.ordinal());
        this.buttonMinimapOwnerVisibility = new OptionButton(this.field_22793, this.actualWidth / 2 + 140, 138, 80, this::buttonPressed);
        this.buttonMinimapOwnerVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Custom));
        this.buttonMinimapOwnerVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Always));
        this.buttonMinimapOwnerVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Never));
        this.buttonMinimapOwnerVisibility.setSelected(Config.minimapOwnerVisibility.ordinal());
        this.ButtonTitleAnnouncementAboveHotbar = new OptionButton(this.field_22793, this.actualWidth / 2 + 80, 170, 40, this::buttonPressed);
        this.ButtonTitleAnnouncementAboveHotbar.addOption((class_2561)class_2561.method_43471((String)"options.on"));
        this.ButtonTitleAnnouncementAboveHotbar.addOption((class_2561)class_2561.method_43471((String)"options.off"));
        this.ButtonTitleAnnouncementAboveHotbar.setSelected(Config.titleAnnouncementAboveHotbar ? 0 : 1);
        this.buttonAnnounceUnnamedFrontiers = new OptionButton(this.field_22793, this.actualWidth / 2 + 80, 186, 40, this::buttonPressed);
        this.buttonAnnounceUnnamedFrontiers.addOption((class_2561)class_2561.method_43471((String)"options.on"));
        this.buttonAnnounceUnnamedFrontiers.addOption((class_2561)class_2561.method_43471((String)"options.off"));
        this.buttonAnnounceUnnamedFrontiers.setSelected(Config.announceUnnamedFrontiers ? 0 : 1);
        this.buttonHideNamesThatDontFit = new OptionButton(this.field_22793, this.actualWidth / 2 + 80, 202, 40, this::buttonPressed);
        this.buttonHideNamesThatDontFit.addOption((class_2561)class_2561.method_43471((String)"options.on"));
        this.buttonHideNamesThatDontFit.addOption((class_2561)class_2561.method_43471((String)"options.off"));
        this.buttonHideNamesThatDontFit.setSelected(Config.hideNamesThatDontFit ? 0 : 1);
        this.textPolygonsOpacity = new TextBoxDouble(0.4, 0.0, 1.0, this.field_22793, this.actualWidth / 2 + 80, 218, 40);
        this.textPolygonsOpacity.method_1852(String.valueOf(Config.polygonsOpacity));
        this.textPolygonsOpacity.method_1880(6);
        this.textPolygonsOpacity.setValueChangedCallback(value -> {
            Config.polygonsOpacity = value;
        });
        this.textSnapDistance = new TextBoxInt(8, 0, 16, this.field_22793, this.actualWidth / 2 + 80, 234, 40);
        this.textSnapDistance.method_1852(String.valueOf(Config.snapDistance));
        this.textSnapDistance.method_1880(2);
        this.textSnapDistance.setValueChangedCallback(value -> {
            Config.snapDistance = value;
        });
        this.buttonHUDEnabled = new OptionButton(this.field_22793, this.actualWidth / 2 + 80, 288, 40, this::buttonPressed);
        this.buttonHUDEnabled.addOption((class_2561)class_2561.method_43471((String)"options.on"));
        this.buttonHUDEnabled.addOption((class_2561)class_2561.method_43471((String)"options.off"));
        this.buttonHUDEnabled.setSelected(Config.hudEnabled ? 0 : 1);
        this.buttonEditHUD = new SimpleButton(this.field_22793, this.actualWidth / 2 - 50, 308, 100, (class_2561)class_2561.method_43471((String)"mapfrontiers.edit_hud"), this::buttonPressed);
        this.groups = new ScrollBox(50, 50, 160, this.actualHeight - 120, 16);
        this.groups.setElementClickedCallback(element -> {
            this.groupClicked((GroupElement)element);
            this.updateButtonsVisibility();
        });
        this.groups.setElementDeletedCallback(element -> {
            if (this.groups.getSelectedElement() != null) {
                this.groupClicked((GroupElement)this.groups.getSelectedElement());
            }
            this.settings.removeCustomGroup(((GroupElement)element).getGroup());
            this.sendChangesToServer();
        });
        this.users = new ScrollBox(250, 82, 258, this.actualHeight - 150, 16);
        this.users.setElementDeletedCallback(element -> {
            SettingsGroup group = ((GroupElement)this.groups.getSelectedElement()).getGroup();
            group.removeUser(((UserElement)element).getUser());
            this.sendChangesToServer();
        });
        this.groupsActions = new ScrollBox(this.actualWidth / 2 - 215, 82, 430, this.actualHeight - 128, 16);
        this.textNewGroupName = new TextBox(this.field_22793, 50, this.actualHeight - 61, 140, class_1074.method_4662((String)"mapfrontiers.new_group_name", (Object[])new Object[0]));
        this.textNewGroupName.method_1880(22);
        this.buttonNewGroup = new IconButton(192, this.actualHeight - 61, IconButton.Type.Add, this::buttonPressed);
        this.textNewUser = new TextBoxUser(this.field_22787, this.field_22793, 250, this.actualHeight - 61, 238, class_1074.method_4662((String)"mapfrontiers.new_user", (Object[])new Object[0]));
        this.textNewUser.method_1880(38);
        this.buttonNewUser = new IconButton(490, this.actualHeight - 61, IconButton.Type.Add, this::buttonPressed);
        this.textGroupName = new TextBox(this.field_22793, 250, 50, 140);
        this.textGroupName.method_1880(22);
        this.textGroupName.method_1888(false);
        this.textGroupName.method_1858(false);
        this.textGroupName.setLostFocusCallback(value -> {
            GroupElement groupElement;
            if (this.tabSelected == Tab.Groups && (groupElement = (GroupElement)this.groups.getSelectedElement()) != null) {
                groupElement.getGroup().setName((String)value);
                this.sendChangesToServer();
            }
        });
        this.buttonDone = new SimpleButton(this.field_22793, this.actualWidth / 2 - 70, this.actualHeight - 28, 140, (class_2561)class_2561.method_43471((String)"gui.done"), this::buttonPressed);
        this.method_37063((class_364)this.tabbedBox);
        this.method_37063((class_364)this.buttonWeb);
        this.method_37063((class_364)this.buttonProject);
        this.method_37063((class_364)this.buttonPatreon);
        this.method_37063((class_364)this.buttonFullscreenButtons);
        this.method_37063((class_364)this.buttonFullscreenVisibility);
        this.method_37063((class_364)this.buttonFullscreenNameVisibility);
        this.method_37063((class_364)this.buttonFullscreenOwnerVisibility);
        this.method_37063((class_364)this.buttonMinimapVisibility);
        this.method_37063((class_364)this.buttonMinimapNameVisibility);
        this.method_37063((class_364)this.buttonMinimapOwnerVisibility);
        this.method_37063((class_364)this.ButtonTitleAnnouncementAboveHotbar);
        this.method_37063((class_364)this.buttonAnnounceUnnamedFrontiers);
        this.method_37063((class_364)this.buttonHideNamesThatDontFit);
        this.method_37063((class_364)this.textPolygonsOpacity);
        this.method_37063((class_364)this.textSnapDistance);
        this.method_37063((class_364)this.buttonHUDEnabled);
        this.method_37063((class_364)this.buttonEditHUD);
        this.method_37063((class_364)this.groups);
        this.method_37063((class_364)this.users);
        this.method_37063((class_364)this.groupsActions);
        this.method_37063((class_364)this.textNewGroupName);
        this.method_37063((class_364)this.buttonNewGroup);
        this.method_37063((class_364)this.textNewUser);
        this.method_37063((class_364)this.buttonNewUser);
        this.method_37063((class_364)this.textGroupName);
        this.method_37063((class_364)this.buttonDone);
        this.resetLabels();
        this.updateButtonsVisibility();
        if (MapFrontiersClient.isModOnServer()) {
            PacketHandler.sendToServer(new PacketRequestFrontierSettings());
        }
    }

    public void method_25393() {
        if (!this.canEditGroups || this.settings == null) {
            return;
        }
        ++this.ticksSinceLastUpdate;
        if (this.ticksSinceLastUpdate >= 100) {
            this.ticksSinceLastUpdate = 0;
            PacketHandler.sendToServer(new PacketRequestFrontierSettings(this.settings.getChangeCounter()));
            class_634 handler = this.field_22787.method_1562();
            if (handler == null) {
                return;
            }
            for (ScrollBox.ScrollElement element : this.users.getElements()) {
                UserElement userElement = (UserElement)element;
                SettingsUser user = userElement.getUser();
                class_640 networkplayerinfo = null;
                if (user.uuid != null) {
                    networkplayerinfo = handler.method_2871(user.uuid);
                } else if (!StringUtils.isBlank((CharSequence)user.username)) {
                    networkplayerinfo = handler.method_2874(user.username);
                }
                if (networkplayerinfo == null) {
                    userElement.setPingBar(0);
                    continue;
                }
                if (networkplayerinfo.method_2959() < 0) {
                    userElement.setPingBar(0);
                    continue;
                }
                if (networkplayerinfo.method_2959() < 150) {
                    userElement.setPingBar(5);
                    continue;
                }
                if (networkplayerinfo.method_2959() < 300) {
                    userElement.setPingBar(4);
                    continue;
                }
                if (networkplayerinfo.method_2959() < 600) {
                    userElement.setPingBar(3);
                    continue;
                }
                if (networkplayerinfo.method_2959() < 1000) {
                    userElement.setPingBar(2);
                    continue;
                }
                userElement.setPingBar(1);
            }
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25420(graphics, mouseX, mouseY, partialTicks);
        mouseX = (int)((float)mouseX * this.scaleFactor);
        mouseY = (int)((float)mouseY * this.scaleFactor);
        if (this.scaleFactor != 1.0f) {
            graphics.method_51448().method_22903();
            graphics.method_51448().method_22905(1.0f / this.scaleFactor, 1.0f / this.scaleFactor, 1.0f);
        }
        for (class_364 child : this.method_25396()) {
            if (!(child instanceof class_4068)) continue;
            class_4068 renderable = (class_4068)child;
            renderable.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
        graphics.method_27534(this.field_22793, this.field_22785, this.actualWidth / 2, 8, -1);
        for (SimpleLabel label : this.labels) {
            if (!label.field_22764) continue;
            label.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
        for (SimpleLabel label : this.labels) {
            if (!label.field_22764 || !label.method_49606()) continue;
            List<class_2561> tooltip = this.labelTooltips.get((Object)label);
            if (tooltip == null) break;
            graphics.method_51437(this.field_22793, tooltip, Optional.empty(), mouseX, mouseY);
            break;
        }
        if (this.scaleFactor != 1.0f) {
            graphics.method_51448().method_22909();
        }
    }

    @Override
    public boolean method_25404(int key, int value, int modifier) {
        if (key == 69 && !(this.method_25399() instanceof class_342)) {
            this.closeAndReturn();
            return true;
        }
        return super.method_25404(key, value, modifier);
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        return super.method_25402(mouseX * (double)this.scaleFactor, mouseY * (double)this.scaleFactor, mouseButton);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        mouseX *= (double)this.scaleFactor;
        mouseY *= (double)this.scaleFactor;
        for (class_364 w : this.method_25396()) {
            if (!(w instanceof ScrollBox)) continue;
            ((ScrollBox)w).mouseReleased();
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double hDelta, double vDelta) {
        return super.method_25401(mouseX * (double)this.scaleFactor, mouseY * (double)this.scaleFactor, hDelta, vDelta);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.method_25403(mouseX * (double)this.scaleFactor, mouseY * (double)this.scaleFactor, button, dragX * (double)this.scaleFactor, dragY * (double)this.scaleFactor);
    }

    protected void buttonPressed(class_4185 button) {
        if (button == this.buttonFullscreenButtons) {
            Config.fullscreenButtons = this.buttonFullscreenButtons.getSelected() == 0;
        } else if (button == this.buttonFullscreenVisibility) {
            Config.fullscreenVisibility = Config.Visibility.values()[this.buttonFullscreenVisibility.getSelected()];
        } else if (button == this.buttonFullscreenNameVisibility) {
            Config.fullscreenNameVisibility = Config.Visibility.values()[this.buttonFullscreenNameVisibility.getSelected()];
        } else if (button == this.buttonFullscreenOwnerVisibility) {
            Config.fullscreenOwnerVisibility = Config.Visibility.values()[this.buttonFullscreenOwnerVisibility.getSelected()];
        } else if (button == this.buttonMinimapVisibility) {
            Config.minimapVisibility = Config.Visibility.values()[this.buttonMinimapVisibility.getSelected()];
        } else if (button == this.buttonMinimapNameVisibility) {
            Config.minimapNameVisibility = Config.Visibility.values()[this.buttonMinimapNameVisibility.getSelected()];
        } else if (button == this.buttonMinimapOwnerVisibility) {
            Config.minimapOwnerVisibility = Config.Visibility.values()[this.buttonMinimapOwnerVisibility.getSelected()];
        } else if (button == this.ButtonTitleAnnouncementAboveHotbar) {
            Config.titleAnnouncementAboveHotbar = this.ButtonTitleAnnouncementAboveHotbar.getSelected() == 0;
        } else if (button == this.buttonAnnounceUnnamedFrontiers) {
            Config.announceUnnamedFrontiers = this.buttonAnnounceUnnamedFrontiers.getSelected() == 0;
        } else if (button == this.buttonHideNamesThatDontFit) {
            Config.hideNamesThatDontFit = this.buttonHideNamesThatDontFit.getSelected() == 0;
        } else if (button == this.buttonHUDEnabled) {
            Config.hudEnabled = this.buttonHUDEnabled.getSelected() == 0;
            this.updateButtonsVisibility();
        } else if (button == this.buttonEditHUD) {
            MapFrontiersClient.setLastSettingsTab(this.tabSelected);
            this.field_22787.method_1507((class_437)new HUDSettings(this));
        } else if (button == this.buttonNewGroup) {
            if (this.settings != null) {
                SettingsGroup group = this.settings.createCustomGroup(this.textNewGroupName.method_1882());
                this.textNewGroupName.method_1852("");
                GroupElement element = new GroupElement(this.field_22793, this, group);
                this.groups.addElement(element);
                this.groups.scrollBottom();
                this.groupClicked(element);
                this.groupsActions.scrollBottom();
                this.sendChangesToServer();
            }
        } else if (button == this.buttonNewUser) {
            SettingsGroup group = ((GroupElement)this.groups.getSelectedElement()).getGroup();
            SettingsUser user = new SettingsUser();
            String usernameOrUUID = this.textNewUser.method_1882();
            if (StringUtils.isBlank((CharSequence)usernameOrUUID)) {
                return;
            }
            if (usernameOrUUID.length() < 28) {
                user.username = usernameOrUUID;
                user.fillMissingInfo(false, null);
            } else {
                if ((usernameOrUUID = usernameOrUUID.replaceAll("[^0-9a-fA-F]", "")).length() != 32) {
                    this.textNewUser.setError((class_2561)class_2561.method_43471((String)"mapfrontiers.new_user_error_uuid_size"));
                    return;
                }
                usernameOrUUID = usernameOrUUID.toLowerCase();
                String uuid = usernameOrUUID.substring(0, 8) + "-" + usernameOrUUID.substring(8, 12) + "-" + usernameOrUUID.substring(12, 16) + "-" + usernameOrUUID.substring(16, 20) + "-" + usernameOrUUID.substring(20, 32);
                try {
                    user.uuid = UUID.fromString(uuid);
                    user.fillMissingInfo(true, null);
                }
                catch (Exception e) {
                    this.textNewUser.setError((class_2561)class_2561.method_43471((String)"mapfrontiers.new_user_error_uuid_format"));
                    return;
                }
            }
            if (group.hasUser(user)) {
                this.textNewUser.setError((class_2561)class_2561.method_43471((String)"mapfrontiers.new_user_error_user_repeated"));
                return;
            }
            group.addUser(user);
            UserElement element = new UserElement(this.field_22793, this, user);
            this.users.addElement(element);
            this.users.scrollBottom();
            this.textNewUser.method_1852("");
            this.sendChangesToServer();
        } else if (button == this.buttonDone) {
            this.closeAndReturn();
        }
    }

    public void method_25432() {
        ClientEventHandler.postUpdatedConfigEvent();
        MapFrontiersClient.setLastSettingsTab(this.tabSelected);
        ClientEventHandler.unsuscribeAllEvents((Object)this);
    }

    public void setFrontierSettings(FrontierSettings settings) {
        this.settings = settings;
        GroupElement selectedElement = (GroupElement)this.groups.getSelectedElement();
        int selectedIndex = this.groups.getSelectedIndex();
        this.groups.removeAll();
        this.groups.addElement(new GroupElement(this.field_22793, this, settings.getOPsGroup()));
        this.groups.addElement(new GroupElement(this.field_22793, this, settings.getOwnersGroup()));
        this.groups.addElement(new GroupElement(this.field_22793, this, settings.getEveryoneGroup()));
        for (SettingsGroup group : settings.getCustomGroups()) {
            this.groups.addElement(new GroupElement(this.field_22793, this, group));
        }
        this.updateGroupsActions();
        this.resetLabels();
        this.updateButtonsVisibility();
        if (selectedElement != null) {
            this.groups.selectElementIf(element -> ((GroupElement)element).getGroup().getName().equals(selectedElement.getGroup().getName()));
        }
        if (this.groups.getSelectedElement() == null) {
            this.groups.selectIndex(selectedIndex);
        }
        if (this.groups.getSelectedElement() != null) {
            this.groupClicked((GroupElement)this.groups.getSelectedElement());
        }
    }

    private void resetLabels() {
        this.labels.clear();
        this.labelTooltips.clear();
        if (this.tabSelected == Tab.Credits) {
            this.labels.add(new SimpleLabel(this.field_22793, this.actualWidth / 2, this.actualHeight / 2 - 106, SimpleLabel.Align.Center, (class_2561)class_2561.method_43471((String)"mapfrontiers.credits_created_by"), -1));
            this.labels.add(new SimpleLabel(this.field_22793, this.actualWidth / 2, this.actualHeight / 2 - 58, SimpleLabel.Align.Center, (class_2561)class_2561.method_43469((String)"mapfrontiers.credits_many_thanks", (Object[])new Object[]{Services.PLATFORM.getPlatformName()}), -1));
            this.labels.add(new SimpleLabel(this.field_22793, this.actualWidth / 2, this.actualHeight / 2 - 28, SimpleLabel.Align.Center, (class_2561)class_2561.method_43471((String)"mapfrontiers.credits_project"), 0xAAAAAA));
            this.labels.add(new SimpleLabel(this.field_22793, this.actualWidth / 2, this.actualHeight / 2 + 22, SimpleLabel.Align.Center, (class_2561)class_2561.method_43471((String)"mapfrontiers.credits_patreon"), 0xAAAAAA));
            this.labels.add(new SimpleLabel(this.field_22793, 50, this.actualHeight - 54, SimpleLabel.Align.Left, (class_2561)class_2561.method_43471((String)"mapfrontiers.credits_translation"), -1));
        } else if (this.tabSelected == Tab.General) {
            this.addLabelWithTooltip(new SimpleLabel(this.field_22793, this.actualWidth / 2 - 120, 56, SimpleLabel.Align.Left, Config.getTranslatedName("fullscreenButtons"), -2236963), Config.getTooltip("fullscreenButtons"));
            this.labels.add(new SimpleLabel(this.field_22793, this.actualWidth / 2, 90, SimpleLabel.Align.Center, (class_2561)class_2561.method_43471((String)"mapfrontiers.frontiers"), -1));
            this.addLabelWithTooltip(new SimpleLabel(this.field_22793, this.actualWidth / 2 - 300, 108, SimpleLabel.Align.Left, Config.getTranslatedName("fullscreenVisibility"), -2236963), Config.getTooltip("fullscreenVisibility"));
            this.addLabelWithTooltip(new SimpleLabel(this.field_22793, this.actualWidth / 2 - 300, 124, SimpleLabel.Align.Left, Config.getTranslatedName("fullscreenNameVisibility"), -2236963), Config.getTooltip("fullscreenNameVisibility"));
            this.addLabelWithTooltip(new SimpleLabel(this.field_22793, this.actualWidth / 2 - 300, 140, SimpleLabel.Align.Left, Config.getTranslatedName("fullscreenOwnerVisibility"), -2236963), Config.getTooltip("fullscreenOwnerVisibility"));
            this.addLabelWithTooltip(new SimpleLabel(this.field_22793, this.actualWidth / 2 + 30, 108, SimpleLabel.Align.Left, Config.getTranslatedName("minimapVisibility"), -2236963), Config.getTooltip("minimapVisibility"));
            this.addLabelWithTooltip(new SimpleLabel(this.field_22793, this.actualWidth / 2 + 30, 124, SimpleLabel.Align.Left, Config.getTranslatedName("minimapNameVisibility"), -2236963), Config.getTooltip("minimapNameVisibility"));
            this.addLabelWithTooltip(new SimpleLabel(this.field_22793, this.actualWidth / 2 + 30, 140, SimpleLabel.Align.Left, Config.getTranslatedName("minimapOwnerVisibility"), -2236963), Config.getTooltip("minimapOwnerVisibility"));
            this.addLabelWithTooltip(new SimpleLabel(this.field_22793, this.actualWidth / 2 - 120, 172, SimpleLabel.Align.Left, Config.getTranslatedName("titleAnnouncementAboveHotbar"), -2236963), Config.getTooltip("titleAnnouncementAboveHotbar"));
            this.addLabelWithTooltip(new SimpleLabel(this.field_22793, this.actualWidth / 2 - 120, 188, SimpleLabel.Align.Left, Config.getTranslatedName("announceUnnamedFrontiers"), -2236963), Config.getTooltip("announceUnnamedFrontiers"));
            this.addLabelWithTooltip(new SimpleLabel(this.field_22793, this.actualWidth / 2 - 120, 204, SimpleLabel.Align.Left, Config.getTranslatedName("hideNamesThatDontFit"), -2236963), Config.getTooltip("hideNamesThatDontFit"));
            this.addLabelWithTooltip(new SimpleLabel(this.field_22793, this.actualWidth / 2 - 120, 220, SimpleLabel.Align.Left, Config.getTranslatedName("polygonsOpacity"), -2236963), Config.getTooltip("polygonsOpacity"));
            this.addLabelWithTooltip(new SimpleLabel(this.field_22793, this.actualWidth / 2 - 120, 236, SimpleLabel.Align.Left, Config.getTranslatedName("snapDistance"), -2236963), Config.getTooltip("snapDistance"));
            this.labels.add(new SimpleLabel(this.field_22793, this.actualWidth / 2, 270, SimpleLabel.Align.Center, (class_2561)class_2561.method_43471((String)"mapfrontiers.hud"), -1));
            this.addLabelWithTooltip(new SimpleLabel(this.field_22793, this.actualWidth / 2 - 120, 290, SimpleLabel.Align.Left, Config.getTranslatedName("hud.enabled"), -2236963), Config.getTooltip("hud.enabled"));
        } else if (this.tabSelected == Tab.Groups) {
            GroupElement element;
            if (this.settings != null && (element = (GroupElement)this.groups.getSelectedElement()) != null && element.getGroup().isSpecial()) {
                SettingsGroup group = element.getGroup();
                if (group == this.settings.getOPsGroup()) {
                    this.labels.add(new SimpleLabel(this.field_22793, 250, 82, SimpleLabel.Align.Left, (class_2561)class_2561.method_43471((String)"mapfrontiers.group_ops_desc"), -2236963));
                } else if (group == this.settings.getOwnersGroup()) {
                    this.labels.add(new SimpleLabel(this.field_22793, 250, 82, SimpleLabel.Align.Left, (class_2561)class_2561.method_43471((String)"mapfrontiers.group_owners_desc"), -2236963));
                } else if (group == this.settings.getEveryoneGroup()) {
                    this.labels.add(new SimpleLabel(this.field_22793, 250, 82, SimpleLabel.Align.Left, (class_2561)class_2561.method_43471((String)"mapfrontiers.group_everyone_desc"), -2236963));
                }
            }
        } else if (this.tabSelected == Tab.Actions) {
            int x = this.actualWidth / 2 - 55;
            this.labels.add(new SimpleLabel(this.field_22793, x, 47, SimpleLabel.Align.Center, (class_2561)class_2561.method_43471((String)"mapfrontiers.create_global_frontier"), -1));
            this.labels.add(new SimpleLabel(this.field_22793, x + 60, 47, SimpleLabel.Align.Center, (class_2561)class_2561.method_43471((String)"mapfrontiers.delete_global_frontier"), -1));
            this.labels.add(new SimpleLabel(this.field_22793, x + 120, 47, SimpleLabel.Align.Center, (class_2561)class_2561.method_43471((String)"mapfrontiers.update_global_frontier"), -1));
            this.labels.add(new SimpleLabel(this.field_22793, x + 180, 53, SimpleLabel.Align.Center, (class_2561)class_2561.method_43471((String)"mapfrontiers.update_settings"), -1));
            this.labels.add(new SimpleLabel(this.field_22793, x + 240, 47, SimpleLabel.Align.Center, (class_2561)class_2561.method_43471((String)"mapfrontiers.share_personal_frontier"), -1));
        }
        if (this.tabSelected == Tab.Credits || this.tabSelected == Tab.General) {
            class_2561 key;
            this.labels.add(new SimpleLabel(this.field_22793, this.actualWidth - 48, this.actualHeight - 54, SimpleLabel.Align.Right, (class_2561)class_2561.method_43470((String)Services.PLATFORM.getModVersion()), -1));
            if (this.showKeyHint && (key = MapFrontiersClient.getOpenSettingsKey()) != null) {
                this.labels.add(new SimpleLabel(this.field_22793, this.actualWidth / 2, this.actualHeight - 54, SimpleLabel.Align.Center, (class_2561)class_2561.method_43469((String)"mapfrontiers.key.open_settings.hint", (Object[])new Object[]{key}), -1));
            }
        }
    }

    private void addLabelWithTooltip(SimpleLabel label, List<class_2561> tooltip) {
        this.labels.add(label);
        this.labelTooltips.put(label, tooltip);
    }

    private void updateButtonsVisibility() {
        this.buttonWeb.field_22764 = this.tabSelected == Tab.Credits;
        this.buttonProject.field_22764 = this.tabSelected == Tab.Credits;
        this.buttonPatreon.field_22764 = this.tabSelected == Tab.Credits;
        this.buttonFullscreenButtons.field_22764 = this.tabSelected == Tab.General;
        this.buttonFullscreenVisibility.field_22764 = this.tabSelected == Tab.General;
        this.buttonFullscreenNameVisibility.field_22764 = this.tabSelected == Tab.General;
        this.buttonFullscreenOwnerVisibility.field_22764 = this.tabSelected == Tab.General;
        this.buttonMinimapVisibility.field_22764 = this.tabSelected == Tab.General;
        this.buttonMinimapNameVisibility.field_22764 = this.tabSelected == Tab.General;
        this.buttonMinimapOwnerVisibility.field_22764 = this.tabSelected == Tab.General;
        this.ButtonTitleAnnouncementAboveHotbar.field_22764 = this.tabSelected == Tab.General;
        this.buttonAnnounceUnnamedFrontiers.field_22764 = this.tabSelected == Tab.General;
        this.buttonHideNamesThatDontFit.field_22764 = this.tabSelected == Tab.General;
        this.textPolygonsOpacity.field_22764 = this.tabSelected == Tab.General;
        this.textSnapDistance.field_22764 = this.tabSelected == Tab.General;
        this.buttonHUDEnabled.field_22764 = this.tabSelected == Tab.General;
        this.buttonEditHUD.field_22764 = this.tabSelected == Tab.General && Config.hudEnabled && this.field_22787.field_1724 != null;
        this.groups.field_22764 = this.tabSelected == Tab.Groups;
        this.users.field_22764 = this.tabSelected == Tab.Groups;
        this.groupsActions.field_22764 = this.tabSelected == Tab.Actions;
        this.textNewGroupName.field_22764 = this.tabSelected == Tab.Groups;
        this.buttonNewGroup.field_22764 = this.tabSelected == Tab.Groups;
        this.textNewUser.field_22764 = this.canAddNewUser();
        this.buttonNewUser.field_22764 = this.canAddNewUser();
        this.textGroupName.field_22764 = this.tabSelected == Tab.Groups;
    }

    public void groupClicked(GroupElement element) {
        this.groups.selectElement(element);
        this.textGroupName.method_1852(element.getGroup().getName());
        this.textGroupName.method_1888(!element.getGroup().isSpecial());
        this.textGroupName.method_1858(!element.getGroup().isSpecial());
        this.textGroupName.method_25365(false);
        this.resetLabels();
        this.updateUsers();
    }

    private void sendChangesToServer() {
        if (this.settings != null) {
            this.settings.advanceChangeCounter();
            PacketHandler.sendToServer(new PacketFrontierSettings(this.settings));
        }
    }

    private void updateUsers() {
        this.users.removeAll();
        GroupElement element = (GroupElement)this.groups.getSelectedElement();
        if (element != null && !element.getGroup().isSpecial()) {
            for (SettingsUser user : element.getGroup().getUsers()) {
                this.users.addElement(new UserElement(this.field_22793, this, user));
            }
        }
        this.buttonNewUser.field_22764 = this.canAddNewUser();
        this.textNewUser.field_22764 = this.canAddNewUser();
    }

    private void updateGroupsActions() {
        if (this.settings != null) {
            this.groupsActions.removeAll();
            this.groupsActions.addElement(new GroupActionElement(this.field_22793, this.settings.getOPsGroup(), this::actionChanged));
            this.groupsActions.addElement(new GroupActionElement(this.field_22793, this.settings.getOwnersGroup(), true, this::actionChanged));
            this.groupsActions.addElement(new GroupActionElement(this.field_22793, this.settings.getEveryoneGroup(), this::actionChanged));
            for (SettingsGroup group : this.settings.getCustomGroups()) {
                this.groupsActions.addElement(new GroupActionElement(this.field_22793, group, this::actionChanged));
            }
        }
    }

    private void actionChanged(SettingsGroup group, FrontierSettings.Action action, boolean checked) {
        if (checked) {
            group.addAction(action);
        } else {
            group.removeAction(action);
        }
        this.sendChangesToServer();
    }

    private boolean canAddNewUser() {
        if (this.tabSelected == Tab.Groups && this.groups.getSelectedElement() != null) {
            SettingsGroup group = ((GroupElement)this.groups.getSelectedElement()).getGroup();
            return !group.isSpecial();
        }
        return false;
    }

    public static enum Tab {
        Credits,
        General,
        Groups,
        Actions;

    }
}

