/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.screen;

import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.component.SimpleLabel;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.OptionButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.ShapeChunkButtons;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.ShapeVertexButtons;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.SimpleButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBoxInt;
import games.alejandrocoria.mapfrontiers.client.gui.screen.StackeableScreen;
import games.alejandrocoria.mapfrontiers.client.util.ScreenHelper;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsProfile;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.api.v2.client.IClientAPI;
import journeymap.api.v2.client.display.Context;
import journeymap.api.v2.client.fullscreen.IFullscreen;
import journeymap.api.v2.client.util.UIState;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5321;

@ParametersAreNonnullByDefault
public class NewFrontier
extends StackeableScreen {
    private final IClientAPI jmAPI;
    private float scaleFactor;
    private int actualWidth;
    private int actualHeight;
    private OptionButton buttonFrontierType;
    private OptionButton buttonFrontierMode;
    private OptionButton buttonAfterCreate;
    private ShapeVertexButtons shapeVertexButtons;
    private ShapeChunkButtons shapeChunkButtons;
    private SimpleLabel labelSize;
    private TextBoxInt textSize;
    private SimpleButton buttonCreateFrontier;
    private SimpleButton buttonCancel;
    private final List<SimpleLabel> labels;

    public NewFrontier(IClientAPI jmAPI, class_437 returnScreen) {
        super((class_2561)class_2561.method_43471((String)"mapfrontiers.title_new_frontier"), returnScreen);
        this.jmAPI = jmAPI;
        this.labels = new ArrayList<SimpleLabel>();
        ClientEventHandler.subscribeUpdatedSettingsProfileEvent((Object)this, profile -> StackeableScreen.popAndOpen(new NewFrontier(jmAPI, returnScreen)));
    }

    public void method_25426() {
        this.scaleFactor = ScreenHelper.getScaleFactorThatFit(this.field_22787, this, 344, 279);
        this.actualWidth = (int)((float)this.field_22789 * this.scaleFactor);
        this.actualHeight = (int)((float)this.field_22790 * this.scaleFactor);
        this.labels.clear();
        this.labels.add(new SimpleLabel(this.field_22793, this.actualWidth / 2 - 130, this.actualHeight / 2 - 105, SimpleLabel.Align.Left, (class_2561)class_2561.method_43471((String)"mapfrontiers.frontier_type"), -2236963));
        this.buttonFrontierType = new OptionButton(this.field_22793, this.actualWidth / 2, this.actualHeight / 2 - 107, 130, this::buttonPressed);
        this.buttonFrontierType.addOption(Config.getTranslatedEnum(Config.FilterFrontierType.Global));
        this.buttonFrontierType.addOption(Config.getTranslatedEnum(Config.FilterFrontierType.Personal));
        this.buttonFrontierType.setSelected(0);
        if (!MapFrontiersClient.isModOnServer() || MapFrontiersClient.getSettingsProfile().createFrontier != SettingsProfile.State.Enabled) {
            this.buttonFrontierType.setSelected(1);
            this.buttonFrontierType.field_22763 = false;
        }
        this.labels.add(new SimpleLabel(this.field_22793, this.actualWidth / 2 - 130, this.actualHeight / 2 - 89, SimpleLabel.Align.Left, (class_2561)class_2561.method_43471((String)"mapfrontiers.frontier_mode"), -2236963));
        this.buttonFrontierMode = new OptionButton(this.field_22793, this.actualWidth / 2, this.actualHeight / 2 - 91, 130, this::buttonPressed);
        this.buttonFrontierMode.addOption(Config.getTranslatedEnum(FrontierData.Mode.Vertex));
        this.buttonFrontierMode.addOption(Config.getTranslatedEnum(FrontierData.Mode.Chunk));
        this.buttonFrontierMode.setSelected(Config.newFrontierMode.ordinal());
        this.labels.add(new SimpleLabel(this.field_22793, this.actualWidth / 2 - 130, this.actualHeight / 2 - 73, SimpleLabel.Align.Left, (class_2561)class_2561.method_43471((String)"mapfrontiers.after_creating"), -2236963));
        this.buttonAfterCreate = new OptionButton(this.field_22793, this.actualWidth / 2, this.actualHeight / 2 - 75, 130, this::buttonPressed);
        this.buttonAfterCreate.addOption(Config.getTranslatedEnum(Config.AfterCreatingFrontier.Info));
        this.buttonAfterCreate.addOption(Config.getTranslatedEnum(Config.AfterCreatingFrontier.Edit));
        this.buttonAfterCreate.addOption(Config.getTranslatedEnum(Config.AfterCreatingFrontier.Nothing));
        this.buttonAfterCreate.setSelected(Config.afterCreatingFrontier.ordinal());
        this.shapeVertexButtons = new ShapeVertexButtons(this.field_22793, this.actualWidth / 2 - 162, this.actualHeight / 2 - 45, Config.newFrontierShape, s -> this.shapeButtonsUpdated());
        this.shapeChunkButtons = new ShapeChunkButtons(this.field_22793, this.actualWidth / 2 - 107, this.actualHeight / 2 - 45, Config.newFrontierChunkShape, s -> this.shapeButtonsUpdated());
        this.labelSize = new SimpleLabel(this.field_22793, this.actualWidth / 2 - 80, this.actualHeight / 2 + 98, SimpleLabel.Align.Left, (class_2561)class_2561.method_43470((String)""), -1);
        this.labels.add(this.labelSize);
        this.textSize = new TextBoxInt(1, 1, 999, this.field_22793, this.actualWidth / 2 + 16, this.actualHeight / 2 + 96, 64);
        this.textSize.setValueChangedCallback(value -> {
            if (Config.newFrontierMode == FrontierData.Mode.Vertex) {
                if (this.shapeVertexButtons.getShapeMeasure() == ShapeVertexButtons.ShapeMeasure.Width) {
                    if (Config.isInRange("newFrontierShapeWidth", value)) {
                        Config.newFrontierShapeWidth = value;
                    }
                } else if (this.shapeVertexButtons.getShapeMeasure() == ShapeVertexButtons.ShapeMeasure.Radius && Config.isInRange("newFrontierShapeRadius", value)) {
                    Config.newFrontierShapeRadius = value;
                }
            } else if (this.shapeChunkButtons.getShapeMeasure() == ShapeChunkButtons.ShapeMeasure.Width) {
                if (Config.isInRange("newFrontierChunkShapeWidth", value)) {
                    Config.newFrontierChunkShapeWidth = value;
                    this.shapeChunkButtons.setSize(value);
                }
            } else if (this.shapeChunkButtons.getShapeMeasure() == ShapeChunkButtons.ShapeMeasure.Length && Config.isInRange("newFrontierChunkShapeLength", value)) {
                Config.newFrontierChunkShapeLength = value;
                this.shapeChunkButtons.setSize(value);
            }
        });
        this.buttonCreateFrontier = new SimpleButton(this.field_22793, this.actualWidth / 2 - 110, this.actualHeight / 2 + 123, 100, (class_2561)class_2561.method_43471((String)"mapfrontiers.create"), this::buttonPressed);
        this.buttonCancel = new SimpleButton(this.field_22793, this.actualWidth / 2 + 10, this.actualHeight / 2 + 123, 100, (class_2561)class_2561.method_43471((String)"gui.cancel"), this::buttonPressed);
        this.method_37063((class_364)this.buttonFrontierType);
        this.method_37063((class_364)this.buttonFrontierMode);
        this.method_37063((class_364)this.buttonAfterCreate);
        this.method_37063((class_364)this.shapeVertexButtons);
        this.method_37063((class_364)this.shapeChunkButtons);
        this.method_37063((class_364)this.textSize);
        this.method_37063((class_364)this.buttonCreateFrontier);
        this.method_37063((class_364)this.buttonCancel);
        this.shapeButtonsUpdated();
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25420(graphics, mouseX, mouseY, partialTicks);
        mouseX = (int)((float)mouseX * this.scaleFactor);
        mouseY = (int)((float)mouseY * this.scaleFactor);
        if (this.scaleFactor != 1.0f) {
            graphics.method_51448().method_22903();
            graphics.method_51448().method_22905(1.0f / this.scaleFactor, 1.0f / this.scaleFactor, 1.0f);
        }
        int x1 = this.actualWidth / 2 - 172;
        int x2 = this.actualWidth / 2 + 172;
        int y1 = this.actualHeight / 2 - 117;
        int y2 = this.actualHeight / 2 + 117;
        graphics.method_25294(x1, y1, x2, y2, -955248624);
        graphics.method_25292(x1, x2, y1, -8947849);
        graphics.method_25292(x1, x2, y2, -8947849);
        graphics.method_25301(x1, y1, y2, -8947849);
        graphics.method_25301(x2, y1, y2, -8947849);
        for (class_364 child : this.method_25396()) {
            if (!(child instanceof class_4068)) continue;
            class_4068 renderable = (class_4068)child;
            renderable.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
        graphics.method_27534(this.field_22793, this.field_22785, this.actualWidth / 2, 8, -1);
        for (SimpleLabel label : this.labels) {
            if (!label.field_22764) continue;
            label.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
        if (this.scaleFactor != 1.0f) {
            graphics.method_51448().method_22909();
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        mouseX *= (double)this.scaleFactor;
        mouseY *= (double)this.scaleFactor;
        if (mouseButton == 0) {
            this.textSize.method_25402(mouseX, mouseY, mouseButton);
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        return super.method_25406(mouseX * (double)this.scaleFactor, mouseY * (double)this.scaleFactor, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double hDelta, double vDelta) {
        return super.method_25401(mouseX * (double)this.scaleFactor, mouseY * (double)this.scaleFactor, hDelta, vDelta);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.method_25403(mouseX * (double)this.scaleFactor, mouseY * (double)this.scaleFactor, button, dragX * (double)this.scaleFactor, dragY * (double)this.scaleFactor);
    }

    protected void buttonPressed(class_4185 button) {
        if (button == this.buttonFrontierMode) {
            Config.newFrontierMode = FrontierData.Mode.values()[this.buttonFrontierMode.getSelected()];
            this.shapeButtonsUpdated();
        } else if (button == this.buttonAfterCreate) {
            Config.afterCreatingFrontier = Config.AfterCreatingFrontier.values()[this.buttonAfterCreate.getSelected()];
        } else if (button == this.buttonCreateFrontier) {
            boolean personal = this.buttonFrontierType.getSelected() == 1;
            this.closeAndReturnUntil(IFullscreen.class);
            UIState uiState = this.jmAPI.getUIState(Context.UI.Fullscreen);
            if (uiState != null) {
                MapFrontiersClient.getFrontiersOverlayManager(personal).clientCreateNewfrontier((class_5321<class_1937>)uiState.dimension, this.calculateVertices(), this.calculateChunks());
            }
        } else if (button == this.buttonCancel) {
            this.closeAndReturn();
        }
    }

    public void method_25432() {
        ClientEventHandler.unsuscribeAllEvents((Object)this);
        ClientEventHandler.postUpdatedConfigEvent();
    }

    private void shapeButtonsUpdated() {
        if (Config.newFrontierMode == FrontierData.Mode.Vertex) {
            int selected;
            this.shapeVertexButtons.field_22764 = true;
            this.shapeChunkButtons.field_22764 = false;
            Config.newFrontierShape = selected = this.shapeVertexButtons.getSelected();
            if (selected == 0 || selected == 1) {
                this.labelSize.field_22764 = false;
                this.textSize.field_22764 = false;
                return;
            }
            this.labelSize.field_22764 = true;
            this.textSize.field_22764 = true;
            if (this.shapeVertexButtons.getShapeMeasure() == ShapeVertexButtons.ShapeMeasure.Width) {
                this.labelSize.setText((class_2561)class_2561.method_43471((String)"mapfrontiers.shape_width"));
                this.textSize.method_1852(String.valueOf(Config.newFrontierShapeWidth));
            } else if (this.shapeVertexButtons.getShapeMeasure() == ShapeVertexButtons.ShapeMeasure.Radius) {
                this.labelSize.setText((class_2561)class_2561.method_43471((String)"mapfrontiers.shape_radius"));
                this.textSize.method_1852(String.valueOf(Config.newFrontierShapeRadius));
            }
        } else {
            int selected;
            this.shapeVertexButtons.field_22764 = false;
            this.shapeChunkButtons.field_22764 = true;
            Config.newFrontierChunkShape = selected = this.shapeChunkButtons.getSelected();
            if (selected == 0 || selected == 1 || selected == 7) {
                this.labelSize.field_22764 = false;
                this.textSize.field_22764 = false;
                return;
            }
            this.labelSize.field_22764 = true;
            this.textSize.field_22764 = true;
            if (this.shapeChunkButtons.getShapeMeasure() == ShapeChunkButtons.ShapeMeasure.Width) {
                this.labelSize.setText((class_2561)class_2561.method_43471((String)"mapfrontiers.shape_width"));
                this.textSize.method_1852(String.valueOf(Config.newFrontierChunkShapeWidth));
                this.shapeChunkButtons.setSize(Config.newFrontierChunkShapeWidth);
            } else if (this.shapeChunkButtons.getShapeMeasure() == ShapeChunkButtons.ShapeMeasure.Length) {
                this.labelSize.setText((class_2561)class_2561.method_43471((String)"mapfrontiers.shape_length"));
                this.textSize.method_1852(String.valueOf(Config.newFrontierChunkShapeLength));
                this.shapeChunkButtons.setSize(Config.newFrontierChunkShapeLength);
            }
        }
    }

    private List<class_2338> calculateVertices() {
        if (this.field_22787.field_1724 == null || Config.newFrontierMode != FrontierData.Mode.Vertex) {
            return null;
        }
        List<class_241> shapeVertices = this.shapeVertexButtons.getVertices();
        if (shapeVertices == null) {
            return new ArrayList<class_2338>();
        }
        double radius = 0.0;
        if (this.shapeVertexButtons.getShapeMeasure() == ShapeVertexButtons.ShapeMeasure.Width) {
            radius = Config.newFrontierShapeWidth;
            if (radius < 2.0) {
                radius = 2.0;
            }
            if (shapeVertices.size() == 3) {
                radius = radius * Math.sqrt(3.0) / 3.0;
            } else if (shapeVertices.size() == 4) {
                radius = Math.sqrt(radius * radius * 2.0) / 2.0;
            }
        } else if (this.shapeVertexButtons.getShapeMeasure() == ShapeVertexButtons.ShapeMeasure.Radius && (radius = (double)Config.newFrontierShapeRadius) < 1.0) {
            radius = 1.0;
        }
        LinkedHashSet<class_2338> polygonVertices = new LinkedHashSet<class_2338>();
        class_2338 playerPos = this.field_22787.field_1724.method_24515();
        for (class_241 vertex : shapeVertices) {
            int x = (int)Math.round((double)vertex.field_1343 * radius) + playerPos.method_10263();
            int z = (int)Math.round((double)vertex.field_1342 * radius) + playerPos.method_10260();
            polygonVertices.add(new class_2338(x, 70, z));
        }
        return new ArrayList<class_2338>(polygonVertices);
    }

    private List<class_1923> calculateChunks() {
        ArrayList<class_1923> chunks;
        block11: {
            int selected;
            class_1923 playerChunk;
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block10: {
                                    if (this.field_22787.field_1724 == null || Config.newFrontierMode != FrontierData.Mode.Chunk) {
                                        return null;
                                    }
                                    chunks = new ArrayList<class_1923>();
                                    playerChunk = new class_1923(this.field_22787.field_1724.method_24515());
                                    selected = this.shapeChunkButtons.getSelected();
                                    if (selected != 1) break block10;
                                    chunks.add(playerChunk);
                                    break block11;
                                }
                                if (selected != 2) break block12;
                                int shapeWidth = Config.newFrontierChunkShapeWidth;
                                class_1923 start = new class_1923(playerChunk.field_9181 - shapeWidth / 2, playerChunk.field_9180 - shapeWidth / 2);
                                for (int i = 0; i < shapeWidth * shapeWidth; ++i) {
                                    chunks.add(new class_1923(start.field_9181 + i % shapeWidth, start.field_9180 + i / shapeWidth));
                                }
                                break block11;
                            }
                            if (selected != 3) break block13;
                            int shapeWidth = Config.newFrontierChunkShapeWidth;
                            class_1923 start = new class_1923(playerChunk.field_9181 - shapeWidth / 2, playerChunk.field_9180 - shapeWidth / 2);
                            for (int i = 0; i < shapeWidth * shapeWidth; ++i) {
                                if (i >= shapeWidth && i < shapeWidth * (shapeWidth - 1) && i % shapeWidth != 0 && i % shapeWidth != shapeWidth - 1) continue;
                                chunks.add(new class_1923(start.field_9181 + i % shapeWidth, start.field_9180 + i / shapeWidth));
                            }
                            break block11;
                        }
                        if (selected != 4) break block14;
                        int shapeWidth = Config.newFrontierChunkShapeWidth;
                        class_1923 start = new class_1923(playerChunk.field_9181 - shapeWidth / 2, playerChunk.field_9180 - shapeWidth / 2);
                        for (int z = start.field_9180; z < start.field_9180 + shapeWidth; ++z) {
                            for (int x = start.field_9181; x < start.field_9181 + shapeWidth; ++x) {
                                int deltaX = x - playerChunk.field_9181;
                                int deltaZ = z - playerChunk.field_9180;
                                if (shapeWidth % 2 == 0) {
                                    deltaX += deltaX < 0 ? 1 : 0;
                                    deltaZ += deltaZ < 0 ? 1 : 0;
                                }
                                if (Math.abs(deltaX) + Math.abs(deltaZ) > (shapeWidth - 1) / 2) continue;
                                chunks.add(new class_1923(x, z));
                            }
                        }
                        break block11;
                    }
                    if (selected != 5) break block15;
                    int shapeLength = Config.newFrontierChunkShapeLength;
                    int start = playerChunk.field_9181 - shapeLength / 2;
                    for (int i = 0; i < shapeLength; ++i) {
                        chunks.add(new class_1923(start + i, playerChunk.field_9180));
                    }
                    break block11;
                }
                if (selected != 6) break block16;
                int shapeLength = Config.newFrontierChunkShapeLength;
                int start = playerChunk.field_9180 - shapeLength / 2;
                for (int i = 0; i < shapeLength; ++i) {
                    chunks.add(new class_1923(playerChunk.field_9181, start + i));
                }
                break block11;
            }
            if (selected != 7) break block11;
            class_1923 start = new class_1923(Math.floorDiv(playerChunk.field_9181, 32) * 32, Math.floorDiv(playerChunk.field_9180, 32) * 32);
            for (int z = 0; z < 32; ++z) {
                for (int x = 0; x < 32; ++x) {
                    chunks.add(new class_1923(start.field_9181 + x, start.field_9180 + z));
                }
            }
        }
        return chunks;
    }
}

