/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.screen;

import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.client.FrontiersOverlayManager;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.component.SimpleLabel;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.IconButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.SimpleButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.ScrollBox;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.UserSharedElement;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBoxUser;
import games.alejandrocoria.mapfrontiers.client.gui.screen.StackeableScreen;
import games.alejandrocoria.mapfrontiers.common.network.PacketHandler;
import games.alejandrocoria.mapfrontiers.common.network.PacketRemoveSharedUserPersonalFrontier;
import games.alejandrocoria.mapfrontiers.common.network.PacketUpdateSharedUserPersonalFrontier;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUserShared;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_634;
import net.minecraft.class_640;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class ShareSettings
extends StackeableScreen {
    private final FrontiersOverlayManager frontiersOverlayManager;
    private FrontierOverlay frontier;
    private ScrollBox users;
    private TextBoxUser textNewUser;
    private IconButton buttonNewUser;
    private SimpleButton buttonDone;
    private final List<SimpleLabel> labels;
    private boolean canUpdate;
    private int ticksSinceLastUpdate = 0;

    public ShareSettings(FrontiersOverlayManager frontiersOverlayManager, FrontierOverlay frontier, class_437 returnScreen) {
        super((class_2561)class_2561.method_43471((String)"mapfrontiers.title_share_settings"), returnScreen);
        this.frontiersOverlayManager = frontiersOverlayManager;
        this.frontier = frontier;
        this.labels = new ArrayList<SimpleLabel>();
        ClientEventHandler.subscribeDeletedFrontierEvent((Object)this, frontierID -> {
            if (frontierID.equals(this.frontier.getId())) {
                this.closeAndReturn();
            }
        });
        ClientEventHandler.subscribeUpdatedFrontierEvent((Object)this, (frontierOverlay, playerID) -> {
            if (frontierOverlay.getId().equals(this.frontier.getId())) {
                this.frontier = frontierOverlay;
                this.updateCanUpdate();
                this.updateUsers();
                this.updateButtonsVisibility();
            }
        });
    }

    public void method_25426() {
        if (!MapFrontiersClient.isModOnServer()) {
            this.closeAndReturn();
        }
        this.users = new ScrollBox(this.field_22789 / 2 - 215, 82, 430, this.field_22790 - 128, 16);
        this.users.setElementDeletedCallback(element -> {
            SettingsUser user = ((UserSharedElement)element).getUser();
            this.frontier.removeUserShared(user);
            PacketHandler.sendToServer(new PacketRemoveSharedUserPersonalFrontier(this.frontier.getId(), user));
            this.resetLabels();
        });
        this.textNewUser = new TextBoxUser(this.field_22787, this.field_22793, this.field_22789 / 2 - 125, this.field_22790 - 61, 238);
        this.textNewUser.method_1880(38);
        this.buttonNewUser = new IconButton(this.field_22789 / 2 + 114, this.field_22790 - 61, IconButton.Type.Add, button -> this.buttonNewUserPressed());
        this.buttonNewUser.field_22764 = false;
        this.buttonDone = new SimpleButton(this.field_22793, this.field_22789 / 2 - 70, this.field_22790 - 28, 140, (class_2561)class_2561.method_43471((String)"gui.done"), this::buttonPressed);
        this.method_37063((class_364)this.buttonNewUser);
        this.method_37063((class_364)this.users);
        this.method_37063((class_364)this.textNewUser);
        this.method_37063((class_364)this.buttonDone);
        this.updateCanUpdate();
        this.updateButtonsVisibility();
        this.updateUsers();
    }

    public void method_25393() {
        ++this.ticksSinceLastUpdate;
        if (this.ticksSinceLastUpdate >= 100) {
            this.ticksSinceLastUpdate = 0;
            class_634 handler = this.field_22787.method_1562();
            if (handler == null) {
                return;
            }
            for (ScrollBox.ScrollElement element : this.users.getElements()) {
                UserSharedElement userElement = (UserSharedElement)element;
                SettingsUser user = userElement.getUser();
                class_640 networkplayerinfo = null;
                if (user.uuid != null) {
                    networkplayerinfo = handler.method_2871(user.uuid);
                } else if (!StringUtils.isBlank((CharSequence)user.username)) {
                    networkplayerinfo = handler.method_2874(user.username);
                }
                if (networkplayerinfo == null) {
                    userElement.setPingBar(0);
                    continue;
                }
                if (networkplayerinfo.method_2959() < 0) {
                    userElement.setPingBar(0);
                    continue;
                }
                if (networkplayerinfo.method_2959() < 150) {
                    userElement.setPingBar(5);
                    continue;
                }
                if (networkplayerinfo.method_2959() < 300) {
                    userElement.setPingBar(4);
                    continue;
                }
                if (networkplayerinfo.method_2959() < 600) {
                    userElement.setPingBar(3);
                    continue;
                }
                if (networkplayerinfo.method_2959() < 1000) {
                    userElement.setPingBar(2);
                    continue;
                }
                userElement.setPingBar(1);
            }
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 8, -1);
        for (SimpleLabel label : this.labels) {
            if (!label.field_22764) continue;
            label.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        for (class_364 w : this.method_25396()) {
            if (!(w instanceof ScrollBox)) continue;
            ((ScrollBox)w).mouseReleased();
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    protected void buttonPressed(class_4185 button) {
        if (button == this.buttonDone) {
            this.closeAndReturn();
        }
    }

    private void buttonNewUserPressed() {
        if (this.field_22787.field_1724 == null) {
            return;
        }
        SettingsUser user = new SettingsUser();
        String usernameOrUUID = this.textNewUser.method_1882();
        this.textNewUser.method_25365(false);
        if (StringUtils.isBlank((CharSequence)usernameOrUUID)) {
            return;
        }
        if (usernameOrUUID.length() < 28) {
            user.username = usernameOrUUID;
            user.fillMissingInfo(false, null);
        } else {
            if ((usernameOrUUID = usernameOrUUID.replaceAll("[^0-9a-fA-F]", "")).length() != 32) {
                this.textNewUser.setError((class_2561)class_2561.method_43471((String)"mapfrontiers.new_user_error_uuid_size"));
                return;
            }
            usernameOrUUID = usernameOrUUID.toLowerCase();
            String uuid = usernameOrUUID.substring(0, 8) + "-" + usernameOrUUID.substring(8, 12) + "-" + usernameOrUUID.substring(12, 16) + "-" + usernameOrUUID.substring(16, 20) + "-" + usernameOrUUID.substring(20, 32);
            try {
                user.uuid = UUID.fromString(uuid);
                user.fillMissingInfo(true, null);
            }
            catch (Exception e) {
                this.textNewUser.setError((class_2561)class_2561.method_43471((String)"mapfrontiers.new_user_error_uuid_format"));
                return;
            }
        }
        if (user.uuid == null) {
            this.textNewUser.setError((class_2561)class_2561.method_43471((String)"mapfrontiers.new_user_shared_error_user_not_found"));
            return;
        }
        class_634 handler = this.field_22787.method_1562();
        if (handler != null && handler.method_2871(user.uuid) == null) {
            this.textNewUser.setError((class_2561)class_2561.method_43471((String)"mapfrontiers.new_user_shared_error_user_not_found"));
            return;
        }
        if (user.username.equals(this.field_22787.field_1724.method_7334().getName())) {
            this.textNewUser.setError((class_2561)class_2561.method_43471((String)"mapfrontiers.new_user_shared_error_self"));
            return;
        }
        if (this.frontier.getOwner().equals(user)) {
            this.textNewUser.setError((class_2561)class_2561.method_43471((String)"mapfrontiers.new_user_shared_error_owner"));
            return;
        }
        if (this.frontier.hasUserShared(user)) {
            this.textNewUser.setError((class_2561)class_2561.method_43471((String)"mapfrontiers.new_user_shared_error_user_repeated"));
            return;
        }
        SettingsUserShared userShared = new SettingsUserShared(user, true);
        this.frontier.addUserShared(userShared);
        this.frontiersOverlayManager.clientShareFrontier(this.frontier.getId(), user);
        UserSharedElement element = new UserSharedElement(this.field_22793, this, userShared, this.canUpdate, true, this::actionChanged);
        this.users.addElement(element);
        this.users.scrollBottom();
        this.textNewUser.method_1852("");
        this.resetLabels();
    }

    public void method_25432() {
        ClientEventHandler.unsuscribeAllEvents((Object)this);
    }

    private void resetLabels() {
        this.labels.clear();
        if (!this.users.getElements().isEmpty()) {
            int x = this.field_22789 / 2 + 35;
            this.labels.add(new SimpleLabel(this.field_22793, x, 54, SimpleLabel.Align.Center, (class_2561)class_2561.method_43471((String)"mapfrontiers.update_frontier"), -1));
            this.labels.add(new SimpleLabel(this.field_22793, x + 60, 54, SimpleLabel.Align.Center, (class_2561)class_2561.method_43471((String)"mapfrontiers.update_settings"), -1));
        }
    }

    private void updateButtonsVisibility() {
        this.users.field_22764 = true;
        this.buttonNewUser.field_22764 = this.canUpdate;
        this.textNewUser.field_22764 = this.canUpdate;
    }

    private void actionChanged(SettingsUserShared user, SettingsUserShared.Action action, boolean checked) {
        if (this.field_22787.field_1724 == null) {
            return;
        }
        if (checked) {
            user.addAction(action);
        } else {
            user.removeAction(action);
        }
        if (user.getUser().equals(new SettingsUser((class_1657)this.field_22787.field_1724))) {
            if (action == SettingsUserShared.Action.UpdateSettings) {
                this.updateCanUpdate();
                this.updateUsers();
                this.updateButtonsVisibility();
            }
            this.frontier.setModified(new Date());
            ClientEventHandler.postUpdatedFrontierEvent(this.frontier, -1);
        }
        PacketHandler.sendToServer(new PacketUpdateSharedUserPersonalFrontier(this.frontier.getId(), user));
    }

    private void updateUsers() {
        this.users.removeAll();
        if (this.field_22787.field_1724 == null) {
            return;
        }
        SettingsUser player = new SettingsUser((class_1657)this.field_22787.field_1724);
        if (this.frontier.getUsersShared() != null) {
            for (SettingsUserShared user : this.frontier.getUsersShared()) {
                this.users.addElement(new UserSharedElement(this.field_22793, this, user, this.canUpdate, !user.getUser().equals(player), this::actionChanged));
            }
        }
        this.resetLabels();
    }

    private void updateCanUpdate() {
        if (this.field_22787.field_1724 == null) {
            return;
        }
        this.canUpdate = this.frontier.checkActionUserShared(new SettingsUser((class_1657)this.field_22787.field_1724), SettingsUserShared.Action.UpdateSettings);
    }
}

