/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.plugin;

import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.FullscreenMap;
import games.alejandrocoria.mapfrontiers.common.Config;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.api.v2.client.IClientAPI;
import journeymap.api.v2.client.IClientPlugin;
import journeymap.api.v2.client.JourneyMapPlugin;
import journeymap.api.v2.client.display.Context;
import journeymap.api.v2.client.event.FullscreenMapEvent;
import journeymap.api.v2.client.fullscreen.ModPopupMenu;
import journeymap.api.v2.client.fullscreen.ThemeButtonDisplay;
import journeymap.api.v2.common.event.ClientEventRegistry;
import net.minecraft.class_1937;
import net.minecraft.class_437;
import net.minecraft.class_5321;

@ParametersAreNonnullByDefault
@JourneyMapPlugin(apiVersion="2.0.0-SNAPSHOT")
public class MapFrontiersPlugin
implements IClientPlugin {
    private static FullscreenMap fullscreenMap;

    public void initialize(IClientAPI jmAPI) {
        MapFrontiersClient.setjmAPI(jmAPI);
        ClientEventRegistry.FULLSCREEN_MAP_CLICK_EVENT.subscribe("mapfrontiers", clickEvent -> {
            boolean cancel;
            if (!Config.fullscreenButtons) {
                return;
            }
            if (fullscreenMap == null) {
                return;
            }
            FullscreenMapEvent.Stage relevantStage = (fullscreenMap.isEditingVertices() || fullscreenMap.isEditingChunks()) && clickEvent.getButton() == 1 ? FullscreenMapEvent.Stage.PRE : FullscreenMapEvent.Stage.POST;
            if (clickEvent.getStage() == relevantStage && (cancel = fullscreenMap.mapClicked((class_5321<class_1937>)clickEvent.dimension, clickEvent.getLocation(), clickEvent.getButton()))) {
                clickEvent.cancel();
            }
        });
        ClientEventRegistry.FULLSCREEN_MAP_DRAG_EVENT.subscribe("mapfrontiers", mouseDraggedEvent -> {
            boolean cancel;
            if (!Config.fullscreenButtons) {
                return;
            }
            if (fullscreenMap == null) {
                return;
            }
            if (mouseDraggedEvent.getStage() == FullscreenMapEvent.Stage.PRE && (cancel = fullscreenMap.mapDragged((class_5321<class_1937>)mouseDraggedEvent.dimension, mouseDraggedEvent.getLocation()))) {
                mouseDraggedEvent.cancel();
            }
        });
        ClientEventRegistry.FULLSCREEN_MAP_MOVE_EVENT.subscribe("mapfrontiers", mouseMoveEvent -> {
            if (!Config.fullscreenButtons) {
                return;
            }
            if (fullscreenMap == null) {
                return;
            }
            fullscreenMap.mouseMoved((class_5321<class_1937>)mouseMoveEvent.dimension, mouseMoveEvent.getLocation());
        });
        ClientEventRegistry.DISPLAY_UPDATE_EVENT.subscribe("mapfrontiers", displayUpdateEvent -> {
            if (!Config.fullscreenButtons) {
                return;
            }
            if (fullscreenMap == null) {
                return;
            }
            if (displayUpdateEvent.uiState.ui == Context.UI.Fullscreen) {
                if (displayUpdateEvent.uiState.active) {
                    fullscreenMap.updateButtons();
                } else {
                    fullscreenMap.stopEditing();
                    fullscreenMap.close();
                    fullscreenMap = null;
                }
            }
        });
        ClientEventRegistry.ADDON_BUTTON_DISPLAY_EVENT.subscribe("mapfrontiers", addonButtonDisplayEvent -> {
            ThemeButtonDisplay buttonDisplay = addonButtonDisplayEvent.getThemeButtonDisplay();
            class_437 fullscreen = addonButtonDisplayEvent.getFullscreen().getScreen();
            ClientEventHandler.postAddonButtonDisplayEvent(buttonDisplay, fullscreen);
        });
        ClientEventRegistry.FULLSCREEN_POPUP_MENU_EVENT.subscribe("mapfrontiers", fullscreenPopupMenuEvent -> {
            ModPopupMenu popupMenu = fullscreenPopupMenuEvent.getPopupMenu();
            ClientEventHandler.postFullscreenPopupMenuEvent(popupMenu);
        });
        ClientEventHandler.subscribeAddonButtonDisplayEvent(MapFrontiersPlugin.class, (buttonDisplay, fullscreen) -> {
            if (!Config.fullscreenButtons) {
                return;
            }
            if (fullscreenMap == null) {
                fullscreenMap = new FullscreenMap(jmAPI);
            }
            fullscreenMap.addButtons((ThemeButtonDisplay)buttonDisplay, (class_437)fullscreen);
        });
        ClientEventHandler.subscribeFullscreenPopupMenuEvent(MapFrontiersPlugin.class, popupMenu -> {
            if (!Config.fullscreenButtons) {
                return;
            }
            if (fullscreenMap != null) {
                fullscreenMap.addPopupMenu((ModPopupMenu)popupMenu);
            }
        });
    }

    public String getModId() {
        return "mapfrontiers";
    }

    public static boolean isEditing() {
        if (!Config.fullscreenButtons) {
            return false;
        }
        return fullscreenMap != null && (fullscreenMap.isEditingVertices() || fullscreenMap.isEditingChunks());
    }
}

