/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.base.Splitter;
import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.platform.Services;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5244;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static int newFrontierShape;
    public static int newFrontierShapeWidth;
    public static int newFrontierShapeRadius;
    public static int newFrontierChunkShape;
    public static int newFrontierChunkShapeWidth;
    public static int newFrontierChunkShapeLength;
    public static FrontierData.Mode newFrontierMode;
    public static AfterCreatingFrontier afterCreatingFrontier;
    public static boolean pasteName;
    public static boolean pasteVisibility;
    public static boolean pasteColor;
    public static boolean pasteBanner;
    public static boolean pasteOptionsVisible;
    public static boolean fullscreenButtons;
    public static Visibility fullscreenVisibility;
    public static Visibility fullscreenNameVisibility;
    public static Visibility fullscreenOwnerVisibility;
    public static Visibility minimapVisibility;
    public static Visibility minimapNameVisibility;
    public static Visibility minimapOwnerVisibility;
    public static boolean titleAnnouncementAboveHotbar;
    public static boolean announceUnnamedFrontiers;
    public static boolean hideNamesThatDontFit;
    public static double polygonsOpacity;
    public static int snapDistance;
    public static FilterFrontierType filterFrontierType;
    public static FilterFrontierOwner filterFrontierOwner;
    public static String filterFrontierDimension;
    public static boolean hudEnabled;
    public static boolean hudAutoAdjustAnchor;
    public static boolean hudSnapToBorder;
    public static int hudBannerSize;
    public static HUDSlot hudSlot1;
    public static HUDSlot hudSlot2;
    public static HUDSlot hudSlot3;
    public static HUDAnchor hudAnchor;
    public static int hudXPosition;
    public static int hudYPosition;

    public static void bakeConfig() {
        newFrontierShape = (Integer)Config.CLIENT.newFrontierShape.get();
        newFrontierShapeWidth = (Integer)Config.CLIENT.newFrontierShapeWidth.get();
        newFrontierShapeRadius = (Integer)Config.CLIENT.newFrontierShapeRadius.get();
        newFrontierChunkShape = (Integer)Config.CLIENT.newFrontierChunkShape.get();
        newFrontierChunkShapeWidth = (Integer)Config.CLIENT.newFrontierChunkShapeWidth.get();
        newFrontierChunkShapeLength = (Integer)Config.CLIENT.newFrontierChunkShapeLength.get();
        newFrontierMode = (FrontierData.Mode)((Object)Config.CLIENT.newFrontierMode.get());
        afterCreatingFrontier = (AfterCreatingFrontier)((Object)Config.CLIENT.afterCreatingFrontier.get());
        pasteName = (Boolean)Config.CLIENT.pasteName.get();
        pasteVisibility = (Boolean)Config.CLIENT.pasteVisibility.get();
        pasteColor = (Boolean)Config.CLIENT.pasteColor.get();
        pasteBanner = (Boolean)Config.CLIENT.pasteBanner.get();
        pasteOptionsVisible = (Boolean)Config.CLIENT.pasteOptionsVisible.get();
        fullscreenButtons = (Boolean)Config.CLIENT.fullscreenButtons.get();
        fullscreenVisibility = (Visibility)((Object)Config.CLIENT.fullscreenVisibility.get());
        fullscreenNameVisibility = (Visibility)((Object)Config.CLIENT.fullscreenNameVisibility.get());
        fullscreenOwnerVisibility = (Visibility)((Object)Config.CLIENT.fullscreenOwnerVisibility.get());
        minimapVisibility = (Visibility)((Object)Config.CLIENT.minimapVisibility.get());
        minimapNameVisibility = (Visibility)((Object)Config.CLIENT.minimapNameVisibility.get());
        minimapOwnerVisibility = (Visibility)((Object)Config.CLIENT.minimapOwnerVisibility.get());
        titleAnnouncementAboveHotbar = (Boolean)Config.CLIENT.titleAnnouncementAboveHotbar.get();
        announceUnnamedFrontiers = (Boolean)Config.CLIENT.announceUnnamedFrontiers.get();
        hideNamesThatDontFit = (Boolean)Config.CLIENT.hideNamesThatDontFit.get();
        polygonsOpacity = (Double)Config.CLIENT.polygonsOpacity.get();
        snapDistance = (Integer)Config.CLIENT.snapDistance.get();
        filterFrontierType = (FilterFrontierType)((Object)Config.CLIENT.filterFrontierType.get());
        filterFrontierOwner = (FilterFrontierOwner)((Object)Config.CLIENT.filterFrontierOwner.get());
        filterFrontierDimension = (String)Config.CLIENT.filterFrontierDimension.get();
        hudEnabled = (Boolean)Config.CLIENT.hudEnabled.get();
        hudAutoAdjustAnchor = (Boolean)Config.CLIENT.hudAutoAdjustAnchor.get();
        hudSnapToBorder = (Boolean)Config.CLIENT.hudSnapToBorder.get();
        hudBannerSize = (Integer)Config.CLIENT.hudBannerSize.get();
        hudSlot1 = (HUDSlot)((Object)Config.CLIENT.hudSlot1.get());
        hudSlot2 = (HUDSlot)((Object)Config.CLIENT.hudSlot2.get());
        hudSlot3 = (HUDSlot)((Object)Config.CLIENT.hudSlot3.get());
        hudAnchor = (HUDAnchor)((Object)Config.CLIENT.hudAnchor.get());
        hudXPosition = (Integer)Config.CLIENT.hudXPosition.get();
        hudYPosition = (Integer)Config.CLIENT.hudYPosition.get();
    }

    private static void save() {
        Config.CLIENT.newFrontierShape.set((Object)newFrontierShape);
        Config.CLIENT.newFrontierShapeWidth.set((Object)newFrontierShapeWidth);
        Config.CLIENT.newFrontierShapeRadius.set((Object)newFrontierShapeRadius);
        Config.CLIENT.newFrontierChunkShape.set((Object)newFrontierChunkShape);
        Config.CLIENT.newFrontierChunkShapeWidth.set((Object)newFrontierChunkShapeWidth);
        Config.CLIENT.newFrontierChunkShapeLength.set((Object)newFrontierChunkShapeLength);
        Config.CLIENT.newFrontierMode.set((Object)newFrontierMode);
        Config.CLIENT.afterCreatingFrontier.set((Object)afterCreatingFrontier);
        Config.CLIENT.pasteName.set((Object)pasteName);
        Config.CLIENT.pasteVisibility.set((Object)pasteVisibility);
        Config.CLIENT.pasteColor.set((Object)pasteColor);
        Config.CLIENT.pasteBanner.set((Object)pasteBanner);
        Config.CLIENT.pasteOptionsVisible.set((Object)pasteOptionsVisible);
        Config.CLIENT.fullscreenButtons.set((Object)fullscreenButtons);
        Config.CLIENT.fullscreenVisibility.set((Object)fullscreenVisibility);
        Config.CLIENT.fullscreenNameVisibility.set((Object)fullscreenNameVisibility);
        Config.CLIENT.fullscreenOwnerVisibility.set((Object)fullscreenOwnerVisibility);
        Config.CLIENT.minimapVisibility.set((Object)minimapVisibility);
        Config.CLIENT.minimapNameVisibility.set((Object)minimapNameVisibility);
        Config.CLIENT.minimapOwnerVisibility.set((Object)minimapOwnerVisibility);
        Config.CLIENT.titleAnnouncementAboveHotbar.set((Object)titleAnnouncementAboveHotbar);
        Config.CLIENT.announceUnnamedFrontiers.set((Object)announceUnnamedFrontiers);
        Config.CLIENT.hideNamesThatDontFit.set((Object)hideNamesThatDontFit);
        Config.CLIENT.polygonsOpacity.set((Object)polygonsOpacity);
        Config.CLIENT.snapDistance.set((Object)snapDistance);
        Config.CLIENT.filterFrontierType.set((Object)filterFrontierType);
        Config.CLIENT.filterFrontierOwner.set((Object)filterFrontierOwner);
        Config.CLIENT.filterFrontierDimension.set((Object)filterFrontierDimension);
        Config.CLIENT.hudEnabled.set((Object)hudEnabled);
        Config.CLIENT.hudAutoAdjustAnchor.set((Object)hudAutoAdjustAnchor);
        Config.CLIENT.hudSnapToBorder.set((Object)hudSnapToBorder);
        Config.CLIENT.hudBannerSize.set((Object)hudBannerSize);
        Config.CLIENT.hudSlot1.set((Object)hudSlot1);
        Config.CLIENT.hudSlot2.set((Object)hudSlot2);
        Config.CLIENT.hudSlot3.set((Object)hudSlot3);
        Config.CLIENT.hudAnchor.set((Object)hudAnchor);
        Config.CLIENT.hudXPosition.set((Object)hudXPosition);
        Config.CLIENT.hudYPosition.set((Object)hudYPosition);
        CLIENT_SPEC.save();
    }

    public static boolean getVisibilityValue(Visibility visibility, boolean manual) {
        return switch (visibility.ordinal()) {
            case 1 -> true;
            case 2 -> false;
            default -> manual;
        };
    }

    public static class_2561 getTranslatedName(String name) {
        ForgeConfigSpec.ValueSpec valueSpec = Config.getValueSpec(name);
        if (valueSpec != null) {
            return class_2561.method_43471((String)valueSpec.getTranslationKey());
        }
        return class_5244.field_39003;
    }

    public static <E extends Enum<E>> class_2561 getTranslatedEnum(E value) {
        return class_2561.method_43471((String)("mapfrontiers.config." + value.name()));
    }

    public static List<class_2561> getTooltip(String name) {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        ForgeConfigSpec.ValueSpec valueSpec = Config.getValueSpec(name);
        if (valueSpec != null) {
            String lines = class_2561.method_43471((String)(valueSpec.getTranslationKey() + ".tooltip")).getString();
            for (String string : Splitter.on((String)"\n").split((CharSequence)lines)) {
                tooltip.add((class_2561)class_2561.method_43470((String)string));
            }
        }
        return tooltip;
    }

    public static String getDefault(String name) {
        ForgeConfigSpec.ValueSpec valueSpec = Config.getValueSpec(name);
        if (valueSpec != null) {
            return valueSpec.getDefault().toString();
        }
        return "";
    }

    public static boolean isInRange(String name, Object value) {
        ForgeConfigSpec.ValueSpec valueSpec = Config.getValueSpec(name);
        if (valueSpec != null) {
            return valueSpec.test(value);
        }
        return false;
    }

    private static ForgeConfigSpec.ValueSpec getValueSpec(String name) {
        return Config.getValueSpec(Arrays.asList(name.split("\\.")), CLIENT_SPEC.getSpec());
    }

    private static ForgeConfigSpec.ValueSpec getValueSpec(List<String> path, UnmodifiableConfig valueMap) {
        if (path.isEmpty()) {
            return null;
        }
        Object value = valueMap.valueMap().get(path.getFirst());
        if (value == null) {
            return null;
        }
        if (value instanceof com.electronwill.nightconfig.core.Config) {
            return Config.getValueSpec(path.subList(1, path.size()), (UnmodifiableConfig)((com.electronwill.nightconfig.core.Config)value));
        }
        return (ForgeConfigSpec.ValueSpec)value;
    }

    public static Point getHUDAnchor(HUDAnchor anchor) {
        class_310 mc = class_310.method_1551();
        Point p = new Point();
        int displayWidth = mc.method_22683().method_4489();
        int displayHeight = mc.method_22683().method_4506();
        switch (anchor.ordinal()) {
            case 0: {
                p.x = displayWidth / 2;
                break;
            }
            case 1: {
                p.x = displayWidth;
                break;
            }
            case 2: {
                p.x = displayWidth;
                p.y = displayHeight / 2;
                break;
            }
            case 3: {
                p.x = displayWidth;
                p.y = displayHeight;
                break;
            }
            case 4: {
                p.x = displayWidth / 2;
                p.y = displayHeight;
                break;
            }
            case 5: {
                p.y = displayHeight;
                break;
            }
            case 6: {
                p.y = displayHeight / 2;
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                p = Config.getMinimapCorner();
                break;
            }
            case 9: {
                p = Config.getMinimapCorner();
                if (p.y < displayHeight / 2) {
                    p.y = 0;
                    break;
                }
                if (p.y <= displayHeight / 2) break;
                p.y = displayHeight;
                break;
            }
            case 10: {
                p = Config.getMinimapCorner();
                if (p.x < displayWidth / 2) {
                    p.x = 0;
                    break;
                }
                if (p.x <= displayWidth / 2) break;
                p.x = displayWidth;
            }
        }
        return p;
    }

    public static Point getHUDOrigin(HUDAnchor anchor, int hudWidth, int hudHeight) {
        Point p = new Point();
        switch (anchor.ordinal()) {
            case 0: {
                p.x = hudWidth / 2;
                break;
            }
            case 1: {
                p.x = hudWidth;
                break;
            }
            case 2: {
                p.x = hudWidth;
                p.y = hudHeight / 2;
                break;
            }
            case 3: {
                p.x = hudWidth;
                p.y = hudHeight;
                break;
            }
            case 4: {
                p.x = hudWidth / 2;
                p.y = hudHeight;
                break;
            }
            case 5: {
                p.y = hudHeight;
                break;
            }
            case 6: {
                p.y = hudHeight / 2;
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                p = Config.getHUDOriginFromMinimap(hudWidth, hudHeight);
            }
        }
        return p;
    }

    public static Point getMinimapCorner() {
        class_310 mc = class_310.method_1551();
        Point corner = new Point();
        int displayWidth = mc.method_22683().method_4489();
        int displayHeight = mc.method_22683().method_4506();
        switch (Services.JOURNEYMAP.getMinimapPosition()) {
            case TopRight: {
                corner.x = displayWidth;
                break;
            }
            case BottomRight: {
                corner.x = displayWidth;
                corner.y = displayHeight;
                break;
            }
            case BottomLeft: {
                corner.y = displayHeight;
                break;
            }
            case TopLeft: {
                break;
            }
            case TopCenter: {
                corner.x = displayWidth / 2;
                break;
            }
            case Center: {
                corner.x = displayWidth / 2;
                corner.y = displayHeight / 2;
            }
        }
        if (Services.JOURNEYMAP.isMinimapEnabled()) {
            try {
                int minimapWidth = Services.JOURNEYMAP.getMinimapWidth();
                int minimapHeight = Services.JOURNEYMAP.getMinimapHeight();
                int translateX = Services.JOURNEYMAP.getMinimapTranslateX();
                int translateY = Services.JOURNEYMAP.getMinimapTranslateY();
                int margin = Services.JOURNEYMAP.getMinimapMargin();
                minimapWidth += margin * 2;
                minimapHeight += margin * 2;
                translateX += displayWidth / 2;
                translateY += displayHeight / 2;
                switch (Services.JOURNEYMAP.getMinimapPosition()) {
                    case TopRight: {
                        corner.x = translateX - minimapWidth / 2;
                        corner.y = translateY + minimapHeight / 2;
                        break;
                    }
                    case BottomRight: {
                        corner.x = translateX - minimapWidth / 2;
                        corner.y = translateY - minimapHeight / 2;
                        break;
                    }
                    case BottomLeft: {
                        corner.x = translateX + minimapWidth / 2;
                        corner.y = translateY - minimapHeight / 2;
                        break;
                    }
                    case TopLeft: {
                        corner.x = translateX + minimapWidth / 2;
                        corner.y = translateY + minimapHeight / 2;
                        break;
                    }
                    case TopCenter: {
                        corner.x = translateX;
                        corner.y = translateY + minimapHeight / 2;
                        break;
                    }
                    case Center: {
                        corner.x = translateX;
                        corner.y = translateY;
                    }
                }
            }
            catch (Exception e) {
                MapFrontiers.LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        return corner;
    }

    public static Point getHUDOriginFromMinimap(int hudWidth, int hudHeight) {
        Point origin = new Point();
        switch (Services.JOURNEYMAP.getMinimapPosition()) {
            case TopRight: {
                origin.x = hudWidth;
                break;
            }
            case BottomRight: {
                origin.x = hudWidth;
                origin.y = hudHeight;
                break;
            }
            case BottomLeft: {
                origin.y = hudHeight;
                break;
            }
            case TopLeft: {
                break;
            }
            case TopCenter: {
                origin.x = hudWidth / 2;
                break;
            }
            case Center: {
                origin.x = hudWidth / 2;
                origin.y = hudHeight / 2;
            }
        }
        return origin;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (ClientConfig)specPair.getLeft();
        ClientEventHandler.subscribeUpdatedConfigEvent(Config.class, Config::save);
    }

    public static class ClientConfig {
        public final ForgeConfigSpec.IntValue newFrontierShape;
        public final ForgeConfigSpec.IntValue newFrontierShapeWidth;
        public final ForgeConfigSpec.IntValue newFrontierShapeRadius;
        public final ForgeConfigSpec.IntValue newFrontierChunkShape;
        public final ForgeConfigSpec.IntValue newFrontierChunkShapeWidth;
        public final ForgeConfigSpec.IntValue newFrontierChunkShapeLength;
        public final ForgeConfigSpec.EnumValue<FrontierData.Mode> newFrontierMode;
        public final ForgeConfigSpec.EnumValue<AfterCreatingFrontier> afterCreatingFrontier;
        public final ForgeConfigSpec.BooleanValue pasteName;
        public final ForgeConfigSpec.BooleanValue pasteVisibility;
        public final ForgeConfigSpec.BooleanValue pasteColor;
        public final ForgeConfigSpec.BooleanValue pasteBanner;
        public final ForgeConfigSpec.BooleanValue pasteOptionsVisible;
        public final ForgeConfigSpec.BooleanValue fullscreenButtons;
        public final ForgeConfigSpec.EnumValue<Visibility> fullscreenVisibility;
        public final ForgeConfigSpec.EnumValue<Visibility> fullscreenNameVisibility;
        public final ForgeConfigSpec.EnumValue<Visibility> fullscreenOwnerVisibility;
        public final ForgeConfigSpec.EnumValue<Visibility> minimapVisibility;
        public final ForgeConfigSpec.EnumValue<Visibility> minimapNameVisibility;
        public final ForgeConfigSpec.EnumValue<Visibility> minimapOwnerVisibility;
        public final ForgeConfigSpec.BooleanValue titleAnnouncementAboveHotbar;
        public final ForgeConfigSpec.BooleanValue announceUnnamedFrontiers;
        public final ForgeConfigSpec.BooleanValue hideNamesThatDontFit;
        public final ForgeConfigSpec.DoubleValue polygonsOpacity;
        public final ForgeConfigSpec.IntValue snapDistance;
        public final ForgeConfigSpec.EnumValue<FilterFrontierType> filterFrontierType;
        public final ForgeConfigSpec.EnumValue<FilterFrontierOwner> filterFrontierOwner;
        public final ForgeConfigSpec.ConfigValue<String> filterFrontierDimension;
        public final ForgeConfigSpec.BooleanValue hudEnabled;
        public final ForgeConfigSpec.BooleanValue hudAutoAdjustAnchor;
        public final ForgeConfigSpec.BooleanValue hudSnapToBorder;
        public final ForgeConfigSpec.IntValue hudBannerSize;
        public final ForgeConfigSpec.EnumValue<HUDSlot> hudSlot1;
        public final ForgeConfigSpec.EnumValue<HUDSlot> hudSlot2;
        public final ForgeConfigSpec.EnumValue<HUDSlot> hudSlot3;
        public final ForgeConfigSpec.EnumValue<HUDAnchor> hudAnchor;
        public final ForgeConfigSpec.IntValue hudXPosition;
        public final ForgeConfigSpec.IntValue hudYPosition;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            this.newFrontierShape = builder.defineInRange("newFrontierShape", 0, 0, 11);
            this.newFrontierShapeWidth = builder.defineInRange("newFrontierShapeWidth", 10, 0, 999);
            this.newFrontierShapeRadius = builder.defineInRange("newFrontierShapeRadius", 20, 0, 999);
            this.newFrontierChunkShape = builder.defineInRange("newFrontierChunkShape", 0, 0, 7);
            this.newFrontierChunkShapeWidth = builder.defineInRange("newFrontierChunkShapeWidth", 5, 0, 32);
            this.newFrontierChunkShapeLength = builder.defineInRange("newFrontierChunkShapeLength", 5, 0, 32);
            this.newFrontierMode = builder.defineEnum("newFrontierMode", (Enum)FrontierData.Mode.Vertex);
            this.afterCreatingFrontier = builder.defineEnum("afterCreatingFrontier", (Enum)AfterCreatingFrontier.Info);
            this.pasteName = builder.define("pasteName", false);
            this.pasteVisibility = builder.define("pasteVisibility", true);
            this.pasteColor = builder.define("pasteColor", true);
            this.pasteBanner = builder.define("pasteBanner", true);
            this.pasteOptionsVisible = builder.define("pasteOptionsVisible", false);
            this.fullscreenButtons = builder.comment("Show buttons on fullscreen map.").translation("mapfrontiers.config.fullscreenButtons").define("fullscreenButtons", true);
            this.fullscreenVisibility = builder.comment("Force all frontier to be shown or hidden on the fullscreen map. In Manual you can decide for each frontier.").translation("mapfrontiers.config.fullscreenVisibility").defineEnum("fullscreenVisibility", (Enum)Visibility.Custom);
            this.fullscreenNameVisibility = builder.comment("Force all frontier names to be shown or hidden on the fullscreen map. In Manual you can decide for each frontier.").translation("mapfrontiers.config.fullscreenNameVisibility").defineEnum("fullscreenNameVisibility", (Enum)Visibility.Custom);
            this.fullscreenOwnerVisibility = builder.comment("Force all frontier owners to be shown or hidden on the fullscreen map. In Manual you can decide for each frontier.").translation("mapfrontiers.config.fullscreenOwnerVisibility").defineEnum("fullscreenOwnerVisibility", (Enum)Visibility.Custom);
            this.minimapVisibility = builder.comment("Force all frontier to be shown or hidden on the minimap. In Manual you can decide for each frontier.").translation("mapfrontiers.config.minimapVisibility").defineEnum("minimapVisibility", (Enum)Visibility.Custom);
            this.minimapNameVisibility = builder.comment("Force all frontier names to be shown or hidden on the minimap. In Manual you can decide for each frontier.").translation("mapfrontiers.config.minimapNameVisibility").defineEnum("minimapNameVisibility", (Enum)Visibility.Custom);
            this.minimapOwnerVisibility = builder.comment("Force all frontier owners to be shown or hidden on the minimap. In Manual you can decide for each frontier.").translation("mapfrontiers.config.minimapOwnerVisibility").defineEnum("minimapOwnerVisibility", (Enum)Visibility.Custom);
            this.titleAnnouncementAboveHotbar = builder.comment("Show the frontier announcement above the hotbar instead of showing it as a title.").translation("mapfrontiers.config.titleAnnouncementAboveHotbar").define("titleAnnouncementAboveHotbar", false);
            this.announceUnnamedFrontiers = builder.comment("Announce unnamed frontiers in chat/title.").translation("mapfrontiers.config.announceUnnamedFrontiers").define("announceUnnamedFrontiers", false);
            this.hideNamesThatDontFit = builder.comment("Hides the name if it is wider than the frontier at the zoom level it is being viewed.").translation("mapfrontiers.config.hideNamesThatDontFit").define("hideNamesThatDontFit", true);
            this.polygonsOpacity = builder.comment("Transparency of the frontier polygons. 0.0 is fully transparent and 1.0 is opaque.").translation("mapfrontiers.config.polygonsOpacity").defineInRange("polygonsOpacity", 0.4, 0.0, 1.0);
            this.snapDistance = builder.comment("Distance at which vertices are attached to nearby vertices.").translation("mapfrontiers.config.snapDistance").defineInRange("snapDistance", 8, 0, 16);
            this.filterFrontierType = builder.defineEnum("filterFrontierType", (Enum)FilterFrontierType.All);
            this.filterFrontierOwner = builder.defineEnum("filterFrontierOwner", (Enum)FilterFrontierOwner.All);
            this.filterFrontierDimension = builder.define("filterFrontierDimension", (Object)"all");
            builder.push("hud");
            this.hudEnabled = builder.comment("Show the HUD on screen.").translation("mapfrontiers.config.hud.enabled").define("enabled", true);
            this.hudAutoAdjustAnchor = builder.comment("Automatically switch to nearest anchor when HUD position is edited (on settings screen).").translation("mapfrontiers.config.hud.autoAdjustAnchor").define("autoAdjustAnchor", true);
            this.hudSnapToBorder = builder.comment("Automatically snap to closest border when HUD position is edited (on settings screen).").translation("mapfrontiers.config.hud.snapToBorder").define("snapToBorder", true);
            this.hudBannerSize = builder.comment("Size of the HUD banner.").translation("mapfrontiers.config.hud.bannerSize").defineInRange("bannerSize", 3, 1, 8);
            this.hudSlot1 = builder.comment("HUD element on slot 1.").translation("mapfrontiers.config.hud.slot1").defineEnum("slot1", (Enum)HUDSlot.Name);
            this.hudSlot2 = builder.comment("HUD element on slot 2.").translation("mapfrontiers.config.hud.slot2").defineEnum("slot2", (Enum)HUDSlot.Owner);
            this.hudSlot3 = builder.comment("HUD element on slot 3.").translation("mapfrontiers.config.hud.slot3").defineEnum("slot3", (Enum)HUDSlot.Banner);
            this.hudAnchor = builder.comment("Anchor point of the HUD. In the case of choosing the minimap as an anchor, its default position will be used as a reference in the coordinates.").translation("mapfrontiers.config.hud.anchor").defineEnum("anchor", (Enum)HUDAnchor.MinimapHorizontal);
            this.hudXPosition = builder.defineInRange("xPosition", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.hudYPosition = builder.defineInRange("yPosition", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
            builder.pop();
        }
    }

    public static enum AfterCreatingFrontier {
        Info,
        Edit,
        Nothing;

    }

    public static enum Visibility {
        Custom,
        Always,
        Never;

    }

    public static enum FilterFrontierType {
        All,
        Global,
        Personal;

    }

    public static enum FilterFrontierOwner {
        All,
        You,
        Others;

    }

    public static enum HUDSlot {
        None,
        Name,
        Owner,
        Banner;

    }

    public static enum HUDAnchor {
        ScreenTop,
        ScreenTopRight,
        ScreenRight,
        ScreenBottomRight,
        ScreenBottom,
        ScreenBottomLeft,
        ScreenLeft,
        ScreenTopLeft,
        Minimap,
        MinimapHorizontal,
        MinimapVertical;

    }

    public static class Point {
        public int x = 0;
        public int y = 0;
    }
}

