/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.event;

import com.mojang.brigadier.CommandDispatcher;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

@ParametersAreNonnullByDefault
public class EventHandler {
    private static final Map<Object, Consumer<CommandDispatcher<class_2168>>> commandRegistrationEventMap = new HashMap<Object, Consumer<CommandDispatcher<class_2168>>>();
    private static final Map<Object, Consumer<MinecraftServer>> serverStartingEventMap = new HashMap<Object, Consumer<MinecraftServer>>();
    private static final Map<Object, Consumer<MinecraftServer>> serverStoppingEventMap = new HashMap<Object, Consumer<MinecraftServer>>();
    private static final Map<Object, BiConsumer<MinecraftServer, class_3222>> playerJoinedEventMap = new HashMap<Object, BiConsumer<MinecraftServer, class_3222>>();
    private static final Map<Object, Consumer<MinecraftServer>> serverTickEventMap = new HashMap<Object, Consumer<MinecraftServer>>();

    public static void subscribeCommandRegistrationEvent(Object object, Consumer<CommandDispatcher<class_2168>> callback) {
        commandRegistrationEventMap.put(object, callback);
    }

    public static void subscribeServerStartingEvent(Object object, Consumer<MinecraftServer> callback) {
        serverStartingEventMap.put(object, callback);
    }

    public static void subscribeServerStoppingEvent(Object object, Consumer<MinecraftServer> callback) {
        serverStoppingEventMap.put(object, callback);
    }

    public static void subscribePlayerJoinedEvent(Object object, BiConsumer<MinecraftServer, class_3222> callback) {
        playerJoinedEventMap.put(object, callback);
    }

    public static void subscribeServerTickEvent(Object object, Consumer<MinecraftServer> callback) {
        serverTickEventMap.put(object, callback);
    }

    public static void unsuscribeAllEvents(Object object) {
        commandRegistrationEventMap.remove(object);
        serverStartingEventMap.remove(object);
        serverStoppingEventMap.remove(object);
        playerJoinedEventMap.remove(object);
        serverTickEventMap.remove(object);
    }

    public static void postCommandRegistrationEvent(CommandDispatcher<class_2168> dispatcher) {
        for (Consumer<CommandDispatcher<class_2168>> callback : commandRegistrationEventMap.values()) {
            callback.accept(dispatcher);
        }
    }

    public static void postServerStartingEvent(MinecraftServer server) {
        for (Consumer<MinecraftServer> callback : serverStartingEventMap.values()) {
            callback.accept(server);
        }
    }

    public static void postServerStoppingEvent(MinecraftServer server) {
        for (Consumer<MinecraftServer> callback : serverStoppingEventMap.values()) {
            callback.accept(server);
        }
    }

    public static void postPlayerJoinedEvent(MinecraftServer server, class_3222 player) {
        for (BiConsumer<MinecraftServer, class_3222> callback : playerJoinedEventMap.values()) {
            callback.accept(server, player);
        }
    }

    public static void postServerTickEvent(MinecraftServer server) {
        for (Consumer<MinecraftServer> callback : serverTickEventMap.values()) {
            callback.accept(server);
        }
    }
}

