/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.network;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.FrontiersManager;
import games.alejandrocoria.mapfrontiers.common.network.PacketFrontierCreated;
import games.alejandrocoria.mapfrontiers.common.network.PacketHandler;
import games.alejandrocoria.mapfrontiers.common.network.PacketSettingsProfile;
import games.alejandrocoria.mapfrontiers.common.settings.FrontierSettings;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

@ParametersAreNonnullByDefault
public class PacketCreateFrontier {
    public static final class_2960 CHANNEL = class_2960.method_60655((String)"mapfrontiers", (String)"packet_create_frontier");
    private class_5321<class_1937> dimension = class_1937.field_25179;
    private boolean personal = false;
    private List<class_2338> vertices;
    private List<class_1923> chunks;

    public PacketCreateFrontier() {
    }

    public PacketCreateFrontier(class_5321<class_1937> dimension, boolean personal, @Nullable List<class_2338> vertices, @Nullable List<class_1923> chunks) {
        this.dimension = dimension;
        this.personal = personal;
        this.vertices = vertices;
        this.chunks = chunks;
    }

    public static PacketCreateFrontier decode(class_2540 buf) {
        PacketCreateFrontier packet = new PacketCreateFrontier();
        try {
            if (buf.readableBytes() > 1) {
                boolean hasChunks;
                packet.dimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)buf.method_10810());
                packet.personal = buf.readBoolean();
                boolean hasVertex = buf.readBoolean();
                if (hasVertex) {
                    packet.vertices = new ArrayList<class_2338>();
                    int vertexCount = buf.readInt();
                    for (int i = 0; i < vertexCount; ++i) {
                        class_2338 vertex = class_2338.method_10092((long)buf.readLong());
                        packet.vertices.add(vertex);
                    }
                }
                if (hasChunks = buf.readBoolean()) {
                    packet.chunks = new ArrayList<class_1923>();
                    int chunksCount = buf.readInt();
                    for (int i = 0; i < chunksCount; ++i) {
                        class_1923 chunk = new class_1923(buf.readLong());
                        packet.chunks.add(chunk);
                    }
                }
            }
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error(String.format("Failed to read message for PacketCreateFrontier: %s", t));
        }
        return packet;
    }

    public void encode(class_2540 buf) {
        try {
            buf.method_10812(this.dimension.method_29177());
            buf.method_52964(this.personal);
            buf.method_52964(this.vertices != null);
            if (this.vertices != null) {
                buf.method_53002(this.vertices.size());
                for (class_2338 class_23382 : this.vertices) {
                    buf.method_52974(class_23382.method_10063());
                }
            }
            buf.method_52964(this.chunks != null);
            if (this.chunks != null) {
                buf.method_53002(this.chunks.size());
                for (class_1923 class_19232 : this.chunks) {
                    buf.method_52974(class_19232.method_8324());
                }
            }
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error(String.format("Failed to write message for PacketCreateFrontier: %s", t));
        }
    }

    public static void handle(PacketContext<PacketCreateFrontier> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            PacketCreateFrontier message = (PacketCreateFrontier)ctx.message();
            class_3222 player = ctx.sender();
            if (player == null) {
                return;
            }
            MinecraftServer server = player.field_13995;
            if (message.personal) {
                FrontierData frontier = FrontiersManager.instance.createNewPersonalFrontier(message.dimension, player, message.vertices, message.chunks);
                PacketHandler.sendToUsersWithAccess(new PacketFrontierCreated(frontier, player.method_5628()), frontier, server);
                return;
            }
            if (FrontiersManager.instance.getSettings().checkAction(FrontierSettings.Action.CreateGlobalFrontier, new SettingsUser((class_1657)player), MapFrontiers.isOPorHost(player), null)) {
                FrontierData frontier = FrontiersManager.instance.createNewGlobalFrontier(message.dimension, player, message.vertices, message.chunks);
                PacketHandler.sendToAll(new PacketFrontierCreated(frontier, player.method_5628()), server);
                return;
            }
            PacketHandler.sendTo(new PacketSettingsProfile(FrontiersManager.instance.getSettings().getProfile(player)), player);
        }
    }
}

