/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.network;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

@ParametersAreNonnullByDefault
public class PacketFrontierUpdated {
    public static final class_2960 CHANNEL = class_2960.method_60655((String)"mapfrontiers", (String)"packet_frontier_updated");
    private final FrontierData frontier;
    private int playerID = -1;

    public PacketFrontierUpdated() {
        this.frontier = new FrontierData();
    }

    public PacketFrontierUpdated(FrontierData frontier) {
        this.frontier = frontier;
    }

    public PacketFrontierUpdated(FrontierData frontier, int playerID) {
        this.frontier = frontier;
        this.playerID = playerID;
    }

    public static PacketFrontierUpdated decode(class_2540 buf) {
        PacketFrontierUpdated packet = new PacketFrontierUpdated();
        try {
            if (buf.readableBytes() > 1) {
                packet.frontier.fromBytes(buf);
                packet.playerID = buf.readInt();
            }
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error(String.format("Failed to read message for PacketFrontierUpdated: %s", t));
        }
        return packet;
    }

    public void encode(class_2540 buf) {
        try {
            this.frontier.toBytes(buf);
            buf.method_53002(this.playerID);
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error(String.format("Failed to write message for PacketFrontierUpdated: %s", t));
        }
    }

    public static void handle(PacketContext<PacketFrontierUpdated> ctx) {
        if (Side.CLIENT.equals((Object)ctx.side())) {
            PacketFrontierUpdated message = (PacketFrontierUpdated)ctx.message();
            FrontierOverlay frontierOverlay = MapFrontiersClient.getFrontiersOverlayManager(message.frontier.getPersonal()).updateFrontier(message.frontier);
            if (frontierOverlay != null) {
                ClientEventHandler.postUpdatedFrontierEvent(frontierOverlay, message.playerID);
            }
        }
    }
}

