/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.network;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

@ParametersAreNonnullByDefault
public class PacketFrontiers {
    public static final class_2960 CHANNEL = class_2960.method_60655((String)"mapfrontiers", (String)"packet_frontier");
    private final List<FrontierData> globalFrontiers = new ArrayList<FrontierData>();
    private final List<FrontierData> personalFrontiers = new ArrayList<FrontierData>();

    public void addGlobalFrontier(FrontierData frontier) {
        this.globalFrontiers.add(frontier);
    }

    public void addPersonalFrontier(FrontierData frontier) {
        this.personalFrontiers.add(frontier);
    }

    public void addGlobalFrontiers(List<FrontierData> frontiers) {
        this.globalFrontiers.addAll(frontiers);
    }

    public void addPersonalFrontiers(List<FrontierData> frontiers) {
        this.personalFrontiers.addAll(frontiers);
    }

    public static PacketFrontiers decode(class_2540 buf) {
        PacketFrontiers packet = new PacketFrontiers();
        try {
            if (buf.readableBytes() > 1) {
                FrontierData frontier;
                int i;
                int size = buf.readInt();
                for (i = 0; i < size; ++i) {
                    frontier = new FrontierData();
                    frontier.fromBytes(buf);
                    packet.addGlobalFrontier(frontier);
                }
                size = buf.readInt();
                for (i = 0; i < size; ++i) {
                    frontier = new FrontierData();
                    frontier.fromBytes(buf);
                    packet.addPersonalFrontier(frontier);
                }
            }
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error(String.format("Failed to read message for PacketFrontiers: %s", t));
        }
        return packet;
    }

    public void encode(class_2540 buf) {
        try {
            buf.method_53002(this.globalFrontiers.size());
            for (FrontierData frontier : this.globalFrontiers) {
                frontier.toBytes(buf, false);
            }
            buf.method_53002(this.personalFrontiers.size());
            for (FrontierData frontier : this.personalFrontiers) {
                frontier.toBytes(buf, false);
            }
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error(String.format("Failed to write message for PacketFrontiers: %s", t));
        }
    }

    public static void handle(PacketContext<PacketFrontiers> ctx) {
        if (Side.CLIENT.equals((Object)ctx.side())) {
            PacketFrontiers message = (PacketFrontiers)ctx.message();
            MapFrontiersClient.setFrontiersFromServer(message.globalFrontiers, message.personalFrontiers);
        }
    }
}

