/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.network;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.common.FrontiersManager;
import games.alejandrocoria.mapfrontiers.common.network.PacketFrontierSettings;
import games.alejandrocoria.mapfrontiers.common.network.PacketHandler;
import games.alejandrocoria.mapfrontiers.common.network.PacketSettingsProfile;
import games.alejandrocoria.mapfrontiers.common.settings.FrontierSettings;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

@ParametersAreNonnullByDefault
public class PacketRequestFrontierSettings {
    public static final class_2960 CHANNEL = class_2960.method_60655((String)"mapfrontiers", (String)"packet_request_frontier_settings");
    private int changeCounter;

    public PacketRequestFrontierSettings() {
        this.changeCounter = 0;
    }

    public PacketRequestFrontierSettings(int changeNonce) {
        this.changeCounter = changeNonce;
    }

    public static PacketRequestFrontierSettings decode(class_2540 buf) {
        PacketRequestFrontierSettings packet = new PacketRequestFrontierSettings();
        try {
            if (buf.readableBytes() > 1) {
                packet.changeCounter = buf.readInt();
            }
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error(String.format("Failed to read message for PacketRequestFrontierSettings: %s", t));
        }
        return packet;
    }

    public void encode(class_2540 buf) {
        try {
            buf.method_53002(this.changeCounter);
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error(String.format("Failed to write message for PacketRequestFrontierSettings: %s", t));
        }
    }

    public static void handle(PacketContext<PacketRequestFrontierSettings> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            PacketRequestFrontierSettings message = (PacketRequestFrontierSettings)ctx.message();
            class_3222 player = ctx.sender();
            if (player == null) {
                return;
            }
            FrontierSettings settings = FrontiersManager.instance.getSettings();
            if (settings.checkAction(FrontierSettings.Action.UpdateSettings, new SettingsUser((class_1657)player), MapFrontiers.isOPorHost(player), null) && settings.getChangeCounter() > message.changeCounter) {
                PacketHandler.sendTo(new PacketFrontierSettings(settings), player);
            } else {
                PacketHandler.sendTo(new PacketSettingsProfile(FrontiersManager.instance.getSettings().getProfile(player)), player);
            }
        }
    }
}

