/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.network;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.FrontiersManager;
import games.alejandrocoria.mapfrontiers.common.network.PacketFrontierUpdated;
import games.alejandrocoria.mapfrontiers.common.network.PacketHandler;
import games.alejandrocoria.mapfrontiers.common.network.PacketSettingsProfile;
import games.alejandrocoria.mapfrontiers.common.settings.FrontierSettings;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUserShared;
import games.alejandrocoria.mapfrontiers.common.util.UUIDHelper;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

@ParametersAreNonnullByDefault
public class PacketUpdateSharedUserPersonalFrontier {
    public static final class_2960 CHANNEL = class_2960.method_60655((String)"mapfrontiers", (String)"packet_update_shared_user_personal_frontier");
    private UUID frontierID;
    private final SettingsUserShared userShared;

    public PacketUpdateSharedUserPersonalFrontier() {
        this.userShared = new SettingsUserShared();
    }

    public PacketUpdateSharedUserPersonalFrontier(UUID frontierID, SettingsUserShared user) {
        this.frontierID = frontierID;
        this.userShared = user;
    }

    public static PacketUpdateSharedUserPersonalFrontier decode(class_2540 buf) {
        PacketUpdateSharedUserPersonalFrontier packet = new PacketUpdateSharedUserPersonalFrontier();
        try {
            if (buf.readableBytes() > 1) {
                packet.frontierID = UUIDHelper.fromBytes((ByteBuf)buf);
                packet.userShared.fromBytes(buf);
            }
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error(String.format("Failed to read message for PacketUpdateSharedUserPersonalFrontier: %s", t));
        }
        return packet;
    }

    public void encode(class_2540 buf) {
        try {
            UUIDHelper.toBytes((ByteBuf)buf, this.frontierID);
            this.userShared.toBytes(buf);
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error(String.format("Failed to write message for PacketUpdateSharedUserPersonalFrontier: %s", t));
        }
    }

    public static void handle(PacketContext<PacketUpdateSharedUserPersonalFrontier> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            PacketUpdateSharedUserPersonalFrontier message = (PacketUpdateSharedUserPersonalFrontier)ctx.message();
            class_3222 player = ctx.sender();
            if (player == null) {
                return;
            }
            MinecraftServer server = player.field_13995;
            SettingsUser playerUser = new SettingsUser((class_1657)player);
            FrontierData currentFrontier = FrontiersManager.instance.getFrontierFromID(message.frontierID);
            if (currentFrontier != null && currentFrontier.getPersonal()) {
                if (FrontiersManager.instance.getSettings().checkAction(FrontierSettings.Action.SharePersonalFrontier, playerUser, MapFrontiers.isOPorHost(player), currentFrontier.getOwner())) {
                    SettingsUserShared currentUserShared = currentFrontier.getUserShared(message.userShared.getUser());
                    if (currentUserShared == null) {
                        return;
                    }
                    currentUserShared.setActions(message.userShared.getActions());
                    currentFrontier.addChange(FrontierData.Change.Shared);
                    PacketHandler.sendToUsersWithAccess(new PacketFrontierUpdated(currentFrontier, player.method_5628()), currentFrontier, server);
                } else {
                    PacketHandler.sendTo(new PacketSettingsProfile(FrontiersManager.instance.getSettings().getProfile(player)), player);
                }
            }
        }
    }
}

