/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.screen.collapsible;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.animator.ProgressValueAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.widgets.CloseableScissors;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.config.collapsible.CollapsibleConfigManager;
import me.shedaniel.rei.impl.client.gui.InternalTextures;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.screen.collapsible.CollapsibleEntriesScreen;
import me.shedaniel.rei.impl.client.gui.text.TextTransformations;
import me.shedaniel.rei.impl.client.gui.widget.BatchedEntryRendererManager;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class CollapsibleEntryWidget
extends WidgetWithBounds {
    private final boolean custom;
    private final class_2960 id;
    private final class_2561 component;
    private final Collection<Slot> stacks;
    private final CollapsibleConfigManager.CollapsibleConfigObject configObject;
    private final ProgressValueAnimator<Boolean> idDrawer = ValueAnimator.ofBoolean();
    private final ProgressValueAnimator<Boolean> modIdDrawer = ValueAnimator.ofBoolean();
    private final class_4185 toggleButton;
    @Nullable
    private final class_4185 deleteButton;
    @Nullable
    private final class_4185 configureButton;
    private final ScrollingContainer scroller = new ScrollingContainer(){

        public Rectangle getBounds() {
            return new Rectangle(CollapsibleEntryWidget.this.x + CollapsibleEntryWidget.this.width / 2 - 8 * CollapsibleEntryWidget.this.rowSize, CollapsibleEntryWidget.this.y + 37, 16 * CollapsibleEntryWidget.this.rowSize, CollapsibleEntryWidget.this.height - 40);
        }

        public int getMaxScrollHeight() {
            return Math.max(0, class_3532.method_38788((int)CollapsibleEntryWidget.this.stacks.size(), (int)CollapsibleEntryWidget.this.rowSize) * 16) + 24;
        }
    };
    private int x;
    private int y;
    private int width;
    private int height;
    private int rowSize;

    public CollapsibleEntryWidget(boolean custom, class_2960 id, class_2561 component, Collection<EntryStack<?>> stacks, CollapsibleConfigManager.CollapsibleConfigObject configObject, Runnable markDirty) {
        this.custom = custom;
        this.id = id;
        this.component = component;
        this.stacks = CollectionUtils.map(stacks, stack -> Widgets.createSlot(new Rectangle(0, 0, 16, 16)).entry((EntryStack<?>)stack).disableBackground());
        this.configObject = configObject;
        this.toggleButton = new class_4185(this, 0, 0, 20, 20, (class_2561)class_2561.method_43471((String)"text.rei.collapsible.entries.toggle"), button -> {
            if (this.configObject.disabledGroups.contains(this.id)) {
                this.configObject.disabledGroups.remove(this.id);
            } else {
                this.configObject.disabledGroups.add(this.id);
            }
        }, Supplier::get){};
        this.toggleButton.method_25358(this.font.method_27525((class_5348)this.toggleButton.method_25369()) + 8);
        if (this.custom) {
            this.deleteButton = new class_4185(this, 0, 0, 20, 20, (class_2561)class_2561.method_43471((String)"text.rei.collapsible.entries.delete"), button -> {
                this.configObject.customGroups.removeIf(customEntry -> customEntry.id.equals((Object)this.id));
                markDirty.run();
            }, Supplier::get){};
            this.deleteButton.method_25358(this.font.method_27525((class_5348)this.deleteButton.method_25369()) + 8);
            this.configureButton = new class_4185(this, 0, 0, 20, 20, class_2561.method_30163(null), button -> CollapsibleEntriesScreen.setupCustom(this.id, this.component.getString(), new ArrayList(stacks), this.configObject, markDirty), Supplier::get){

                protected void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
                    super.method_48579(graphics, mouseX, mouseY, delta);
                    graphics.method_51448().method_22903();
                    graphics.method_51448().method_46416(0.0f, 0.0f, 1.0f);
                    RenderSystem.setShaderTexture((int)0, (class_2960)InternalTextures.CHEST_GUI_TEXTURE);
                    graphics.method_25302(InternalTextures.CHEST_GUI_TEXTURE, this.method_46426() + 3, this.method_46427() + 3, 0, 0, 14, 14);
                    graphics.method_51448().method_22909();
                }
            };
        } else {
            this.deleteButton = null;
            this.configureButton = null;
        }
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setWidth(int width) {
        if (this.width != width) {
            this.width = width;
            this.rowSize = Math.max(1, (width - 6) / 16);
            this.height = Math.min(42 + Math.max(class_3532.method_38788((int)this.stacks.size(), (int)this.rowSize) * 16 + 24, 24), 170);
        }
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        Rectangle lineBounds;
        this.scroller.updatePosition(delta);
        this.idDrawer.update((double)delta);
        this.modIdDrawer.update((double)delta);
        Rectangle bounds = this.getBounds();
        graphics.method_25296(bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), -8947849, -8947849);
        graphics.method_25296(bounds.x + 1, bounds.y + 1, bounds.getMaxX() - 1, bounds.getMaxY() - 1, -15395563, -15395563);
        int y = bounds.y + 4;
        if (y + 9 >= 30 && y < this.minecraft.field_1755.field_22790) {
            this.renderTextScrolling(graphics, this.component, bounds.x + 4, y, bounds.width - 8, -2236963);
        }
        if ((y += 13) + 9 >= 30 && y < this.minecraft.field_1755.field_22790) {
            lineBounds = new Rectangle(bounds.x + 4, y, bounds.width - 8, 9);
            this.idDrawer.setTo((Object)lineBounds.contains(mouseX, mouseY), ConfigObject.getInstance().isReducedMotion() ? 0L : 400L);
            try (CloseableScissors scissors = CollapsibleEntryWidget.scissor(graphics, lineBounds);){
                graphics.method_51448().method_22903();
                graphics.method_51448().method_22904(0.0, -this.idDrawer.progress() * 10.0, 0.0);
                graphics.method_27535(this.font, (class_2561)class_2561.method_43469((String)"text.rei.collapsible.entries.count", (Object[])new Object[]{"" + this.stacks.size()}), bounds.x + 4, y, -5592406);
                boolean enabled = !this.configObject.disabledGroups.contains(this.id);
                class_5250 sideText = class_2561.method_43471((String)("text.rei.collapsible.entries.enabled." + enabled));
                graphics.method_27535(this.font, (class_2561)sideText, bounds.getMaxX() - 4 - this.font.method_27525((class_5348)sideText), y, enabled ? -581566635 : -570469035);
                this.renderTextScrolling(graphics, (class_2561)class_2561.method_43470((String)this.id.toString()), bounds.x + 4, y + 10, bounds.width - 8, -8947849);
                graphics.method_51448().method_22909();
            }
        }
        if ((y += 10) + 9 >= 30 && y < this.minecraft.field_1755.field_22790) {
            lineBounds = new Rectangle(bounds.x + 4, y, bounds.width - 8, 9);
            this.modIdDrawer.setTo((Object)lineBounds.contains(mouseX, mouseY), ConfigObject.getInstance().isReducedMotion() ? 0L : 400L);
            int xo = graphics.method_27535(this.font, (class_2561)class_2561.method_43471((String)"text.rei.collapsible.entries.source").method_27693(" "), bounds.x + 4, y, -5592406);
            try (CloseableScissors scissors = CollapsibleEntryWidget.scissor(graphics, lineBounds);){
                graphics.method_51448().method_22903();
                if (this.custom) {
                    this.renderTextScrolling(graphics, TextTransformations.applyRainbow(class_2561.method_43471((String)"text.rei.collapsible.entries.source.custom").method_30937(), xo - 1, y), xo - 1, y, bounds.getWidth() - 8, -5592406);
                } else {
                    graphics.method_51448().method_22904(0.0, -this.modIdDrawer.progress() * 10.0, 0.0);
                    this.renderTextScrolling(graphics, (class_2561)class_2561.method_43470((String)ClientHelper.getInstance().getModFromModId(this.id.method_12836())), xo - 1, y, bounds.getMaxX() - 4 - (xo - 1), -8947849);
                    this.renderTextScrolling(graphics, (class_2561)class_2561.method_43470((String)this.id.method_12836().toString()), xo - 1, y + 10, bounds.getMaxX() - 4 - (xo - 1), -8947849);
                }
                graphics.method_51448().method_22909();
            }
        }
        this.renderStacks(graphics, mouseX, mouseY, delta, bounds, y);
        bounds.y = this.y;
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.0f, 400.0f);
        this.toggleButton.method_46421(bounds.getMaxX() - 4 - this.toggleButton.method_25368());
        this.toggleButton.method_46419(bounds.getMaxY() - 4 - this.toggleButton.method_25364());
        this.toggleButton.method_25394(graphics, mouseX, mouseY, delta);
        if (this.toggleButton.method_25405((double)mouseX, (double)mouseY)) {
            ScreenOverlayImpl.getInstance().clearTooltips();
        }
        if (this.custom) {
            this.deleteButton.method_46421(this.toggleButton.method_46426() - 2 - this.deleteButton.method_25368());
            this.deleteButton.method_46419(bounds.getMaxY() - 4 - this.deleteButton.method_25364());
            this.deleteButton.method_25394(graphics, mouseX, mouseY, delta);
            if (this.deleteButton.method_25405((double)mouseX, (double)mouseY)) {
                ScreenOverlayImpl.getInstance().clearTooltips();
            }
            this.configureButton.method_46421(this.deleteButton.method_46426() - 2 - this.configureButton.method_25368());
            this.configureButton.method_46419(bounds.getMaxY() - 4 - this.configureButton.method_25364());
            this.configureButton.method_25394(graphics, mouseX, mouseY, delta);
            if (this.configureButton.method_25405((double)mouseX, (double)mouseY)) {
                ScreenOverlayImpl.getInstance().clearTooltips();
            }
        }
        graphics.method_51448().method_22909();
    }

    private void renderStacks(class_332 graphics, int mouseX, int mouseY, float delta, Rectangle bounds, int y) {
        graphics.method_51448().method_22903();
        try (CloseableScissors outerScissors = CollapsibleEntryWidget.scissor(graphics, new Rectangle(bounds.x, y, bounds.width, bounds.getMaxY() - 3 - y));){
            y = bounds.y + 37 - this.scroller.scrollAmountInt();
            int x = bounds.getCenterX() - 8 * this.rowSize;
            int xIndex = 0;
            graphics.method_51448().method_46416(0.0f, 0.0f, 100.0f);
            BatchedEntryRendererManager<EntryWidget> manager = new BatchedEntryRendererManager<EntryWidget>();
            for (Slot stack : this.stacks) {
                if (y + 16 >= 30 && y + 16 >= bounds.y + 37) {
                    stack.getBounds().setBounds(x + 16 * xIndex - 1, y - 1, 18, 18);
                    manager.add((EntryWidget)stack);
                }
                if (++xIndex < this.rowSize) continue;
                xIndex = 0;
                if ((y += 16) < bounds.getMaxY() && y < this.minecraft.field_1755.field_22790) continue;
                break;
            }
            try (CloseableScissors scissors = CollapsibleEntryWidget.scissor(graphics, new Rectangle(x, bounds.y + 37, 16 * this.rowSize, bounds.getMaxY() - 4 - (bounds.y + 37)));){
                manager.render(graphics, mouseX, mouseY, delta);
            }
            graphics.method_51448().method_46416(0.0f, 0.0f, 300.0f);
            if (this.stacks.size() > this.rowSize * 3) {
                class_289 tesselator = class_289.method_1348();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShader(class_757::method_34540);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Matrix4f matrix = graphics.method_51448().method_23760().method_23761();
                class_287 buffer = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
                buffer.method_22918(matrix, (float)(this.x + 1), (float)(this.y + this.height - 1), 0.0f).method_39415(-16777216);
                buffer.method_22918(matrix, (float)(this.x + this.width - 1), (float)(this.y + this.height - 1), 0.0f).method_39415(-16777216);
                buffer.method_22918(matrix, (float)(this.x + this.width - 1), (float)(this.y + this.height - 40), 0.0f).method_39415(0);
                buffer.method_22918(matrix, (float)(this.x + 1), (float)(this.y + this.height - 40), 0.0f).method_39415(0);
                class_286.method_43433((class_9801)buffer.method_60800());
                RenderSystem.disableBlend();
            }
        }
        graphics.method_51448().method_22909();
    }

    private void renderTextScrolling(class_332 graphics, class_2561 text, int x, int y, int width, int color) {
        this.renderTextScrolling(graphics, text.method_30937(), x, y, width, color);
    }

    private void renderTextScrolling(class_332 graphics, class_5481 text, int x, int y, int width, int color) {
        try (CloseableScissors scissors = CollapsibleEntryWidget.scissor(graphics, new Rectangle(x, y, width, y + 9));){
            int textWidth = this.font.method_30880(text);
            if (textWidth > width) {
                graphics.method_51448().method_22903();
                float textX = (float)(System.currentTimeMillis() % (long)((textWidth + 10) * textWidth / 3)) / (float)textWidth * 3.0f;
                graphics.method_51448().method_46416(-textX, 0.0f, 0.0f);
                graphics.method_35720(this.font, text, x + width - textWidth - 10, y, color);
                graphics.method_35720(this.font, text, x + width, y, color);
                graphics.method_51448().method_22909();
            } else {
                graphics.method_35720(this.font, text, x, y, color);
            }
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double amountX, double amountY) {
        if (this.scroller.getMaxScroll() > 0 && this.scroller.getBounds().contains(mouseX, mouseY) && amountY != 0.0 && (amountY < 0.0 || this.scroller.scrollAmountInt() != 0) && (amountY > 0.0 || this.scroller.scrollAmountInt() != this.scroller.getMaxScroll())) {
            this.scroller.offset(ClothConfigInitializer.getScrollStep() * -amountY, true);
            return true;
        }
        return false;
    }

    public List<? extends class_364> method_25396() {
        if (this.custom) {
            return List.of(this.toggleButton, this.deleteButton, this.configureButton);
        }
        return List.of(this.toggleButton);
    }
}

