/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.registry.ReloadListenerRegistry;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.List;
import me.shedaniel.clothconfig2.api.LazyResettable;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1921;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_332;
import net.minecraft.class_3902;
import net.minecraft.class_4668;
import net.minecraft.class_6367;
import net.minecraft.class_757;
import net.minecraft.class_8251;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

public class CachedEntryListRender {
    public static final int RESOLUTION = 64;
    public static class_1043 cachedTexture;
    public static class_2960 cachedTextureLocation;
    public static Long2LongMap hash;
    public static LazyResettable<class_1921> renderType;

    public static void refresh() {
        if (ConfigObject.getInstance().doesCacheEntryRendering()) {
            InternalLogger.getInstance().info("Refreshing cached entry list texture...");
        }
        if (cachedTextureLocation != null) {
            class_310.method_1551().method_1531().method_4615(cachedTextureLocation);
            cachedTextureLocation = null;
            renderType.reset();
        }
        if (cachedTexture != null) {
            cachedTexture.close();
            cachedTexture = null;
        }
        hash = new Long2LongOpenHashMap();
    }

    @Nullable
    public static Sprite get(EntryStack<?> stack) {
        if (stack.getType() == VanillaEntryTypes.ITEM) {
            long hashExact;
            long hashOrDefault;
            if (stack.getNullable(EntryStack.Settings.RENDERER) != null) {
                return null;
            }
            if (cachedTexture == null) {
                CachedEntryListRender.prepare();
            }
            if ((hashOrDefault = hash.getOrDefault(hashExact = EntryStacks.hashExact(stack), -1L)) != -1L) {
                int x = (int)(hashOrDefault >> 32);
                int y = (int)(hashOrDefault & 0xFFFFFFFFL);
                float width = cachedTexture.method_4525().method_4307();
                float height = cachedTexture.method_4525().method_4307();
                return new Sprite((float)(x * 64) / width, (float)((x + 1) * 64) / width, (float)(y * 64) / height, (float)((y + 1) * 64) / height);
            }
        }
        return null;
    }

    private static void prepare() {
        int side = 4;
        List<EntryStack<?>> list = EntryRegistry.getInstance().getPreFilteredList();
        while (side * side < list.size()) {
            ++side;
        }
        int width = side * 64;
        int height = side * 64;
        InternalLogger.getInstance().info("Preparing cached texture with size %sx%s for %sx%s entries", width, height, side, side);
        hash = new Long2LongOpenHashMap(list.size() + 10);
        class_310 minecraft = class_310.method_1551();
        class_6367 target = new class_6367(width, height, true, false);
        target.method_1235(true);
        Matrix4f projectionMatrix = new Matrix4f().setOrtho(0.0f, (float)width, (float)height, 0.0f, 1000.0f, 3000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)projectionMatrix, (class_8251)class_8251.field_43361);
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        modelViewStack.identity();
        modelViewStack.translate(0.0f, 0.0f, -2000.0f);
        RenderSystem.applyModelViewMatrix();
        class_308.method_24211();
        Rectangle bounds = new Rectangle();
        class_332 graphics = new class_332(minecraft, minecraft.method_22940().method_23000());
        int index = 0;
        for (EntryStack<?> stack : list) {
            int x = index % side;
            int y = index / side;
            bounds.setBounds(x * 64, y * 64, 64, 64);
            stack.getDefinition().getRenderer().render(stack, graphics, bounds, -1, -1, 0.0f);
            hash.put(EntryStacks.hashExact(stack), CachedEntryListRender.pack(x, y));
            ++index;
        }
        class_1011 nativeImage = new class_1011(width, height, false);
        RenderSystem.bindTexture((int)target.method_30277());
        nativeImage.method_4327(0, false);
        nativeImage.method_4319();
        cachedTexture = new class_1043(nativeImage);
        cachedTextureLocation = minecraft.method_1531().method_4617("rei_cached_entries", cachedTexture);
        renderType.reset();
        target.method_1238();
        class_310.method_1551().field_1769.method_35774();
        class_310.method_1551().method_1522().method_1235(true);
        modelViewStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
    }

    private static long pack(int x, int y) {
        return (long)x << 32 | (long)y & 0xFFFFFFFFL;
    }

    static {
        hash = new Long2LongOpenHashMap();
        renderType = new LazyResettable(() -> class_1921.method_24048((String)"rei_cache", (class_293)class_290.field_1585, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new class_4668.class_4683(cachedTextureLocation, false, false)).method_34578(new class_4668.class_5942(class_757::method_34542)).method_23617(false)));
        ReloadListenerRegistry.register((class_3264)class_3264.field_14188, (barrier, resourceManager, preparationProfiler, reloadProfiler, preparationExecutor, reloadExecutor) -> barrier.method_18352((Object)class_3902.field_17274).thenRunAsync(CachedEntryListRender::refresh, reloadExecutor));
    }

    public static class Sprite {
        public final float u0;
        public final float u1;
        public final float v0;
        public final float v1;

        public Sprite(float u0, float u1, float v0, float v1) {
            this.u0 = u0;
            this.u1 = u1;
            this.v0 = v0;
            this.v1 = v1;
        }
    }
}

