/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays.tag;

import com.mojang.serialization.DataResult;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.impl.NetworkAggregator;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.transformers.SplitPacketTransformer;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.plugin.common.displays.tag.TagNode;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class TagNodes {
    public static final class_2960 REQUEST_TAGS_PACKET_C2S = class_2960.method_60655((String)"roughlyenoughitems", (String)"request_tags_c2s");
    public static final class_2960 REQUEST_TAGS_PACKET_S2C = class_2960.method_60655((String)"roughlyenoughitems", (String)"request_tags_s2c");
    public static final Map<String, class_5321<? extends class_2378<?>>> TAG_DIR_MAP = new HashMap();
    public static final ThreadLocal<String> CURRENT_TAG_DIR = new ThreadLocal();
    public static final Map<String, Map<CollectionWrapper<?>, RawTagData>> RAW_TAG_DATA_MAP = new ConcurrentHashMap();
    public static final Map<class_5321<? extends class_2378<?>>, Map<class_2960, TagData>> TAG_DATA_MAP = new HashMap();
    public static Map<class_5321<? extends class_2378<?>>, Consumer<Consumer<DataResult<Map<class_2960, TagData>>>>> requestedTags = new HashMap();

    private static void writeResourceLocation(class_2540 buf, class_2960 location) {
        if (location.method_12836().equals("minecraft")) {
            buf.method_10814(location.method_12832());
        } else {
            buf.method_10814(location.toString());
        }
    }

    public static void init() {
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> Client::init);
        if (Platform.getEnvironment() != Env.CLIENT) {
            NetworkAggregator.registerS2CType((class_2960)REQUEST_TAGS_PACKET_S2C, Collections.singletonList(new SplitPacketTransformer()));
        }
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (class_2960)REQUEST_TAGS_PACKET_C2S, Collections.singletonList(new SplitPacketTransformer()), (buf, context) -> {
            UUID uuid = buf.method_10790();
            class_5321 resourceKey = class_5321.method_29180((class_2960)buf.method_10810());
            class_9129 newBuf = new class_9129(Unpooled.buffer(), context.registryAccess());
            newBuf.method_10797(uuid);
            Map dataMap = TAG_DATA_MAP.getOrDefault(resourceKey, Collections.emptyMap());
            newBuf.method_53002(dataMap.size());
            for (Map.Entry entry : dataMap.entrySet()) {
                TagNodes.writeResourceLocation((class_2540)newBuf, (class_2960)entry.getKey());
                ((TagData)entry.getValue()).toNetwork((class_2540)newBuf);
            }
            NetworkManager.sendToPlayer((class_3222)((class_3222)context.getPlayer()), (class_2960)REQUEST_TAGS_PACKET_S2C, (class_9129)newBuf);
        });
    }

    @Environment(value=EnvType.CLIENT)
    public static void requestTagData(class_5321<? extends class_2378<?>> resourceKey, Consumer<DataResult<Map<class_2960, TagData>>> callback) {
        if (class_310.method_1551().method_1576() != null) {
            callback.accept((DataResult<Map<class_2960, TagData>>)DataResult.success(TAG_DATA_MAP.get(resourceKey)));
        } else if (!NetworkManager.canServerReceive((class_2960)REQUEST_TAGS_PACKET_C2S)) {
            callback.accept((DataResult<Map<class_2960, TagData>>)DataResult.error(() -> "Cannot request tags from server"));
        } else if (requestedTags.containsKey(resourceKey)) {
            requestedTags.get(resourceKey).accept(callback);
            callback.accept((DataResult<Map<class_2960, TagData>>)DataResult.success(TAG_DATA_MAP.getOrDefault(resourceKey, Collections.emptyMap())));
        } else {
            class_9129 buf = new class_9129(Unpooled.buffer(), BasicDisplay.registryAccess());
            UUID uuid = UUID.randomUUID();
            buf.method_10797(uuid);
            buf.method_10812(resourceKey.method_29177());
            Client.nextUUID = uuid;
            Client.nextResourceKey = resourceKey;
            CopyOnWriteArrayList<Consumer<DataResult<Map<class_2960, TagData>>>> callbacks = new CopyOnWriteArrayList<Consumer<DataResult<Map<class_2960, TagData>>>>();
            callbacks.add(callback);
            Client.nextCallback = mapDataResult -> {
                requestedTags.put(resourceKey, c -> c.accept(mapDataResult));
                for (Consumer consumer : callbacks) {
                    consumer.accept(mapDataResult);
                }
            };
            requestedTags.put(resourceKey, callbacks::add);
            NetworkManager.sendToServer((class_2960)REQUEST_TAGS_PACKET_C2S, (class_9129)buf);
        }
    }

    public static <T> void create(class_6862<T> tagKey, Consumer<DataResult<TagNode<T>>> callback) {
        class_2378 registry = (class_2378)class_7923.field_41167.method_29107(tagKey.comp_326());
        TagNodes.requestTagData(tagKey.comp_326(), result -> callback.accept(result.flatMap(dataMap -> dataMap != null ? TagNodes.resolveTag(tagKey, registry, dataMap).orElse(DataResult.error(() -> "No tag data")) : DataResult.error(() -> "No tag data"))));
    }

    private static <T> Optional<DataResult<TagNode<T>>> resolveTag(class_6862<T> tagKey, class_2378<T> registry, Map<class_2960, TagData> tagDataMap) {
        TagData tagData = tagDataMap.get(tagKey.comp_327());
        if (tagData == null) {
            return Optional.empty();
        }
        TagNode<T> self = TagNode.ofReference(tagKey);
        ArrayList<class_6880> holders = new ArrayList<class_6880>();
        IntListIterator intListIterator = tagData.otherElements().iterator();
        while (intListIterator.hasNext()) {
            int element = (Integer)intListIterator.next();
            Optional holder = registry.method_40265(element);
            if (!holder.isPresent()) continue;
            holders.add((class_6880)holder.get());
        }
        if (!holders.isEmpty()) {
            self.addValuesChild((class_6885<T>)class_6885.method_40242(holders));
        }
        for (class_2960 childTagId : tagData.otherTags()) {
            Optional<DataResult<TagNode<T>>> resultOptional;
            class_6862 childTagKey = class_6862.method_40092((class_5321)tagKey.comp_326(), (class_2960)childTagId);
            if (!registry.method_40266(childTagKey).isPresent() || !(resultOptional = TagNodes.resolveTag(childTagKey, registry, tagDataMap)).isPresent()) continue;
            DataResult result = resultOptional.get();
            if (result.error().isPresent()) {
                return Optional.of(DataResult.error(() -> ((DataResult.Error)result.error().get()).message()));
            }
            self.addChild((TagNode)result.result().get());
        }
        return Optional.of(DataResult.success(self));
    }

    private static class Client {
        public static UUID nextUUID;
        public static class_5321<? extends class_2378<?>> nextResourceKey;
        public static Consumer<DataResult<Map<class_2960, TagData>>> nextCallback;

        private Client() {
        }

        private static void init() {
            ClientLifecycleEvent.CLIENT_LEVEL_LOAD.register(world -> requestedTags.clear());
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (class_2960)REQUEST_TAGS_PACKET_S2C, (buf, context) -> {
                UUID uuid = buf.method_10790();
                if (nextUUID.equals(uuid)) {
                    HashMap<class_2960, TagData> map = new HashMap<class_2960, TagData>();
                    int count = buf.readInt();
                    for (int i = 0; i < count; ++i) {
                        map.put(buf.method_10810(), TagData.fromNetwork((class_2540)buf));
                    }
                    TAG_DATA_MAP.put(nextResourceKey, map);
                    nextCallback.accept((DataResult<Map<class_2960, TagData>>)DataResult.success(map));
                    nextUUID = null;
                    nextResourceKey = null;
                    nextCallback = null;
                }
            });
        }
    }

    public record TagData(IntList otherElements, List<class_2960> otherTags) {
        private static TagData fromNetwork(class_2540 buf) {
            int count = buf.method_10816();
            IntArrayList otherElements = new IntArrayList(count + 1);
            for (int i = 0; i < count; ++i) {
                otherElements.add(buf.method_10816());
            }
            count = buf.method_10816();
            ArrayList<class_2960> otherTags = new ArrayList<class_2960>(count + 1);
            for (int i = 0; i < count; ++i) {
                otherTags.add(buf.method_10810());
            }
            return new TagData((IntList)otherElements, otherTags);
        }

        private void toNetwork(class_2540 buf) {
            buf.method_10804(this.otherElements.size());
            IntListIterator intListIterator = this.otherElements.iterator();
            while (intListIterator.hasNext()) {
                int integer = (Integer)intListIterator.next();
                buf.method_10804(integer);
            }
            buf.method_10804(this.otherTags.size());
            for (class_2960 tag : this.otherTags) {
                TagNodes.writeResourceLocation(buf, tag);
            }
        }
    }

    public record RawTagData(List<class_2960> otherElements, List<class_2960> otherTags) {
    }

    public static class CollectionWrapper<T> {
        private final Collection<T> collection;

        public CollectionWrapper(Collection<T> collection) {
            this.collection = collection;
        }

        public boolean equals(Object obj) {
            return obj instanceof CollectionWrapper && ((CollectionWrapper)obj).collection == this.collection;
        }

        public int hashCode() {
            return System.identityHashCode(this.collection);
        }
    }
}

