/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.styledplayerlist;

import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import eu.pb4.styledplayerlist.CardboardWarning;
import eu.pb4.styledplayerlist.GenericModInfo;
import eu.pb4.styledplayerlist.SPLHelper;
import eu.pb4.styledplayerlist.access.PlayerListViewerHolder;
import eu.pb4.styledplayerlist.command.Commands;
import eu.pb4.styledplayerlist.config.ConfigManager;
import eu.pb4.styledplayerlist.config.PlayerListStyle;
import eu.pb4.styledplayerlist.config.data.ConfigData;
import java.util.LinkedHashMap;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_266;
import net.minecraft.class_269;
import net.minecraft.class_274;
import net.minecraft.class_2772;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerList
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger((String)"Styled Player List");
    public static final String ID = "styledplayerlist";
    public static final class_269 SCOREBOARD = new class_269();
    public static final String OBJECTIVE_NAME = "\u25a0SPL_OBJ";
    public static final class_266 SCOREBOARD_OBJECTIVE = new class_266(SCOREBOARD, "\u25a0SPL_OBJ", class_274.field_1468, (class_2561)class_2561.method_43473(), class_274.class_275.field_1472, false, null);
    public static final Event<PlayerListStyleLoad> PLAYER_LIST_STYLE_LOAD = EventFactory.createArrayBacked(PlayerListStyleLoad.class, callbacks -> styleHelper -> {
        for (PlayerListStyleLoad callback : callbacks) {
            callback.onPlayerListUpdate(styleHelper);
        }
    });

    public void onInitialize() {
        GenericModInfo.build((ModContainer)FabricLoader.getInstance().getModContainer(ID).get());
        Commands.register();
        ServerLifecycleEvents.SERVER_STARTED.register(s -> {
            ConfigManager.loadConfig();
            CardboardWarning.checkAndAnnounce();
        });
        Placeholders.registerChangeEvent((a, b) -> ConfigManager.rebuildStyled());
    }

    private void tick(MinecraftServer server) {
        if (ConfigManager.isEnabled()) {
            ConfigData config = ConfigManager.getConfig().configData;
            for (class_3222 player : server.method_3760().method_14571()) {
                long x = System.nanoTime();
                if (!SPLHelper.shouldSendPlayerList(player) || player.field_13987 == null) continue;
                int tick = server.method_3780();
                PlayerListViewerHolder holder = (PlayerListViewerHolder)player.field_13987;
                PlayerListStyle style = holder.styledPlayerList$getStyleObject();
                if (tick % style.updateRate == 0) {
                    PlaceholderContext context = PlaceholderContext.of((class_3222)player, (PlaceholderContext.ViewObject)SPLHelper.PLAYER_LIST_VIEW);
                    int animationTick = holder.styledPlayerList$getAndIncreaseAnimationTick();
                    player.field_13987.method_14364((class_2596)new class_2772(style.getHeader(context, animationTick), style.getFooter(context, animationTick)));
                }
                if (config.playerName.playerNameUpdateRate > 0L && (long)tick % config.playerName.playerNameUpdateRate == 0L) {
                    holder.styledPlayerList$updateName();
                }
                player.method_7353((class_2561)class_2561.method_43470((String)(tick + " | " + (float)(System.nanoTime() - x) / 1000000.0f)), true);
            }
        }
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)ID, (String)path);
    }

    public static String getPlayersStyle(class_3222 player) {
        return ((PlayerListViewerHolder)player.field_13987).styledPlayerList$getStyle();
    }

    public static void setPlayersStyle(class_3222 player, String key) {
        ((PlayerListViewerHolder)player).styledPlayerList$setStyle(key);
    }

    public static void addUpdateSkipCheck(ModCompatibility check) {
        SPLHelper.COMPATIBILITY.add(check);
    }

    @FunctionalInterface
    public static interface PlayerListStyleLoad {
        public void onPlayerListUpdate(StyleHelper var1);
    }

    public record StyleHelper(LinkedHashMap<String, PlayerListStyle> styles) {
        public void addStyle(PlayerListStyle style) {
            this.styles.put(style.id, style);
        }

        public void removeStyle(PlayerListStyle style) {
            this.styles.remove(style.id, style);
        }
    }

    public static interface ModCompatibility {
        public boolean check(class_3222 var1);
    }
}

