/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.styledplayerlist.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import eu.pb4.predicate.api.GsonPredicateSerializer;
import eu.pb4.predicate.api.MinecraftPredicate;
import eu.pb4.styledplayerlist.PlayerList;
import eu.pb4.styledplayerlist.config.Config;
import eu.pb4.styledplayerlist.config.DefaultValues;
import eu.pb4.styledplayerlist.config.PlayerListStyle;
import eu.pb4.styledplayerlist.config.data.ConfigData;
import eu.pb4.styledplayerlist.config.data.StyleData;
import eu.pb4.styledplayerlist.config.data.legacy.LegacyConfigData;
import eu.pb4.styledplayerlist.config.data.legacy.LegacyStyleData;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigManager {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().setLenient().registerTypeHierarchyAdapter(MinecraftPredicate.class, (Object)GsonPredicateSerializer.INSTANCE).registerTypeAdapter(StyleData.ElementList.class, (Object)new StyleData.ElementList.Serializer()).create();
    private static Config CONFIG;
    private static boolean ENABLED;
    private static final LinkedHashMap<String, PlayerListStyle> STYLES;
    private static final LinkedHashMap<String, StyleData> STYLES_DATA;

    public static Config getConfig() {
        return CONFIG;
    }

    public static boolean isEnabled() {
        return ENABLED;
    }

    public static boolean loadConfig() {
        ENABLED = false;
        CONFIG = null;
        try {
            ConfigData config;
            Path configDir = FabricLoader.getInstance().getConfigDir().resolve("styledplayerlist");
            Path configStyle = configDir.resolve("styles");
            Path configStyleLegacy = configDir.resolve("styles_old");
            if (!Files.exists(configStyle, new LinkOption[0])) {
                Files.createDirectories(configStyle, new FileAttribute[0]);
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(configStyle.resolve("default.json"), new OpenOption[0]), "UTF-8"));
                writer.write(GSON.toJson((Object)DefaultValues.exampleStyleData()));
                writer.close();
                writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(configStyle.resolve("animated.json"), new OpenOption[0]), "UTF-8"));
                writer.write(GSON.toJson((Object)DefaultValues.exampleAnimatedStyleData()));
                writer.close();
            }
            Path configFile = configDir.resolve("config.json");
            LegacyConfigData legacyConfigData = null;
            if (Files.exists(configFile, new LinkOption[0])) {
                JsonElement data = JsonParser.parseString((String)Files.readString(configFile));
                if (data.getAsJsonObject().has("CONFIG_VERSION_DONT_TOUCH_THIS")) {
                    legacyConfigData = (LegacyConfigData)GSON.fromJson(data, LegacyConfigData.class);
                    Files.writeString(configDir.resolve("config.json_old"), (CharSequence)data.toString(), new OpenOption[0]);
                    config = legacyConfigData.convert();
                } else {
                    config = (ConfigData)GSON.fromJson(data, ConfigData.class);
                }
            } else {
                config = new ConfigData();
            }
            Files.writeString(configFile, (CharSequence)GSON.toJson((Object)config), new OpenOption[0]);
            STYLES.clear();
            LegacyConfigData finalLegacyConfigData = legacyConfigData;
            Files.list(configStyle).filter(name -> !name.endsWith(".json")).forEach(path -> {
                StyleData styleData;
                String data;
                try {
                    data = Files.readString(path);
                }
                catch (IOException e) {
                    if (path.endsWith(".DS_Store")) {
                        return;
                    }
                    e.printStackTrace();
                    return;
                }
                JsonElement json = JsonParser.parseString((String)data);
                if (json.getAsJsonObject().has("permission")) {
                    styleData = ((LegacyStyleData)GSON.fromJson(data, LegacyStyleData.class)).convert(finalLegacyConfigData);
                    try {
                        Files.createDirectories(configStyleLegacy, new FileAttribute[0]);
                        Files.writeString(configStyleLegacy.resolve(path.getFileName().toString()), (CharSequence)data, new OpenOption[0]);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    styleData = (StyleData)GSON.fromJson(data, StyleData.class);
                }
                try {
                    Files.writeString(path, (CharSequence)GSON.toJson((Object)styleData), new OpenOption[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                String name = path.getFileName().toString();
                name = name.substring(0, name.length() - 5);
                PlayerListStyle style = new PlayerListStyle(name, styleData);
                STYLES.put(name, style);
                STYLES_DATA.put(name, styleData);
            });
            ((PlayerList.PlayerListStyleLoad)PlayerList.PLAYER_LIST_STYLE_LOAD.invoker()).onPlayerListUpdate(new PlayerList.StyleHelper(STYLES));
            CONFIG = new Config(config);
            ENABLED = true;
        }
        catch (Throwable exception) {
            ENABLED = false;
            PlayerList.LOGGER.error("Something went wrong while reading config!");
            exception.printStackTrace();
        }
        return ENABLED;
    }

    public static PlayerListStyle getStyle(String key) {
        return STYLES.containsKey(key) ? STYLES.get(key) : DefaultValues.EMPTY_STYLE;
    }

    public static boolean styleExist(String key) {
        return STYLES.containsKey(key);
    }

    public static Collection<PlayerListStyle> getStyles() {
        return STYLES.values();
    }

    public static String getDefault() {
        return ENABLED ? ConfigManager.CONFIG.configData.defaultStyle : "default";
    }

    public static void rebuildStyled() {
        if (CONFIG != null) {
            CONFIG = new Config(ConfigManager.CONFIG.configData);
        }
        for (Map.Entry<String, StyleData> e : STYLES_DATA.entrySet()) {
            STYLES.put(e.getKey(), new PlayerListStyle(e.getKey(), e.getValue()));
        }
    }

    static {
        ENABLED = false;
        STYLES = new LinkedHashMap();
        STYLES_DATA = new LinkedHashMap();
    }
}

