/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.styledplayerlist.config;

import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.predicate.api.BuiltinPredicates;
import eu.pb4.predicate.api.MinecraftPredicate;
import eu.pb4.predicate.api.PredicateContext;
import eu.pb4.styledplayerlist.config.Config;
import eu.pb4.styledplayerlist.config.data.StyleData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class PlayerListStyle {
    public final String id;
    public final String name;
    public final AnimatedText header;
    public final AnimatedText footer;
    public final int updateRate;
    public final boolean hidden;
    private final MinecraftPredicate require;

    public PlayerListStyle(String id, StyleData data) {
        this.id = id;
        this.name = data.name;
        this.updateRate = data.updateRate;
        this.header = AnimatedText.from(data.header, data.legacyJoinBehaviour == Boolean.TRUE);
        this.footer = AnimatedText.from(data.footer, data.legacyJoinBehaviour == Boolean.TRUE);
        this.hidden = data.hidden;
        this.require = data.require != null ? data.require : BuiltinPredicates.operatorLevel((int)0);
    }

    public boolean hasPermission(class_3222 player) {
        return this.require.test(PredicateContext.of((class_3222)player)).success();
    }

    public boolean hasPermission(class_2168 source) {
        return this.require.test(PredicateContext.of((class_2168)source)).success();
    }

    public class_2561 getHeader(PlaceholderContext context, int tick) {
        return this.header.getFor(tick).toText(context);
    }

    public class_2561 getFooter(PlaceholderContext context, int tick) {
        return this.footer.getFor(tick).toText(context);
    }

    public static interface AnimatedText {
        public TextNode getFor(int var1);

        public static AnimatedText from(StyleData.ElementList elementList, boolean legacy) {
            String joiner;
            if (elementList.values.isEmpty()) {
                return AnimatedText.of(TextNode.empty());
            }
            String string = joiner = legacy ? "\n" : "\n<r>";
            if (elementList.values.size() == 1) {
                return AnimatedText.of(Config.PARSER.parseNode(String.join((CharSequence)joiner, (Iterable<? extends CharSequence>)elementList.values.get(0))));
            }
            ArrayList<TextNode> list = new ArrayList<TextNode>();
            for (List<String> x : elementList.values) {
                list.add(Config.PARSER.parseNode(String.join((CharSequence)joiner, x)));
            }
            return AnimatedText.of(list, Math.max(elementList.changeRate, 1));
        }

        public static AnimatedText of(TextNode node) {
            return x -> node;
        }

        public static AnimatedText of(List<TextNode> node, int time) {
            return x -> (TextNode)node.get(x / time % node.size());
        }
    }
}

