/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.styledplayerlist.config.data;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.SerializedName;
import eu.pb4.predicate.api.MinecraftPredicate;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class StyleData {
    @SerializedName(value="require")
    @Nullable
    public MinecraftPredicate require;
    @SerializedName(value="style_name")
    public String name = "Default";
    @SerializedName(value="update_tick_time")
    public int updateRate = 20;
    @SerializedName(value="list_header")
    public ElementList header = new ElementList();
    @SerializedName(value="list_footer")
    public ElementList footer = new ElementList();
    @SerializedName(value="hidden_in_commands")
    public boolean hidden = false;
    @SerializedName(value="legacy_line_joining (Remove once updating!)")
    @Nullable
    public Boolean legacyJoinBehaviour;

    public static class ElementList {
        @SerializedName(value="values")
        public List<List<String>> values = new ArrayList<List<String>>();
        @SerializedName(value="change_rate")
        public int changeRate = 1;

        public static class Serializer
        implements JsonSerializer<ElementList>,
        JsonDeserializer<ElementList> {
            static final Type LIST_TYPE = new TypeToken<List<String>>(){}.getType();
            static final Type LIST_LIST_TYPE = new TypeToken<List<List<String>>>(){}.getType();

            public ElementList deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
                ElementList e = new ElementList();
                if (jsonElement.isJsonArray()) {
                    e.values.add((List)jsonDeserializationContext.deserialize(jsonElement, LIST_TYPE));
                } else if (jsonElement.isJsonObject()) {
                    JsonObject obj = jsonElement.getAsJsonObject();
                    e.changeRate = obj.get("change_rate").getAsInt();
                    e.values = (List)jsonDeserializationContext.deserialize(obj.get("values"), LIST_LIST_TYPE);
                } else if (jsonElement.isJsonPrimitive()) {
                    e.values.add(List.of(jsonElement.getAsString()));
                }
                return e;
            }

            public JsonElement serialize(ElementList elementList, Type type, JsonSerializationContext jsonSerializationContext) {
                if (elementList.values.isEmpty()) {
                    return new JsonArray();
                }
                if (elementList.values.size() == 1) {
                    return jsonSerializationContext.serialize(elementList.values.get(0));
                }
                JsonObject obj = new JsonObject();
                obj.addProperty("change_rate", (Number)elementList.changeRate);
                obj.add("values", jsonSerializationContext.serialize(elementList.values));
                return obj;
            }
        }
    }
}

