/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking.client;

import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.C2SConfigurationChannelEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.impl.networking.ChannelInfoHolder;
import net.fabricmc.fabric.impl.networking.RegistrationPayload;
import net.fabricmc.fabric.impl.networking.client.ClientCommonNetworkAddon;
import net.fabricmc.fabric.impl.networking.client.ClientNetworkingImpl;
import net.fabricmc.fabric.mixin.networking.client.accessor.ClientCommonNetworkHandlerAccessor;
import net.fabricmc.fabric.mixin.networking.client.accessor.ClientConfigurationNetworkHandlerAccessor;
import net.minecraft.class_2539;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8674;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public final class ClientConfigurationNetworkAddon
extends ClientCommonNetworkAddon<ClientConfigurationNetworking.ConfigurationPayloadHandler<?>, class_8674> {
    private final ContextImpl context = new ContextImpl(this);
    private boolean sentInitialRegisterPacket;

    public ClientConfigurationNetworkAddon(class_8674 handler, class_310 client) {
        super(ClientNetworkingImpl.CONFIGURATION, ((ClientCommonNetworkHandlerAccessor)handler).getConnection(), "ClientPlayNetworkAddon for " + ((ClientConfigurationNetworkHandlerAccessor)handler).getProfile().getName(), handler, client);
        this.registerPendingChannels((ChannelInfoHolder)this.connection, class_2539.field_45671);
    }

    @Override
    protected void invokeInitEvent() {
        ((ClientConfigurationConnectionEvents.Init)ClientConfigurationConnectionEvents.INIT.invoker()).onConfigurationInit((class_8674)this.handler, this.client);
    }

    @Override
    protected void receiveRegistration(boolean register, RegistrationPayload payload) {
        super.receiveRegistration(register, payload);
        if (register && !this.sentInitialRegisterPacket) {
            this.sendInitialChannelRegistrationPacket();
            this.sentInitialRegisterPacket = true;
        }
    }

    @Override
    protected void receive(ClientConfigurationNetworking.ConfigurationPayloadHandler<?> handler, class_8710 payload) {
        handler.receive(payload, this.context);
    }

    @Override
    public class_2596<?> createPacket(class_8710 packet) {
        return ClientPlayNetworking.createC2SPacket(packet);
    }

    @Override
    protected void invokeRegisterEvent(List<class_2960> ids) {
        ((C2SConfigurationChannelEvents.Register)C2SConfigurationChannelEvents.REGISTER.invoker()).onChannelRegister((class_8674)this.handler, this, this.client, ids);
    }

    @Override
    protected void invokeUnregisterEvent(List<class_2960> ids) {
        ((C2SConfigurationChannelEvents.Unregister)C2SConfigurationChannelEvents.UNREGISTER.invoker()).onChannelUnregister((class_8674)this.handler, this, this.client, ids);
    }

    public void handleReady() {
        ((ClientConfigurationConnectionEvents.Ready)ClientConfigurationConnectionEvents.READY.invoker()).onConfigurationReady((class_8674)this.handler, this.client);
        ClientNetworkingImpl.setClientConfigurationAddon(null);
    }

    @Override
    protected void invokeDisconnectEvent() {
        ((ClientConfigurationConnectionEvents.Disconnect)ClientConfigurationConnectionEvents.DISCONNECT.invoker()).onConfigurationDisconnect((class_8674)this.handler, this.client);
    }

    public ChannelInfoHolder getChannelInfoHolder() {
        return (ChannelInfoHolder)((ClientCommonNetworkHandlerAccessor)this.handler).getConnection();
    }

    @Environment(value=EnvType.CLIENT)
    private record ContextImpl(PacketSender responseSender) implements ClientConfigurationNetworking.Context
    {
        private ContextImpl {
            Objects.requireNonNull(responseSender, "responseSender");
        }
    }
}

