/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.cartography.render;

import journeymap.client.cartography.IChunkRenderer;
import journeymap.client.cartography.render.SurfaceRenderer;
import journeymap.client.log.JMLogger;
import journeymap.client.log.StatTimer;
import journeymap.client.model.BiomeMD;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.MapType;
import journeymap.client.texture.ComparableNativeImage;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.nbt.RegionData;
import net.minecraft.class_1011;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_6880;
import org.apache.logging.log4j.Level;

public class BiomeRenderer
extends SurfaceRenderer
implements IChunkRenderer {
    protected StatTimer renderTopoTimer = StatTimer.get("BiomeRenderer.renderSurface");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean render(ComparableNativeImage chunkImage, RegionData regionData, ChunkMD chunkMd, Integer vSlice) {
        StatTimer timer = this.renderTopoTimer;
        try {
            timer.start();
            this.updateOptions(chunkMd, MapType.from(MapType.Name.biome, null, chunkMd.getDimension()));
            boolean bl = this.renderSurface(chunkImage, regionData, chunkMd, vSlice, false);
            return bl;
        }
        catch (Throwable t) {
            JMLogger.throwLogOnce("Chunk Error", t);
            boolean bl = false;
            return bl;
        }
        finally {
            timer.stop();
        }
    }

    protected boolean renderSurface(class_1011 chunkImage, RegionData regionData, ChunkMD chunkMd, Integer vSlice, boolean cavePrePass) {
        boolean chunkOk = false;
        try {
            class_2487 chunkNbt = regionData.getChunkNbt(chunkMd.getCoord());
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    class_2487 blockNbt = regionData.getBlockDataFromBlockPos(chunkMd.getCoord(), chunkNbt, x, z);
                    BlockMD topBlockMd = null;
                    int y = Math.max(0, this.getBlockHeight(chunkMd, x, null, z, null, null));
                    topBlockMd = chunkMd.getBlockMD(x, y, z);
                    if (topBlockMd == null) {
                        this.paintBadBlock(chunkImage, x, y, z);
                        continue;
                    }
                    chunkOk = this.paintBiome(chunkImage, regionData, blockNbt, chunkMd, topBlockMd, x, y, z) || chunkOk;
                }
            }
            regionData.writeChunk(chunkMd.getCoord(), chunkNbt);
        }
        catch (Throwable t) {
            Journeymap.getLogger().log(Level.WARN, "Error in renderSurface: " + LogFormatter.toString(t));
        }
        return chunkOk;
    }

    private boolean paintBiome(class_1011 chunkImage, RegionData regionData, class_2487 blockNbt, ChunkMD chunkMd, BlockMD topBlockMd, int x, int y, int z) {
        if (!chunkMd.hasChunk()) {
            return false;
        }
        class_2338 blockPos = chunkMd.getBlockPos(x, y, z);
        class_6880<class_1959> biome = chunkMd.getBiomeHolder(blockPos);
        if (biome == null) {
            return false;
        }
        BiomeMD biomeMD = BiomeMD.get(biome);
        try {
            boolean isWater = topBlockMd.isWater() || topBlockMd.isIce();
            boolean isFoliage = topBlockMd.isFoliage();
            int color = topBlockMd.isLava() ? topBlockMd.getTextureColor() : (isWater ? biomeMD.getWaterColor() : (isFoliage ? biomeMD.getFoliageColor() : (chunkMd.getDimension().equals((Object)class_1937.field_25180) ? biomeMD.getFogColor() : biomeMD.getGrassColor(chunkMd.getCoord().field_9181, chunkMd.getCoord().field_9180))));
            int blockColor = this.paintBlock(chunkImage, x, z, color);
            regionData.setBlockColor(blockNbt, blockColor, MapType.Name.biome);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }
}

