/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import com.google.common.base.Objects;
import java.util.Optional;
import journeymap.client.cartography.color.ColorManager;
import journeymap.client.data.DataCache;
import journeymap.common.Journeymap;
import journeymap.common.helper.BiomeHelper;
import journeymap.common.log.LogFormatter;
import journeymap.common.mixin.client.BiomeInvoker;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_4763;
import net.minecraft.class_5483;
import net.minecraft.class_5485;
import net.minecraft.class_6880;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BiomeMD
implements Comparable<BiomeMD> {
    public static final BiomeMD THE_VOID = new BiomeMD(BiomeMD.createTheVoidBiome(), "journeymap:the_void", false);
    private static final Logger LOGGER = Journeymap.getLogger();
    private final class_1959 biome;
    private final String biomeId;
    private int grassColor;
    private int fogColor;
    private int foliageColor;
    private int waterColor;

    private static class_1959 createTheVoidBiome() {
        class_4763 specialEffects = new class_4763.class_4764().method_24392(0).method_24395(0).method_24397(0).method_30820(0).method_24391();
        return new class_1959.class_1960().method_48164(false).method_8747(0.5f).method_8727(0.5f).method_24379(specialEffects).method_30974(class_5483.field_26646).method_30973(class_5485.field_26639).method_30777(class_1959.class_5484.field_26407).method_30972();
    }

    public BiomeMD(@NotNull class_1959 biome, String id, boolean addToPalette) {
        this.biome = biome;
        this.biomeId = id;
        this.grassColor = biome.method_24377().method_30812().orElseGet(() -> ((BiomeInvoker)biome).invokeGetGrassColorFromTexture());
        this.fogColor = biome.method_24376();
        this.foliageColor = biome.method_8698();
        this.waterColor = biome.method_8687();
        if (addToPalette) {
            ColorManager.INSTANCE.addNewBiomeColor(this);
        }
    }

    public static BiomeMD get(class_6880<class_1959> biomeHolder) {
        return DataCache.INSTANCE.getBiomeMD(biomeHolder);
    }

    public String getBiomeId() {
        return this.biomeId;
    }

    public int getGrassColor(double posX, double posZ) {
        return this.biome.method_24377().method_30814().method_30823(posX, posZ, this.grassColor);
    }

    public int getGrassColor() {
        return this.grassColor;
    }

    public int getFogColor() {
        return this.fogColor;
    }

    public int getFoliageColor() {
        return this.foliageColor;
    }

    public int getWaterColor() {
        return this.waterColor;
    }

    public void setGrassColor(int color) {
        this.grassColor = color;
    }

    public void setFogColor(int color) {
        this.fogColor = color;
    }

    public void setFoliageColor(int color) {
        this.foliageColor = color;
    }

    public void setWaterColor(int color) {
        this.waterColor = color;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BiomeMD)) {
            return false;
        }
        BiomeMD biomeMD = (BiomeMD)o;
        return this.biome.equals(biomeMD.biome);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.biome});
    }

    public String toString() {
        return String.format("BiomeMD [%s]", BiomeHelper.getBiomeResource(this.biome));
    }

    @Override
    public int compareTo(BiomeMD that) {
        return BiomeHelper.getBiomeResource(this.biome).method_12833(BiomeHelper.getBiomeResource(that.biome));
    }

    public static class CacheLoader
    extends com.google.common.cache.CacheLoader<class_6880<class_1959>, BiomeMD> {
        public BiomeMD load(@NotNull class_6880<class_1959> biomeHolder) throws Exception {
            Optional key = biomeHolder.method_40230();
            String id = key.orElse(class_1972.field_9451).method_29177().toString();
            try {
                if (biomeHolder == null) {
                    LOGGER.warn("Null biome will be treated like the void: {}", biomeHolder);
                    return THE_VOID;
                }
                return new BiomeMD((class_1959)biomeHolder.comp_349(), id, true);
            }
            catch (Exception e) {
                LOGGER.error(String.format("Can't get BiomeMD for %s : %s", id, LogFormatter.toPartialString(e)));
                return THE_VOID;
            }
        }
    }
}

