/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import com.google.common.collect.ImmutableSortedMap;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import journeymap.api.client.impl.EntityRegistrationFactory;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.event.dispatchers.CustomEventDispatcher;
import journeymap.client.log.JMLogger;
import journeymap.client.log.StatTimer;
import journeymap.client.model.EntityDTO;
import journeymap.client.render.RenderFacade;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.util.PlayerRadarManager;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1548;
import net.minecraft.class_1569;
import net.minecraft.class_1641;
import net.minecraft.class_1646;
import net.minecraft.class_1655;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3851;
import net.minecraft.class_640;
import net.minecraft.class_7923;
import net.minecraft.class_887;
import net.minecraft.class_897;
import net.minecraft.class_963;
import net.minecraft.class_971;

public class EntityHelper {
    private static final EntityDistanceComparator entityDistanceComparator = new EntityDistanceComparator();
    private static final EntityDTODistanceComparator entityDTODistanceComparator = new EntityDTODistanceComparator();
    public static final EntityMapComparator entityMapComparator = new EntityMapComparator();
    private static final String[] HORSE_TEXTURES = new String[]{"textures/entity/horse/horse_white.png", "textures/entity/horse/horse_creamy.png", "textures/entity/horse/horse_chestnut.png", "textures/entity/horse/horse_brown.png", "textures/entity/horse/horse_black.png", "textures/entity/horse/horse_gray.png", "textures/entity/horse/horse_darkbrown.png"};

    public static List<EntityDTO> getEntitiesNearby(String timerName, int maxEntities, boolean hostile, List<Class<? extends class_1297>> entities, Class ... entityClasses) {
        StatTimer timer = StatTimer.get("EntityHelper." + timerName);
        timer.start();
        ArrayList<Class> classes = new ArrayList<Class>(List.of(entityClasses));
        classes.addAll(entities);
        class_310 mc = class_310.method_1551();
        List<EntityDTO> list = new ArrayList<EntityDTO>();
        ArrayList allEntities = new ArrayList();
        mc.field_1687.method_18112().forEach(allEntities::add);
        class_238 bb = EntityHelper.getBB((class_1657)mc.field_1724);
        try {
            block2: for (class_1297 entity : allEntities) {
                if (!entity.method_5805() || !bb.method_994(entity.method_5829())) continue;
                for (Class entityClass : classes) {
                    if (!entityClass.isAssignableFrom(entity.getClass()) || !EntityHelper.isSpecialCreature(entity, hostile)) continue;
                    class_1309 entityLivingBase = (class_1309)entity;
                    EntityDTO dto = DataCache.INSTANCE.getEntityDTO(entityLivingBase);
                    dto.update(entityLivingBase, hostile);
                    if (!CustomEventDispatcher.getInstance().entityRadarMobUpdateEvent(dto)) continue block2;
                    list.add(dto);
                    continue block2;
                }
            }
            if (list.size() > maxEntities) {
                EntityHelper.entityDTODistanceComparator.player = mc.field_1724;
                Collections.sort(list, entityDTODistanceComparator);
                list = list.subList(0, maxEntities);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().warn("Failed to " + timerName + ": " + LogFormatter.toString(t));
        }
        timer.stop();
        return list;
    }

    private static boolean isSpecialCreature(class_1297 entity, boolean hostile) {
        if (class_1314.class.isAssignableFrom(entity.getClass())) {
            if (hostile && entity.method_5864().method_5891().equals((Object)class_1311.field_6302)) {
                return true;
            }
            return !hostile && entity.method_5864().method_5891().method_6136();
        }
        return true;
    }

    public static List<EntityDTO> getMobsNearby() {
        int max = Math.min(JourneymapClient.getInstance().getCoreProperties().maxMobsData.get(), JourneymapClient.getInstance().getStateHandler().getMaxMobsData());
        return EntityHelper.getEntitiesNearby("getMobsNearby", max, true, EntityRegistrationFactory.getInstance().getHostiles(), class_1569.class);
    }

    public static List<EntityDTO> getVillagersNearby() {
        int max = Math.min(JourneymapClient.getInstance().getCoreProperties().maxVillagersData.get(), JourneymapClient.getInstance().getStateHandler().getMaxVillagersData());
        return EntityHelper.getEntitiesNearby("getVillagersNearby", max, false, EntityRegistrationFactory.getInstance().getVillagers(), class_1655.class);
    }

    public static List<EntityDTO> getAnimalsNearby() {
        int max = Math.min(JourneymapClient.getInstance().getCoreProperties().maxAnimalsData.get(), JourneymapClient.getInstance().getStateHandler().getMaxAnimalsData());
        return EntityHelper.getEntitiesNearby("getAnimalsNearby", max, false, EntityRegistrationFactory.getInstance().getPassives(), new Class[0]);
    }

    public static List<EntityDTO> getAmbientCreaturesNearby() {
        int max = Math.min(JourneymapClient.getInstance().getCoreProperties().maxAmbientCreaturesData.get(), JourneymapClient.getInstance().getStateHandler().getMaxAmbientCreaturesData());
        return EntityHelper.getEntitiesNearby("getAmbientCreaturesNearby", max, false, EntityRegistrationFactory.getInstance().getAmbient(), new Class[0]);
    }

    public static boolean isPassive(class_1309 entityLiving) {
        if (entityLiving == null) {
            return false;
        }
        if (entityLiving instanceof class_1569) {
            return false;
        }
        class_1309 attackTarget = entityLiving.method_6124();
        return attackTarget == null || !(attackTarget instanceof class_1657) && !(attackTarget instanceof class_1321);
    }

    public static List<EntityDTO> getPlayersNearby() {
        StatTimer timer = StatTimer.get("EntityHelper.getPlayersNearby");
        timer.start();
        class_310 mc = class_310.method_1551();
        List<class_1657> allPlayers = new ArrayList();
        if (JourneymapClient.getInstance().getStateHandler().isExpandedRadarEnabled()) {
            if (mc.method_1562().method_2880() != null && mc.method_1562().method_2880().size() > 1) {
                for (class_640 onlinePlayer : mc.method_1562().method_2880()) {
                    class_1657 networkedPlayer;
                    if (onlinePlayer.method_2966().getId().equals(mc.field_1724.method_5667()) || (networkedPlayer = PlayerRadarManager.getInstance().getPlayers().get(onlinePlayer.method_2966().getId())) == null || networkedPlayer.method_5770().method_27983() != class_310.method_1551().field_1724.method_5770().method_27983()) continue;
                    allPlayers.add(networkedPlayer);
                }
            }
        } else {
            allPlayers.addAll(mc.field_1687.method_18456());
            allPlayers.remove(mc.field_1724);
        }
        int max = Math.min(JourneymapClient.getInstance().getCoreProperties().maxPlayersData.get(), JourneymapClient.getInstance().getStateHandler().getMaxPlayersData());
        if (allPlayers.size() > max) {
            EntityHelper.entityDistanceComparator.player = mc.field_1724;
            Collections.sort(allPlayers, entityDistanceComparator);
            allPlayers = allPlayers.subList(0, max);
        }
        ArrayList<EntityDTO> playerDTOs = new ArrayList<EntityDTO>(allPlayers.size());
        for (class_1657 player : allPlayers) {
            EntityDTO dto = DataCache.INSTANCE.getEntityDTO((class_1309)player);
            dto.update((class_1309)player, false);
            if (!CustomEventDispatcher.getInstance().entityRadarPlayerUpdateEvent(dto)) continue;
            playerDTOs.add(dto);
        }
        timer.stop();
        return playerDTOs;
    }

    private static class_238 getBB(class_1657 player) {
        int lateralDistance = Math.min(JourneymapClient.getInstance().getCoreProperties().radarLateralDistance.get(), JourneymapClient.getInstance().getStateHandler().getRadarLateralDistance());
        int verticalDistance = Math.min(JourneymapClient.getInstance().getCoreProperties().radarVerticalDistance.get(), JourneymapClient.getInstance().getStateHandler().getRadarVerticalDistance());
        return EntityHelper.getBoundingBox(player, lateralDistance, verticalDistance);
    }

    public static class_238 getBoundingBox(class_1657 player, double lateralDistance, double verticalDistance) {
        return player.method_5829().method_1009(lateralDistance, verticalDistance, lateralDistance);
    }

    public static Map<String, EntityDTO> buildEntityIdMap(List<? extends EntityDTO> list, boolean sort) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyMap();
        }
        if (sort) {
            Collections.sort(list, entityMapComparator);
        }
        LinkedHashMap<CallSite, EntityDTO> idMap = new LinkedHashMap<CallSite, EntityDTO>(list.size());
        for (EntityDTO entityDTO : list) {
            idMap.put((CallSite)((Object)("id" + entityDTO.entityId)), entityDTO);
        }
        return ImmutableSortedMap.copyOf(idMap);
    }

    public static IconData getIconData(class_1297 entity) {
        try {
            String typePath;
            class_897 entityRender = class_310.method_1551().method_1561().method_3953(entity);
            IconData iconData = new IconData();
            iconData.type = class_7923.field_41177.method_10221((Object)entity.method_5864());
            if (entityRender instanceof class_887) {
                class_1548 creeper = (class_1548)entity;
                iconData.icon = iconData.texture = entityRender.method_3931((class_1297)creeper);
                if (creeper.method_6872()) {
                    String iconPath = iconData.icon.method_12832().replace("creeper.png", "creeper_armor.png");
                    typePath = iconData.type.method_12832().replace("creeper", "charged_creeper");
                    iconData.icon = class_2960.method_60655((String)iconData.icon.method_12836(), (String)iconPath);
                    iconData.type = class_2960.method_60655((String)iconData.type.method_12836(), (String)typePath);
                }
            } else if (entityRender instanceof class_963 || entityRender instanceof class_971) {
                String type;
                if (entityRender instanceof class_963) {
                    type = "villager.png";
                    iconData.texture = entityRender.method_3931((class_1297)((class_1646)entity));
                } else {
                    type = "zombie_villager.png";
                    iconData.texture = entityRender.method_3931((class_1297)((class_1641)entity));
                }
                iconData.icon = iconData.texture;
                class_3851 villagerData = (class_3851)entity;
                String profession = class_7923.field_41195.method_10221((Object)villagerData.method_7231().method_16924()).method_12832();
                if (profession.contains(":")) {
                    String namespace = profession.split(":")[0];
                    String path = profession.split(":")[1];
                    String poiJobIconPath = iconData.icon.method_12832().replace(type, path + ".png");
                    String poiJobTypePath = iconData.type.method_12832().concat("_" + path);
                    iconData.icon = class_2960.method_60655((String)namespace, (String)poiJobIconPath);
                    iconData.type = class_2960.method_60655((String)namespace, (String)poiJobTypePath);
                } else if ("minecraft".equals(iconData.icon.method_12836()) && !"unemployed".equals(profession) && !"none".equals(profession)) {
                    String iconPath = iconData.icon.method_12832().replace(type, profession + ".png");
                    String typePath2 = iconData.type.method_12832().concat("_" + profession);
                    iconData.icon = class_2960.method_60655((String)iconData.icon.method_12836(), (String)iconPath);
                    iconData.type = class_2960.method_60655((String)iconData.type.method_12836(), (String)typePath2);
                }
            } else {
                iconData.icon = iconData.texture = RenderFacade.getEntityTexture(entityRender, entity);
            }
            if (iconData.icon == null) {
                JMLogger.logOnce("Can't get entityTexture for " + String.valueOf(entity.getClass()) + " via " + String.valueOf(entityRender.getClass()));
                return iconData;
            }
            int lastSlash = iconData.icon.method_12832().lastIndexOf(47);
            int extension = iconData.icon.method_12832().lastIndexOf(".png");
            typePath = iconData.icon.method_12832().substring(lastSlash + 1, extension);
            iconData.type = class_2960.method_60655((String)iconData.type.method_12836(), (String)typePath);
            if (iconData.icon.method_12836().equals("cobblemon")) {
                iconData.icon = class_2960.method_60655((String)iconData.icon.method_12836(), (String)iconData.icon.method_12832().replace("pokemon", "entity_icon"));
            } else if (iconData.icon.method_12832().contains("/model/entity/")) {
                iconData.icon = class_2960.method_60655((String)iconData.icon.method_12836(), (String)iconData.icon.method_12832().replace("/model/entity/", "/entity_icon/"));
            } else if ((iconData.icon.method_12832().contains("/model/") || iconData.icon.method_12832().contains("/models/")) && !iconData.icon.method_12832().contains("/entity/")) {
                iconData.icon = class_2960.method_60655((String)iconData.icon.method_12836(), (String)iconData.icon.method_12832().replace("/model/", "/entity_icon/"));
            } else if (iconData.icon.method_12832().contains("/entity/")) {
                iconData.icon = class_2960.method_60655((String)iconData.icon.method_12836(), (String)iconData.icon.method_12832().replace("/entity/", "/entity_icon/"));
            } else {
                JMLogger.logOnce(String.valueOf(iconData.icon) + " doesn't have /entity/ in path, so can't look for /entity_icon/");
                return null;
            }
            int entityIconBegin = iconData.icon.method_12832().lastIndexOf("/entity_icon/");
            if (entityIconBegin != -1) {
                String name;
                extension = iconData.icon.method_12832().lastIndexOf(".png");
                typePath = iconData.icon.method_12832().substring(entityIconBegin += "/entity_icon/".length(), extension);
                int slash = typePath.indexOf(47);
                if (slash != -1 && typePath.startsWith(name = typePath.substring(0, slash), slash + 1)) {
                    typePath = typePath.substring(name.length() + 1);
                }
                typePath = typePath.replace('/', '_');
                iconData.type = class_2960.method_60655((String)iconData.type.method_12836(), (String)typePath);
            }
            return iconData;
        }
        catch (Throwable t) {
            JMLogger.throwLogOnce("Can't get entityTexture for " + String.valueOf(entity.method_5477()), t);
            return new IconData();
        }
    }

    private static class EntityDTODistanceComparator
    implements Comparator<EntityDTO> {
        class_1657 player;

        private EntityDTODistanceComparator() {
        }

        @Override
        public int compare(EntityDTO o1, EntityDTO o2) {
            class_1297 e1 = (class_1297)o1.entityRef.get();
            class_1297 e2 = (class_1297)o2.entityRef.get();
            if (e1 == null || e2 == null) {
                return 0;
            }
            return Double.compare(e1.method_5858((class_1297)this.player), e2.method_5858((class_1297)this.player));
        }
    }

    private static class EntityDistanceComparator
    implements Comparator<class_1297> {
        class_1657 player;

        private EntityDistanceComparator() {
        }

        @Override
        public int compare(class_1297 o1, class_1297 o2) {
            return Double.compare(o1.method_5858((class_1297)this.player), o2.method_5858((class_1297)this.player));
        }
    }

    private static class EntityMapComparator
    implements Comparator<EntityDTO> {
        private EntityMapComparator() {
        }

        @Override
        public int compare(EntityDTO o1, EntityDTO o2) {
            Integer n;
            Integer o1rank = 0;
            Integer o2rank = 0;
            if (o1.getCustomName() != null) {
                n = o1rank;
                o1rank = o1rank + 1;
            } else if (o1.username != null) {
                o1rank = o1rank + 2;
            }
            if (o2.getCustomName() != null) {
                n = o2rank;
                o2rank = o2rank + 1;
            } else if (o2.username != null) {
                o2rank = o2rank + 2;
            }
            if (o1rank.equals(o2rank) && o1.entityTypeLocation != null && o2.entityTypeLocation != null) {
                return o1.entityTypeLocation.method_12833(o2.entityTypeLocation);
            }
            return o1rank.compareTo(o2rank);
        }
    }

    public static class IconData {
        class_2960 texture = null;
        class_2960 icon = null;
        class_2960 type = null;
    }
}

