/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.vigilance.gui.common.input;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.constraints.SuperConstraint;
import gg.essential.elementa.constraints.WidthConstraint;
import gg.essential.elementa.constraints.XConstraint;
import gg.essential.elementa.dsl.BasicConstraintsKt;
import gg.essential.elementa.dsl.ConstraintsKt;
import gg.essential.elementa.dsl.UtilitiesKt;
import gg.essential.universal.UMatrixStack;
import gg.essential.vigilance.gui.common.input.AbstractTextInput;
import java.awt.Color;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0004\b\u0010\u0018\u00002\u00020\u0001Bc\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\f\u001a\u00020\u0007\u0012\b\b\u0002\u0010\r\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0003H\u0016J\b\u0010!\u001a\u00020\u0003H\u0014J\b\u0010\"\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u001dH\u0014J\u001c\u0010$\u001a\u00060%R\u00020\u00012\u0006\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u0019H\u0014J\u0014\u0010(\u001a\u00020\u001d2\n\u0010)\u001a\u00060%R\u00020\u0001H\u0014J\b\u0010*\u001a\u00020\u001dH\u0014J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0010J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0010J\u001e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00030-2\u0006\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u0019H\u0014J\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020\u00030-2\u0006\u0010.\u001a\u00020\u0003H\u0014R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u0014\u0010\u0018\u001a\u00020\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00061"}, d2={"Lgg/essential/vigilance/gui/common/input/UITextInput;", "Lgg/essential/vigilance/gui/common/input/AbstractTextInput;", "placeholder", "", "shadow", "", "shadowColor", "Ljava/awt/Color;", "selectionBackgroundColor", "selectionForegroundColor", "allowInactiveSelection", "inactiveSelectionBackgroundColor", "inactiveSelectionForegroundColor", "cursorColor", "(Ljava/lang/String;ZLjava/awt/Color;Ljava/awt/Color;Ljava/awt/Color;ZLjava/awt/Color;Ljava/awt/Color;Ljava/awt/Color;)V", "maxWidth", "Lgg/essential/elementa/constraints/WidthConstraint;", "getMaxWidth", "()Lgg/essential/elementa/constraints/WidthConstraint;", "setMaxWidth", "(Lgg/essential/elementa/constraints/WidthConstraint;)V", "minWidth", "getMinWidth", "setMinWidth", "placeholderWidth", "", "getPlaceholderWidth", "()F", "draw", "", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "getText", "getTextForRender", "onEnterPressed", "recalculateDimensions", "screenPosToVisualPos", "Lgg/essential/vigilance/gui/common/input/AbstractTextInput$LinePosition;", "x", "y", "scrollIntoView", "pos", "setCursorPos", "constraint", "splitTextForWrapping", "", "text", "maxLineWidth", "textToLines", "Vigilance"})
public class UITextInput
extends AbstractTextInput {
    @Nullable
    private WidthConstraint minWidth;
    @Nullable
    private WidthConstraint maxWidth;
    private final float placeholderWidth;

    @JvmOverloads
    public UITextInput(@NotNull String placeholder, boolean shadow, @Nullable Color shadowColor, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor, boolean allowInactiveSelection, @NotNull Color inactiveSelectionBackgroundColor, @NotNull Color inactiveSelectionForegroundColor, @NotNull Color cursorColor) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        Intrinsics.checkNotNullParameter((Object)selectionBackgroundColor, (String)"selectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)selectionForegroundColor, (String)"selectionForegroundColor");
        Intrinsics.checkNotNullParameter((Object)inactiveSelectionBackgroundColor, (String)"inactiveSelectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)inactiveSelectionForegroundColor, (String)"inactiveSelectionForegroundColor");
        Intrinsics.checkNotNullParameter((Object)cursorColor, (String)"cursorColor");
        Color color = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"WHITE");
        super(placeholder, shadow, shadowColor, selectionBackgroundColor, selectionForegroundColor, allowInactiveSelection, inactiveSelectionBackgroundColor, inactiveSelectionForegroundColor, color);
        this.placeholderWidth = UtilitiesKt.width$default((String)placeholder, (float)0.0f, null, (int)3, null);
    }

    public /* synthetic */ UITextInput(String string, boolean bl, Color color, Color color2, Color color3, boolean bl2, Color color4, Color color5, Color color6, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            color = null;
        }
        if ((n & 8) != 0) {
            Color color7 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue((Object)color7, (String)"WHITE");
            color2 = color7;
        }
        if ((n & 0x10) != 0) {
            color3 = new Color(64, 139, 229);
        }
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        if ((n & 0x40) != 0) {
            color4 = new Color(176, 176, 176);
        }
        if ((n & 0x80) != 0) {
            Color color8 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue((Object)color8, (String)"WHITE");
            color5 = color8;
        }
        if ((n & 0x100) != 0) {
            Color color9 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue((Object)color9, (String)"WHITE");
            color6 = color9;
        }
        this(string, bl, color, color2, color3, bl2, color4, color5, color6);
    }

    @Nullable
    protected final WidthConstraint getMinWidth() {
        return this.minWidth;
    }

    protected final void setMinWidth(@Nullable WidthConstraint widthConstraint) {
        this.minWidth = widthConstraint;
    }

    @Nullable
    protected final WidthConstraint getMaxWidth() {
        return this.maxWidth;
    }

    protected final void setMaxWidth(@Nullable WidthConstraint widthConstraint) {
        this.maxWidth = widthConstraint;
    }

    protected final float getPlaceholderWidth() {
        return this.placeholderWidth;
    }

    @NotNull
    public final UITextInput setMinWidth(@NotNull WidthConstraint constraint) {
        UITextInput uITextInput;
        Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
        UITextInput $this$setMinWidth_u24lambda_u240 = uITextInput = this;
        boolean bl = false;
        $this$setMinWidth_u24lambda_u240.minWidth = constraint;
        return uITextInput;
    }

    @NotNull
    public final UITextInput setMaxWidth(@NotNull WidthConstraint constraint) {
        UITextInput uITextInput;
        Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
        UITextInput $this$setMaxWidth_u24lambda_u241 = uITextInput = this;
        boolean bl = false;
        $this$setMaxWidth_u24lambda_u241.maxWidth = constraint;
        return uITextInput;
    }

    @Override
    @NotNull
    public String getText() {
        return ((AbstractTextInput.TextualLine)CollectionsKt.first(this.getTextualLines())).getText();
    }

    @NotNull
    protected String getTextForRender() {
        return this.getText();
    }

    protected void setCursorPos() {
        UIComponent.unhide$default((UIComponent)this.getCursorComponent(), (boolean)false, (int)1, null);
        float cursorPosX = ((Number)this.getCursor().toScreenPos().component1()).floatValue();
        this.getCursorComponent().setX((XConstraint)UtilitiesKt.pixels$default((Number)Float.valueOf(cursorPosX), (boolean)false, (boolean)false, (int)3, null));
    }

    @Override
    @NotNull
    protected List<String> textToLines(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return CollectionsKt.listOf((Object)StringsKt.replace$default((String)text, (char)'\n', (char)' ', (boolean)false, (int)4, null));
    }

    @Override
    protected void scrollIntoView(@NotNull AbstractTextInput.LinePosition pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        int column = pos.getColumn();
        String lineText = this.getTextForRender();
        if (column < 0 || column > lineText.length()) {
            return;
        }
        String string = lineText;
        int n = 0;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, column);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        float widthBeforePosition = UtilitiesKt.width$default((String)string3, (float)this.getTextScale(), null, (int)2, null);
        if (UtilitiesKt.width$default((String)this.getTextForRender(), (float)this.getTextScale(), null, (int)2, null) < this.getWidth()) {
            this.setHorizontalScrollingOffset(0.0f);
        } else if (this.getHorizontalScrollingOffset() > widthBeforePosition) {
            this.setHorizontalScrollingOffset(widthBeforePosition);
        } else if (widthBeforePosition - this.getHorizontalScrollingOffset() > this.getWidth()) {
            this.setHorizontalScrollingOffset(widthBeforePosition - this.getWidth());
        }
    }

    @Override
    @NotNull
    protected AbstractTextInput.LinePosition screenPosToVisualPos(float x, float y) {
        float targetXPos = x + this.getHorizontalScrollingOffset();
        float currentX = 0.0f;
        String line = this.getTextForRender();
        int n = line.length();
        for (int i2 = 0; i2 < n; ++i2) {
            float charWidth = UtilitiesKt.width((char)line.charAt(i2), (float)this.getTextScale());
            if (currentX + charWidth / (float)2 >= targetXPos) {
                return new AbstractTextInput.LinePosition(0, i2, true);
            }
            currentX += charWidth;
        }
        return new AbstractTextInput.LinePosition(0, line.length(), true);
    }

    @Override
    protected void recalculateDimensions() {
        if (this.minWidth != null && this.maxWidth != null) {
            float width = !this.hasText() && !this.getActive() ? this.placeholderWidth : UtilitiesKt.width$default((String)this.getTextForRender(), (float)this.getTextScale(), null, (int)2, null) + 1.0f;
            SuperConstraint superConstraint = (SuperConstraint)UtilitiesKt.pixels$default((Number)Float.valueOf(width), (boolean)false, (boolean)false, (int)3, null);
            WidthConstraint widthConstraint = this.minWidth;
            Intrinsics.checkNotNull((Object)widthConstraint);
            SuperConstraint superConstraint2 = (SuperConstraint)widthConstraint;
            WidthConstraint widthConstraint2 = this.maxWidth;
            Intrinsics.checkNotNull((Object)widthConstraint2);
            this.setWidth((WidthConstraint)ConstraintsKt.coerceIn((SuperConstraint)superConstraint, (SuperConstraint)superConstraint2, (SuperConstraint)((SuperConstraint)widthConstraint2)));
        }
    }

    @Override
    @NotNull
    protected List<String> splitTextForWrapping(@NotNull String text, float maxLineWidth) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return CollectionsKt.listOf((Object)text);
    }

    @Override
    protected void onEnterPressed() {
        this.getActivateAction().invoke((Object)this.getText());
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        this.beforeDrawCompat(matrixStack);
        if (!this.getActive() && !this.hasText()) {
            this.drawPlaceholder(matrixStack);
            super.draw(matrixStack);
            return;
        }
        String lineText = this.getTextForRender();
        if (this.hasSelection()) {
            int n;
            int n2;
            String string;
            float currentX = this.getLeft();
            this.getCursorComponent().hide(true);
            if (!this.selectionStart().isAtLineStart()) {
                string = lineText;
                n2 = 0;
                n = this.selectionStart().getColumn();
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n2, n);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String preSelectionText = string3;
                AbstractTextInput.drawUnselectedText$default(this, matrixStack, preSelectionText, currentX, 0, null, false, null, 112, null);
                currentX += UtilitiesKt.width$default((String)preSelectionText, (float)this.getTextScale(), null, (int)2, null);
            }
            string = lineText;
            n2 = this.selectionStart().getColumn();
            n = this.selectionEnd().getColumn();
            String string4 = string;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n2, n);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String selectedText2 = string5;
            float selectedTextWidth = UtilitiesKt.width$default((String)selectedText2, (float)this.getTextScale(), null, (int)2, null);
            this.drawSelectedText(matrixStack, selectedText2, currentX, currentX + selectedTextWidth, 0);
            currentX += selectedTextWidth;
            if (!this.selectionEnd().isAtLineEnd()) {
                AbstractTextInput abstractTextInput = this;
                String string6 = lineText;
                n = this.selectionEnd().getColumn();
                String string7 = string6;
                if (string7 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string8 = string7.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
                AbstractTextInput.drawUnselectedText$default(abstractTextInput, matrixStack, string8, currentX, 0, null, false, null, 112, null);
            }
        } else {
            if (this.getActive()) {
                this.getCursorComponent().setY(BasicConstraintsKt.basicYConstraint((Function1)((Function1)new Function1<UIComponent, Float>(this){
                    final /* synthetic */ UITextInput this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Float invoke(@NotNull UIComponent it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return Float.valueOf(this.this$0.getTop());
                    }
                })));
                this.setCursorPos();
            }
            AbstractTextInput.drawUnselectedText$default(this, matrixStack, lineText, this.getLeft(), 0, null, false, null, 112, null);
        }
        super.draw(matrixStack);
    }

    @JvmOverloads
    public UITextInput(@NotNull String placeholder, boolean shadow, @Nullable Color shadowColor, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor, boolean allowInactiveSelection, @NotNull Color inactiveSelectionBackgroundColor, @NotNull Color inactiveSelectionForegroundColor) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        Intrinsics.checkNotNullParameter((Object)selectionBackgroundColor, (String)"selectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)selectionForegroundColor, (String)"selectionForegroundColor");
        Intrinsics.checkNotNullParameter((Object)inactiveSelectionBackgroundColor, (String)"inactiveSelectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)inactiveSelectionForegroundColor, (String)"inactiveSelectionForegroundColor");
        this(placeholder, shadow, shadowColor, selectionBackgroundColor, selectionForegroundColor, allowInactiveSelection, inactiveSelectionBackgroundColor, inactiveSelectionForegroundColor, null, 256, null);
    }

    @JvmOverloads
    public UITextInput(@NotNull String placeholder, boolean shadow, @Nullable Color shadowColor, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor, boolean allowInactiveSelection, @NotNull Color inactiveSelectionBackgroundColor) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        Intrinsics.checkNotNullParameter((Object)selectionBackgroundColor, (String)"selectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)selectionForegroundColor, (String)"selectionForegroundColor");
        Intrinsics.checkNotNullParameter((Object)inactiveSelectionBackgroundColor, (String)"inactiveSelectionBackgroundColor");
        this(placeholder, shadow, shadowColor, selectionBackgroundColor, selectionForegroundColor, allowInactiveSelection, inactiveSelectionBackgroundColor, null, null, 384, null);
    }

    @JvmOverloads
    public UITextInput(@NotNull String placeholder, boolean shadow, @Nullable Color shadowColor, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor, boolean allowInactiveSelection) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        Intrinsics.checkNotNullParameter((Object)selectionBackgroundColor, (String)"selectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)selectionForegroundColor, (String)"selectionForegroundColor");
        this(placeholder, shadow, shadowColor, selectionBackgroundColor, selectionForegroundColor, allowInactiveSelection, null, null, null, 448, null);
    }

    @JvmOverloads
    public UITextInput(@NotNull String placeholder, boolean shadow, @Nullable Color shadowColor, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        Intrinsics.checkNotNullParameter((Object)selectionBackgroundColor, (String)"selectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)selectionForegroundColor, (String)"selectionForegroundColor");
        this(placeholder, shadow, shadowColor, selectionBackgroundColor, selectionForegroundColor, false, null, null, null, 480, null);
    }

    @JvmOverloads
    public UITextInput(@NotNull String placeholder, boolean shadow, @Nullable Color shadowColor, @NotNull Color selectionBackgroundColor) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        Intrinsics.checkNotNullParameter((Object)selectionBackgroundColor, (String)"selectionBackgroundColor");
        this(placeholder, shadow, shadowColor, selectionBackgroundColor, null, false, null, null, null, 496, null);
    }

    @JvmOverloads
    public UITextInput(@NotNull String placeholder, boolean shadow, @Nullable Color shadowColor) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        this(placeholder, shadow, shadowColor, null, null, false, null, null, null, 504, null);
    }

    @JvmOverloads
    public UITextInput(@NotNull String placeholder, boolean shadow) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        this(placeholder, shadow, null, null, null, false, null, null, null, 508, null);
    }

    @JvmOverloads
    public UITextInput(@NotNull String placeholder) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        this(placeholder, false, null, null, null, false, null, null, null, 510, null);
    }

    @JvmOverloads
    public UITextInput() {
        this(null, false, null, null, null, false, null, null, null, 511, null);
    }
}

