/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.commands.arguments;

import de.bluecolored.bluecommands.CommandParseException;
import de.bluecolored.bluecommands.InputReader;
import de.bluecolored.bluecommands.SimpleSuggestion;
import de.bluecolored.bluecommands.Suggestion;
import de.bluecolored.bluecommands.parsers.SimpleArgumentParser;
import de.bluecolored.bluemap.common.serverinterface.CommandSource;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class MapBackedArgumentParser<T>
extends SimpleArgumentParser<CommandSource, T> {
    private final String typeName;
    private final Supplier<Map<String, T>> mapSupplier;

    public MapBackedArgumentParser(String typeName, Map<String, T> map) {
        this(typeName, () -> map);
    }

    public MapBackedArgumentParser(String typeName, Supplier<Map<String, T>> mapSupplier) {
        super(true, false);
        this.typeName = typeName;
        this.mapSupplier = mapSupplier;
    }

    @Override
    public T parse(CommandSource context, String string) throws CommandParseException {
        T value = this.mapSupplier.get().get(string);
        if (value == null) {
            throw new CommandParseException("There is no %s for '%s'".formatted(this.typeName, string));
        }
        return value;
    }

    @Override
    public List<Suggestion> suggest(CommandSource context, InputReader input) {
        return this.mapSupplier.get().keySet().stream().sorted().map(SimpleSuggestion::new).toList();
    }
}

