/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.commands.checks;

import de.bluecolored.bluemap.common.commands.TextFormat;
import de.bluecolored.bluemap.common.commands.checks.Check;
import de.bluecolored.bluemap.common.commands.checks.CheckResult;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.rendermanager.MapRenderTask;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.shadow.adventure.adventure.text.Component;

public class MapIsUpdatedCheck
implements Check {
    private final Plugin plugin;
    private final BmMap map;

    @Override
    public CheckResult getResult() {
        return this.plugin.getRenderManager().getScheduledRenderTasks().stream().noneMatch(task -> {
            MapRenderTask mapTask;
            return task instanceof MapRenderTask && (mapTask = (MapRenderTask)task).getMap().equals(this.map);
        }) ? CheckResult.OK : CheckResult.BAD;
    }

    @Override
    public Component getFailureDescription() {
        return TextFormat.lines(TextFormat.format("\u26a0 map % has pending updates", TextFormat.formatMap(this.map).color(TextFormat.HIGHLIGHT_COLOR)), Component.empty(), TextFormat.format("wait until the map finished updating\nyou can use % to see the update progress\n".strip(), TextFormat.command("/bluemap").color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.BASE_COLOR));
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public BmMap getMap() {
        return this.map;
    }

    public MapIsUpdatedCheck(Plugin plugin, BmMap map) {
        this.plugin = plugin;
        this.map = map;
    }
}

