/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.rendermanager;

import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector2l;
import de.bluecolored.bluemap.common.debug.DebugDump;
import de.bluecolored.bluemap.common.rendermanager.MapRenderTask;
import de.bluecolored.bluemap.common.rendermanager.TileUpdateStrategy;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.map.renderstate.TileActionResolver;
import de.bluecolored.bluemap.core.map.renderstate.TileInfoRegion;
import de.bluecolored.bluemap.core.map.renderstate.TileState;
import de.bluecolored.bluemap.core.util.Grid;
import de.bluecolored.bluemap.core.world.Chunk;
import java.io.IOException;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;

public class WorldRegionRenderTask
implements MapRenderTask {
    private final BmMap map;
    private final Vector2i regionPos;
    private final TileUpdateStrategy force;
    private Grid regionGrid;
    private Grid chunkGrid;
    private Grid tileGrid;
    private Vector2i chunkMin;
    private Vector2i chunkMax;
    private Vector2i chunksSize;
    private Vector2i tileMin;
    private Vector2i tileMax;
    private Vector2i tileSize;
    private int[] chunkHashes;
    private TileActionResolver.ActionAndNextState[] tileActions;
    private volatile int nextTileX;
    private volatile int nextTileZ;
    private volatile int atWork;
    private volatile boolean completed;
    private volatile boolean cancelled;

    public WorldRegionRenderTask(BmMap map, Vector2i regionPos) {
        this(map, regionPos, false);
    }

    public WorldRegionRenderTask(BmMap map, Vector2i regionPos, boolean force) {
        this(map, regionPos, TileUpdateStrategy.fixed(force));
    }

    public WorldRegionRenderTask(BmMap map, Vector2i regionPos, TileUpdateStrategy force) {
        this.map = map;
        this.regionPos = regionPos;
        this.force = force;
        this.nextTileX = 0;
        this.nextTileZ = 0;
        this.atWork = 0;
        this.completed = false;
        this.cancelled = false;
    }

    private synchronized void init() {
        this.regionGrid = this.map.getWorld().getRegionGrid();
        this.chunkGrid = this.map.getWorld().getChunkGrid();
        this.tileGrid = this.map.getHiresModelManager().getTileGrid();
        this.chunkMin = this.regionGrid.getCellMin(this.regionPos, this.chunkGrid);
        this.chunkMax = this.regionGrid.getCellMax(this.regionPos, this.chunkGrid);
        this.chunksSize = this.chunkMax.sub(this.chunkMin).add(1, 1);
        this.tileMin = this.regionGrid.getCellMin(this.regionPos, this.tileGrid);
        this.tileMax = this.regionGrid.getCellMax(this.regionPos, this.tileGrid);
        this.tileSize = this.tileMax.sub(this.tileMin).add(1, 1);
        int chunkMaxCount = this.chunksSize.getX() * this.chunksSize.getY();
        try {
            this.chunkHashes = new int[chunkMaxCount];
            this.map.getWorld().getRegion(this.regionPos.getX(), this.regionPos.getY()).iterateAllChunks((x, z, timestamp) -> {
                this.chunkHashes[this.chunkIndex((int)(x - this.chunkMin.getX()), (int)(z - this.chunkMin.getY()))] = timestamp;
                this.map.getWorld().invalidateChunkCache(x, z);
            });
        }
        catch (IOException ex) {
            Logger.global.logError("Failed to load chunks for region " + String.valueOf(this.regionPos), ex);
            this.cancel();
        }
        int tileMaxCount = this.tileSize.getX() * this.tileSize.getY();
        int tileRenderCount = 0;
        int tileDeleteCount = 0;
        this.tileActions = new TileActionResolver.ActionAndNextState[tileMaxCount];
        for (int x2 = 0; x2 < this.tileSize.getX(); ++x2) {
            for (int z2 = 0; z2 < this.tileSize.getY(); ++z2) {
                Vector2i tile = new Vector2i(this.tileMin.getX() + x2, this.tileMin.getY() + z2);
                TileState tileState = this.map.getMapTileState().get(tile.getX(), tile.getY()).getState();
                int tileIndex = this.tileIndex(x2, z2);
                this.tileActions[tileIndex] = tileState.findActionAndNextState(this.force.test(tileState) || this.checkChunksHaveChanges(tile), this.checkTileBounds(tile));
                if (this.tileActions[tileIndex].action() == TileActionResolver.Action.RENDER) {
                    ++tileRenderCount;
                }
                if (this.tileActions[tileIndex].action() != TileActionResolver.Action.DELETE) continue;
                ++tileDeleteCount;
            }
        }
        if ((double)tileRenderCount >= (double)tileMaxCount * 0.75) {
            this.map.getWorld().preloadRegionChunks(this.regionPos.getX(), this.regionPos.getY());
        }
        if (tileRenderCount + tileDeleteCount == 0) {
            this.completed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doWork() {
        int tileZ;
        int tileX;
        if (this.cancelled || this.completed) {
            return;
        }
        WorldRegionRenderTask worldRegionRenderTask = this;
        synchronized (worldRegionRenderTask) {
            if (this.cancelled || this.completed) {
                return;
            }
            tileX = this.nextTileX;
            tileZ = this.nextTileZ;
            if (tileX == 0 && tileZ == 0) {
                this.init();
                if (this.cancelled || this.completed) {
                    return;
                }
            }
            this.nextTileX = tileX + 1;
            if (this.nextTileX >= this.tileSize.getX()) {
                this.nextTileZ = tileZ + 1;
                this.nextTileX = 0;
            }
            if (this.nextTileZ >= this.tileSize.getY()) {
                this.completed = true;
            }
            ++this.atWork;
        }
        this.processTile(tileX, tileZ);
        worldRegionRenderTask = this;
        synchronized (worldRegionRenderTask) {
            --this.atWork;
            if (this.atWork <= 0 && this.completed && !this.cancelled) {
                this.complete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTile(int x, int z) {
        Vector2i tile = new Vector2i(this.tileMin.getX() + x, this.tileMin.getY() + z);
        TileActionResolver.ActionAndNextState action = this.tileActions[this.tileIndex(x, z)];
        TileState resultState = TileState.RENDER_ERROR;
        try {
            resultState = switch (action.action()) {
                default -> throw new MatchException(null, null);
                case TileActionResolver.Action.NONE -> action.state();
                case TileActionResolver.Action.RENDER -> {
                    TileState failedState = this.checkTileRenderPreconditions(tile);
                    if (failedState != null) {
                        this.map.unrenderTile(tile);
                        yield failedState;
                    }
                    this.map.renderTile(tile);
                    yield action.state();
                }
                case TileActionResolver.Action.DELETE -> {
                    this.map.unrenderTile(tile);
                    yield action.state();
                }
            };
        }
        catch (Exception ex) {
            Logger.global.logError("Error while processing map-tile " + String.valueOf(tile) + " for map '" + this.map.getId() + "'", ex);
        }
        finally {
            this.map.getMapTileState().set(tile.getX(), tile.getY(), new TileInfoRegion.TileInfo((int)(System.currentTimeMillis() / 1000L), resultState));
        }
    }

    private synchronized void complete() {
        if (this.chunkHashes != null) {
            for (int x = 0; x < this.chunksSize.getX(); ++x) {
                for (int z = 0; z < this.chunksSize.getY(); ++z) {
                    int hash = this.chunkHashes[this.chunkIndex(x, z)];
                    this.map.getMapChunkState().set(this.chunkMin.getX() + x, this.chunkMin.getY() + z, hash);
                }
            }
            this.chunkHashes = null;
        }
        this.tileActions = null;
        this.map.save(TimeUnit.MINUTES.toMillis(1L));
    }

    @Override
    @DebugDump
    public synchronized boolean hasMoreWork() {
        return !this.completed && !this.cancelled;
    }

    @Override
    @DebugDump
    public double estimateProgress() {
        if (this.tileSize == null) {
            return 0.0;
        }
        return Math.min((double)(this.nextTileZ * this.tileSize.getX() + this.nextTileX) / (double)(this.tileSize.getX() * this.tileSize.getY()), 1.0);
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    @Override
    public String getDescription() {
        return "updating region %s".formatted(this.regionPos);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorldRegionRenderTask that = (WorldRegionRenderTask)o;
        return this.force == that.force && this.map.getId().equals(that.map.getId()) && this.regionPos.equals((Object)that.regionPos);
    }

    public int hashCode() {
        return this.regionPos.hashCode();
    }

    private int chunkIndex(int x, int z) {
        return z * this.chunksSize.getX() + x;
    }

    private int tileIndex(int x, int z) {
        return z * this.tileSize.getX() + x;
    }

    private boolean checkChunksHaveChanges(Vector2i tile) {
        int minX = this.tileGrid.getCellMinX(tile.getX(), this.chunkGrid);
        int maxX = this.tileGrid.getCellMaxX(tile.getX(), this.chunkGrid);
        int minZ = this.tileGrid.getCellMinY(tile.getY(), this.chunkGrid);
        int maxZ = this.tileGrid.getCellMaxY(tile.getY(), this.chunkGrid);
        for (int chunkX = minX; chunkX <= maxX; ++chunkX) {
            for (int chunkZ = minZ; chunkZ <= maxZ; ++chunkZ) {
                int dx = chunkX - this.chunkMin.getX();
                int dz = chunkZ - this.chunkMin.getY();
                if (chunkX < this.chunkMin.getX() || chunkX > this.chunkMax.getX() || chunkZ < this.chunkMin.getY() || chunkZ > this.chunkMax.getY()) continue;
                int hash = this.chunkHashes[this.chunkIndex(dx, dz)];
                int lastHash = this.map.getMapChunkState().get(chunkX, chunkZ);
                if (lastHash == hash) continue;
                return true;
            }
        }
        return false;
    }

    private TileActionResolver.BoundsSituation checkTileBounds(Vector2i tile) {
        boolean isInsideBounds = this.map.getMapSettings().isInsideRenderBoundaries(tile, this.tileGrid, true);
        if (!isInsideBounds) {
            return TileActionResolver.BoundsSituation.OUTSIDE;
        }
        boolean isFullyInsideBounds = this.map.getMapSettings().isInsideRenderBoundaries(tile, this.tileGrid, false);
        return isFullyInsideBounds ? TileActionResolver.BoundsSituation.INSIDE : TileActionResolver.BoundsSituation.EDGE;
    }

    @Nullable
    private TileState checkTileRenderPreconditions(Vector2i tile) {
        Chunk chunk;
        int chunkZ;
        int chunkX;
        boolean chunksAreInhabited = false;
        long minInhabitedTime = this.map.getMapSettings().getMinInhabitedTime();
        int minInhabitedTimeRadius = this.map.getMapSettings().getMinInhabitedTimeRadius();
        boolean requireLight = !this.map.getMapSettings().isIgnoreMissingLightData();
        int minX = this.tileGrid.getCellMinX(tile.getX(), this.chunkGrid);
        int maxX = this.tileGrid.getCellMaxX(tile.getX(), this.chunkGrid);
        int minZ = this.tileGrid.getCellMinY(tile.getY(), this.chunkGrid);
        int maxZ = this.tileGrid.getCellMaxY(tile.getY(), this.chunkGrid);
        for (chunkX = minX; chunkX <= maxX; ++chunkX) {
            for (chunkZ = minZ; chunkZ <= maxZ; ++chunkZ) {
                chunk = this.map.getWorld().getChunk(chunkX, chunkZ);
                if (chunk == Chunk.ERRORED_CHUNK) {
                    return TileState.CHUNK_ERROR;
                }
                if (!chunk.isGenerated()) {
                    return TileState.NOT_GENERATED;
                }
                if (requireLight && !chunk.hasLightData()) {
                    return TileState.MISSING_LIGHT;
                }
                if (chunk.getInhabitedTime() < minInhabitedTime) continue;
                chunksAreInhabited = true;
            }
        }
        if (!chunksAreInhabited && minInhabitedTimeRadius > 0) {
            block2: for (chunkX = minX - minInhabitedTimeRadius; chunkX <= maxX + minInhabitedTimeRadius; ++chunkX) {
                for (chunkZ = minZ - minInhabitedTimeRadius; chunkZ <= maxZ + minInhabitedTimeRadius; ++chunkZ) {
                    chunk = this.map.getWorld().getChunk(chunkX, chunkZ);
                    if (chunk.getInhabitedTime() < minInhabitedTime) continue;
                    chunksAreInhabited = true;
                    break block2;
                }
            }
        }
        return chunksAreInhabited ? null : TileState.LOW_INHABITED_TIME;
    }

    public static Comparator<WorldRegionRenderTask> defaultComparator(Vector2i centerRegion) {
        return (task1, task2) -> {
            Vector2l task1Rel = new Vector2l((long)(task1.regionPos.getX() - centerRegion.getX()), (long)(task1.regionPos.getY() - centerRegion.getY()));
            Vector2l task2Rel = new Vector2l((long)(task2.regionPos.getX() - centerRegion.getX()), (long)(task2.regionPos.getY() - centerRegion.getY()));
            return WorldRegionRenderTask.compareVec2L(task1Rel, task2Rel);
        };
    }

    private static int compareVec2L(Vector2l v1, Vector2l v2) {
        return Long.signum(v1.lengthSquared() - v2.lengthSquared());
    }

    @Override
    public BmMap getMap() {
        return this.map;
    }

    public Vector2i getRegionPos() {
        return this.regionPos;
    }

    public TileUpdateStrategy getForce() {
        return this.force;
    }
}

