/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.web.http;

import de.bluecolored.bluemap.common.web.http.HttpHeader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpRequest {
    private static final Pattern REQUEST_PATTERN = Pattern.compile("^(\\w+) (\\S+) (.+)$");
    private final ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
    private final StringBuffer lineBuffer = new StringBuffer();
    private boolean complete = false;
    private boolean headerComplete = false;
    private final List<String> headerLines = new ArrayList<String>(20);
    private final InetAddress source;
    private String method;
    private String address;
    private String version;
    private final Map<String, HttpHeader> headers = new HashMap<String, HttpHeader>();
    private byte[] data;
    private String path = null;
    private String getParamString = null;
    private Map<String, String> getParams = null;

    public HttpRequest(InetAddress source) {
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(ReadableByteChannel channel) throws IOException {
        if (this.complete) {
            return true;
        }
        int read = channel.read(this.byteBuffer);
        if (read == 0) {
            return false;
        }
        if (read == -1) {
            channel.close();
            return false;
        }
        this.byteBuffer.flip();
        try {
            while (!this.headerComplete) {
                if (!this.writeLine()) {
                    boolean bl = false;
                    return bl;
                }
                String line = this.lineBuffer.toString().stripTrailing();
                this.lineBuffer.setLength(0);
                if (line.isEmpty()) {
                    this.headerComplete = true;
                    this.parseHeaders();
                    continue;
                }
                this.headerLines.add(line);
            }
            if (this.hasHeaderValue("transfer-encoding", "chunked")) {
                this.writeChunkedBody();
            } else {
                HttpHeader contentLengthHeader = this.getHeader("content-length");
                int contentLength = 0;
                if (contentLengthHeader != null) {
                    try {
                        contentLength = Integer.parseInt(contentLengthHeader.getValue().trim());
                    }
                    catch (NumberFormatException ex) {
                        throw new IOException("Invalid HTTP Request: content-length is not a number", ex);
                    }
                }
                if (contentLength > 0) {
                    this.writeBody(contentLength);
                }
            }
            this.complete = true;
            boolean bl = true;
            return bl;
        }
        finally {
            this.byteBuffer.compact();
        }
    }

    private void writeChunkedBody() {
    }

    private void writeBody(int length) {
    }

    private void parseHeaders() throws IOException {
        if (this.headerLines.isEmpty()) {
            throw new IOException("Invalid HTTP Request: No Header");
        }
        Matcher m4 = REQUEST_PATTERN.matcher(this.headerLines.get(0));
        if (!m4.find()) {
            throw new IOException("Invalid HTTP Request: Request-Pattern not matching");
        }
        this.method = m4.group(1);
        if (this.method == null) {
            throw new IOException("Invalid HTTP Request: Request-Pattern not matching (method)");
        }
        this.address = m4.group(2);
        if (this.address == null) {
            throw new IOException("Invalid HTTP Request: Request-Pattern not matching (address)");
        }
        this.version = m4.group(3);
        if (this.version == null) {
            throw new IOException("Invalid HTTP Request: Request-Pattern not matching (version)");
        }
        this.headers.clear();
        for (int i = 1; i < this.headerLines.size(); ++i) {
            String[] kv;
            String line = this.headerLines.get(i);
            if (line.trim().isEmpty() || (kv = line.split(":", 2)).length < 2) continue;
            this.headers.put(kv[0].trim().toLowerCase(Locale.ROOT), new HttpHeader(kv[0], kv[1]));
        }
    }

    private boolean writeLine() {
        while (this.lineBuffer.length() <= 0 || this.lineBuffer.charAt(this.lineBuffer.length() - 1) != '\n') {
            if (!this.byteBuffer.hasRemaining()) {
                return false;
            }
            this.lineBuffer.append((char)this.byteBuffer.get());
        }
        return true;
    }

    public InetAddress getSource() {
        return this.source;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
        this.path = null;
        this.getParams = null;
        this.getParamString = null;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Map<String, HttpHeader> getHeaders() {
        return this.headers;
    }

    public HttpHeader getHeader(String header) {
        return this.headers.get(header.toLowerCase(Locale.ROOT));
    }

    public boolean hasHeaderValue(String key, String value) {
        HttpHeader header = this.getHeader(key);
        if (header == null) {
            return false;
        }
        return header.contains(value);
    }

    public byte[] getData() {
        return this.data;
    }

    public InputStream getDataStream() {
        return new ByteArrayInputStream(this.data);
    }

    public String getPath() {
        if (this.path == null) {
            this.parseAddress();
        }
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Map<String, String> getGETParams() {
        if (this.getParams == null) {
            this.parseGetParams();
        }
        return this.getParams;
    }

    public String getGETParamString() {
        if (this.getParamString == null) {
            this.parseAddress();
        }
        return this.getParamString;
    }

    public void setGetParamString(String getParamString) {
        this.getParamString = getParamString;
        this.getParams = null;
    }

    private void parseAddress() {
        String address = this.getAddress();
        if (address.isEmpty()) {
            address = "/";
        }
        String[] addressParts = address.split("\\?", 2);
        String path = addressParts[0];
        this.getParamString = addressParts.length > 1 ? addressParts[1] : "";
        this.path = path;
    }

    private void parseGetParams() {
        HashMap<String, String> getParams = new HashMap<String, String>();
        for (String getParam : this.getGETParamString().split("&")) {
            if (getParam.isEmpty()) continue;
            String[] kv = getParam.split("=", 2);
            String key = kv[0];
            String value = kv.length > 1 ? kv[1] : "";
            getParams.put(key, value);
        }
        this.getParams = getParams;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void clear() {
        this.byteBuffer.clear();
        this.lineBuffer.setLength(0);
        this.complete = false;
        this.headerComplete = false;
        this.headerLines.clear();
        this.method = null;
        this.address = null;
        this.version = null;
        this.headers.clear();
        this.data = null;
        this.path = null;
        this.getParamString = null;
        this.getParams = null;
    }
}

