/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.logger;

import de.bluecolored.bluemap.core.logger.JavaLogger;
import de.bluecolored.bluemap.core.logger.LogFormatter;
import de.bluecolored.bluemap.core.logger.MultiLogger;
import de.bluecolored.bluemap.core.logger.PrintStreamLogger;
import de.bluecolored.bluemap.core.logger.VoidLogger;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.Nullable;

public abstract class Logger
implements AutoCloseable {
    public static final MultiLogger global = new MultiLogger(Logger.stdOut());

    public void logError(Throwable throwable) {
        this.logError(throwable.getMessage(), throwable);
    }

    public abstract void logError(String var1, Throwable var2);

    public abstract void logWarning(String var1);

    public abstract void logInfo(String var1);

    public abstract void logDebug(String var1);

    public abstract void noFloodError(String var1, String var2, Throwable var3);

    public abstract void noFloodWarning(String var1, String var2);

    public abstract void noFloodInfo(String var1, String var2);

    public abstract void noFloodDebug(String var1, String var2);

    public void noFloodError(Throwable throwable) {
        this.noFloodError(throwable.getMessage(), throwable);
    }

    public void noFloodError(String message, Throwable throwable) {
        this.noFloodError(message, message, throwable);
    }

    public void noFloodWarning(String message) {
        this.noFloodWarning(message, message);
    }

    public void noFloodInfo(String message) {
        this.noFloodInfo(message, message);
    }

    public void noFloodDebug(String message) {
        this.noFloodDebug(message, message);
    }

    @Override
    public void close() throws Exception {
    }

    public abstract void clearNoFloodLog();

    public abstract void removeNoFloodKey(String var1);

    public void removeNoFloodMessage(String message) {
        this.removeNoFloodKey(message);
    }

    public static Logger stdOut() {
        return new PrintStreamLogger(System.out, System.err);
    }

    public static Logger stdOut(boolean debug) {
        return new PrintStreamLogger(System.out, System.err, debug);
    }

    public static Logger file(Path path) throws IOException {
        return Logger.file(path, null);
    }

    public static Logger file(Path path, boolean append) throws IOException {
        return Logger.file(path, null, append);
    }

    public static Logger file(Path path, String format) throws IOException {
        return Logger.file(path, format, true);
    }

    public static Logger file(Path path, @Nullable String format, boolean append) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        FileHandler fileHandler = new FileHandler(path.toString(), append);
        fileHandler.setFormatter(format == null ? new LogFormatter() : new LogFormatter(format));
        java.util.logging.Logger javaLogger = java.util.logging.Logger.getAnonymousLogger();
        javaLogger.setLevel(Level.ALL);
        javaLogger.setUseParentHandlers(false);
        javaLogger.addHandler(fileHandler);
        return new JavaLogger(javaLogger);
    }

    public static Logger combine(Iterable<Logger> logger) {
        return Logger.combine((Logger[])StreamSupport.stream(logger.spliterator(), false).toArray(Logger[]::new));
    }

    public static Logger combine(Logger ... logger) {
        if (logger.length == 0) {
            return new VoidLogger();
        }
        if (logger.length == 1) {
            return logger[0];
        }
        return new MultiLogger(logger);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                global.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
    }
}

