/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.logger;

import de.bluecolored.bluemap.core.logger.AbstractLogger;
import de.bluecolored.bluemap.core.logger.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class MultiLogger
extends AbstractLogger {
    private static final AtomicInteger LOGGER_INDEX = new AtomicInteger(0);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<String, Logger> logger = new HashMap<String, Logger>();

    public MultiLogger(Logger ... logger) {
        for (Logger l : logger) {
            this.put(l);
        }
    }

    public void put(Logger logger) {
        this.put("anonymous-logger-" + LOGGER_INDEX.getAndIncrement(), () -> logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String name, LoggerSupplier loggerSupplier) {
        this.lock.writeLock().lock();
        try {
            this.remove(name);
            this.logger.put(name, loggerSupplier.get());
        }
        catch (Exception ex) {
            this.logError("Failed to close Logger!", ex);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void remove(String name) {
        this.lock.writeLock().lock();
        try {
            Logger removed = this.logger.remove(name);
            if (removed != null) {
                removed.close();
            }
        }
        catch (Exception ex) {
            this.logError("Failed to close Logger!", ex);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.lock.writeLock().lock();
        try {
            String[] loggerNames;
            for (String name : loggerNames = (String[])this.logger.keySet().toArray(String[]::new)) {
                this.remove(name);
            }
            this.logger.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logError(String message, Throwable throwable) {
        this.lock.readLock().lock();
        try {
            for (Logger l : this.logger.values()) {
                l.logError(message, throwable);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logWarning(String message) {
        this.lock.readLock().lock();
        try {
            for (Logger l : this.logger.values()) {
                l.logWarning(message);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logInfo(String message) {
        this.lock.readLock().lock();
        try {
            for (Logger l : this.logger.values()) {
                l.logInfo(message);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logDebug(String message) {
        this.lock.readLock().lock();
        try {
            for (Logger l : this.logger.values()) {
                l.logDebug(message);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void close() throws Exception {
        this.lock.readLock().lock();
        try {
            for (Logger l : this.logger.values()) {
                l.close();
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @FunctionalInterface
    public static interface LoggerSupplier {
        public Logger get() throws Exception;
    }
}

