/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack.resourcepack.blockstate;

import com.google.gson.Gson;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import de.bluecolored.bluemap.core.resources.AbstractTypeAdapterFactory;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.blockstate.BlockStateCondition;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.blockstate.Variant;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.blockstate.VariantSet;
import de.bluecolored.bluemap.core.world.BlockState;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.Consumer;

@JsonAdapter(value=Adapter.class)
public class Multipart {
    private VariantSet[] parts = new VariantSet[0];

    private Multipart() {
    }

    public void forEach(BlockState blockState, int x, int y, int z, Consumer<Variant> consumer) {
        for (VariantSet part : this.parts) {
            if (!part.getCondition().matches(blockState)) continue;
            part.forEach(x, y, z, consumer);
        }
    }

    public VariantSet[] getParts() {
        return this.parts;
    }

    static class Adapter
    extends AbstractTypeAdapterFactory<Multipart> {
        public Adapter() {
            super(Multipart.class);
        }

        @Override
        public Multipart read(JsonReader in, Gson gson) throws IOException {
            ArrayList<VariantSet> parts = new ArrayList<VariantSet>();
            in.beginArray();
            while (in.hasNext()) {
                VariantSet variantSet = null;
                BlockStateCondition condition = null;
                in.beginObject();
                block9: while (in.hasNext()) {
                    String key;
                    switch (key = in.nextName()) {
                        case "when": {
                            condition = this.readCondition(in);
                            continue block9;
                        }
                        case "apply": {
                            variantSet = (VariantSet)gson.fromJson(in, VariantSet.class);
                            continue block9;
                        }
                    }
                    in.skipValue();
                }
                in.endObject();
                if (variantSet == null) continue;
                if (condition != null) {
                    variantSet.setCondition(condition);
                }
                parts.add(variantSet);
            }
            in.endArray();
            Multipart result = new Multipart();
            result.parts = (VariantSet[])parts.toArray(VariantSet[]::new);
            return result;
        }

        public BlockStateCondition readCondition(JsonReader in) throws IOException {
            ArrayList<BlockStateCondition> andConditions = new ArrayList<BlockStateCondition>();
            in.beginObject();
            block10: while (in.hasNext()) {
                String name;
                switch (name = in.nextName()) {
                    case "__comment": {
                        in.skipValue();
                        continue block10;
                    }
                    case "OR": {
                        ArrayList<BlockStateCondition> orConditions = new ArrayList<BlockStateCondition>();
                        in.beginArray();
                        while (in.hasNext()) {
                            orConditions.add(this.readCondition(in));
                        }
                        in.endArray();
                        andConditions.add(BlockStateCondition.or(orConditions.toArray(new BlockStateCondition[0])));
                        continue block10;
                    }
                    case "AND": {
                        ArrayList<BlockStateCondition> andArray = new ArrayList<BlockStateCondition>();
                        in.beginArray();
                        while (in.hasNext()) {
                            andArray.add(this.readCondition(in));
                        }
                        in.endArray();
                        andConditions.add(BlockStateCondition.and(andArray.toArray(new BlockStateCondition[0])));
                        continue block10;
                    }
                }
                String[] values = this.nextStringOrBoolean(in).split("\\|");
                andConditions.add(BlockStateCondition.property(name, values));
            }
            in.endObject();
            return BlockStateCondition.and(andConditions.toArray(new BlockStateCondition[0]));
        }

        private String nextStringOrBoolean(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.BOOLEAN) {
                return Boolean.toString(in.nextBoolean());
            }
            return in.nextString();
        }
    }
}

