/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.fabric;

import com.mojang.brigadier.tree.RootCommandNode;
import de.bluecolored.bluecommands.brigadier.BrigadierBridge;
import de.bluecolored.bluemap.common.commands.BrigadierExecutionHandler;
import de.bluecolored.bluemap.common.commands.Commands;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.serverinterface.Player;
import de.bluecolored.bluemap.common.serverinterface.Server;
import de.bluecolored.bluemap.common.serverinterface.ServerEventListener;
import de.bluecolored.bluemap.common.serverinterface.ServerWorld;
import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.fabric.FabricCommandSource;
import de.bluecolored.bluemap.fabric.FabricEventForwarder;
import de.bluecolored.bluemap.fabric.FabricPlayer;
import de.bluecolored.bluemap.fabric.FabricWorld;
import de.bluecolored.bluemap.fabric.Log4jLogger;
import de.bluecolored.shadow.caffeine.cache.Caffeine;
import de.bluecolored.shadow.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_155;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;

public class FabricMod
implements ModInitializer,
Server {
    private final Plugin pluginInstance;
    private MinecraftServer serverInstance = null;
    private final FabricEventForwarder eventForwarder;
    private final LoadingCache<class_3218, ServerWorld> worlds;
    private int playerUpdateIndex = 0;
    private final Map<UUID, Player> onlinePlayerMap;
    private final List<FabricPlayer> onlinePlayerList;

    public FabricMod() {
        Logger.global.clear();
        Logger.global.put(new Log4jLogger(LogManager.getLogger((String)"BlueMap")));
        this.onlinePlayerMap = new ConcurrentHashMap<UUID, Player>();
        this.onlinePlayerList = Collections.synchronizedList(new ArrayList());
        this.pluginInstance = new Plugin("fabric", this);
        this.eventForwarder = new FabricEventForwarder(this);
        this.worlds = Caffeine.newBuilder().executor(BlueMap.THREAD_POOL).weakKeys().maximumSize(1000L).build(FabricWorld::new);
    }

    public void onInitialize() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> BrigadierBridge.createCommandNodes(Commands.create(this.pluginInstance), new BrigadierExecutionHandler(this.pluginInstance), fabricSource -> new FabricCommandSource(this, (class_2168)fabricSource)).forEach(arg_0 -> ((RootCommandNode)dispatcher.getRoot()).addChild(arg_0)));
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            this.serverInstance = server;
            new Thread(() -> {
                Logger.global.logInfo("Loading BlueMap...");
                try {
                    this.pluginInstance.load();
                    if (this.pluginInstance.isLoaded()) {
                        Logger.global.logInfo("BlueMap loaded!");
                    }
                }
                catch (IOException e) {
                    Logger.global.logError("Failed to load bluemap!", e);
                    this.pluginInstance.unload();
                }
            }, "BlueMap-Plugin-Loading").start();
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            this.pluginInstance.unload();
            Logger.global.logInfo("BlueMap unloaded!");
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> this.onPlayerJoin(server, handler.method_32311()));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> this.onPlayerLeave(server, handler.method_32311()));
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (server == this.serverInstance) {
                this.updateSomePlayers();
            }
        });
        this.eventForwarder.init();
    }

    @Override
    public String getMinecraftVersion() {
        return class_155.method_16673().method_48018();
    }

    @Override
    public void registerListener(ServerEventListener listener) {
        this.eventForwarder.addEventListener(listener);
    }

    @Override
    public void unregisterAllListeners() {
        this.eventForwarder.removeAllListeners();
    }

    @Override
    public Collection<ServerWorld> getLoadedServerWorlds() {
        ArrayList<ServerWorld> loadedWorlds = new ArrayList<ServerWorld>(3);
        for (class_3218 serverWorld : this.serverInstance.method_3738()) {
            loadedWorlds.add(this.worlds.get(serverWorld));
        }
        return loadedWorlds;
    }

    @Override
    public Optional<ServerWorld> getServerWorld(Object world) {
        class_2960 identifier;
        if (world instanceof String && (identifier = class_2960.method_12829((String)((String)world))) != null) {
            world = this.serverInstance.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)identifier));
        }
        if (world instanceof class_5321) {
            try {
                world = this.serverInstance.method_3847((class_5321)world);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (world instanceof class_3218) {
            return Optional.of(this.getServerWorld((class_3218)world));
        }
        return Optional.empty();
    }

    public ServerWorld getServerWorld(class_3218 serverWorld) {
        return this.worlds.get(serverWorld);
    }

    @Override
    public Path getConfigFolder() {
        return Path.of("config", "bluemap");
    }

    @Override
    public Optional<Path> getModsFolder() {
        return Optional.of(Path.of("mods", new String[0]));
    }

    public void onPlayerJoin(MinecraftServer server, class_3222 playerInstance) {
        if (this.serverInstance != server) {
            return;
        }
        FabricPlayer player = new FabricPlayer(playerInstance, this);
        this.onlinePlayerMap.put(player.getUuid(), player);
        this.onlinePlayerList.add(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPlayerLeave(MinecraftServer server, class_3222 player) {
        if (this.serverInstance != server) {
            return;
        }
        UUID playerUUID = player.method_5667();
        this.onlinePlayerMap.remove(playerUUID);
        List<FabricPlayer> list = this.onlinePlayerList;
        synchronized (list) {
            this.onlinePlayerList.removeIf(p -> p.getUuid().equals(playerUUID));
        }
    }

    public MinecraftServer getServer() {
        return this.serverInstance;
    }

    public Plugin getPluginInstance() {
        return this.pluginInstance;
    }

    @Override
    public Collection<Player> getOnlinePlayers() {
        return this.onlinePlayerMap.values();
    }

    private void updateSomePlayers() {
        int onlinePlayerCount = this.onlinePlayerList.size();
        if (onlinePlayerCount == 0) {
            return;
        }
        int playersToBeUpdated = onlinePlayerCount / 20;
        if (playersToBeUpdated == 0) {
            playersToBeUpdated = 1;
        }
        for (int i = 0; i < playersToBeUpdated; ++i) {
            ++this.playerUpdateIndex;
            if (this.playerUpdateIndex >= 20 && this.playerUpdateIndex >= onlinePlayerCount) {
                this.playerUpdateIndex = 0;
            }
            if (this.playerUpdateIndex >= onlinePlayerCount) continue;
            this.onlinePlayerList.get(this.playerUpdateIndex).update();
        }
    }
}

