/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.configurate.serialize;

import de.bluecolored.shadow.checkerframework.checker.nullness.qual.Nullable;
import de.bluecolored.shadow.configurate.serialize.ScalarSerializer;
import de.bluecolored.shadow.configurate.serialize.SerializationException;
import de.bluecolored.shadow.configurate.util.EnumLookup;
import de.bluecolored.shadow.geantyref.GenericTypeReflector;
import de.bluecolored.shadow.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.function.Predicate;

final class EnumValueSerializer
extends ScalarSerializer<Enum<?>> {
    EnumValueSerializer() {
        super(new TypeToken<Enum<?>>(){});
    }

    @Override
    public Enum<?> deserialize(Type type, Object obj) throws SerializationException {
        String enumConstant = obj.toString();
        @Nullable Enum ret = EnumLookup.lookupEnum(GenericTypeReflector.erase(type).asSubclass(Enum.class), enumConstant);
        if (ret == null) {
            throw new SerializationException(type, "Invalid enum constant provided, expected a value of enum, got " + enumConstant);
        }
        return ret;
    }

    @Override
    public Object serialize(Enum<?> item, Predicate<Class<?>> typeSupported) {
        return item.name();
    }
}

