/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.client;

import java.util.Optional;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1646;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import org.carpetorgaddition.client.command.DictionaryCommand;
import org.carpetorgaddition.client.command.HighlightCommand;
import org.carpetorgaddition.client.logger.ClientLogger;
import org.carpetorgaddition.client.renderer.WorldRendererManager;
import org.carpetorgaddition.client.renderer.beaconbox.BeaconBoxRenderer;
import org.carpetorgaddition.client.renderer.villagerpoi.VillagerPoiRenderer;
import org.carpetorgaddition.client.renderer.waypoint.WaypointRenderer;
import org.carpetorgaddition.client.renderer.waypoint.WaypointRendererType;
import org.carpetorgaddition.debug.client.command.SelectionAreaCommand;
import org.carpetorgaddition.debug.client.render.HudDebugRendererRegister;
import org.carpetorgaddition.network.s2c.BackgroundSpriteSyncS2CPacket;
import org.carpetorgaddition.network.s2c.BeaconBoxUpdateS2CPacket;
import org.carpetorgaddition.network.s2c.LoggerUpdateS2CPacket;
import org.carpetorgaddition.network.s2c.UnavailableSlotSyncS2CPacket;
import org.carpetorgaddition.network.s2c.VillagerPoiSyncS2CPacket;
import org.carpetorgaddition.network.s2c.WaypointClearS2CPacket;
import org.carpetorgaddition.network.s2c.WaypointUpdateS2CPacket;
import org.carpetorgaddition.util.screen.BackgroundSpriteSyncSlot;
import org.carpetorgaddition.util.screen.UnavailableSlotImplInterface;

public class CarpetOrgAdditionClientRegister {
    public static void register() {
        CarpetOrgAdditionClientRegister.registerCommand();
        CarpetOrgAdditionClientRegister.registerC2SNetworkPack();
        CarpetOrgAdditionClientRegister.registerNetworkPackReceiver();
        CarpetOrgAdditionClientRegister.registerRender();
        CarpetOrgAdditionClientRegister.developed();
    }

    private static void registerCommand() {
        HighlightCommand.register();
        DictionaryCommand.register();
    }

    private static void registerC2SNetworkPack() {
    }

    private static void registerNetworkPackReceiver() {
        ClientPlayNetworking.registerGlobalReceiver(WaypointUpdateS2CPacket.ID, (payload, context) -> WorldRendererManager.addOrUpdate(new WaypointRenderer(WaypointRendererType.NAVIGATOR, payload.target(), payload.worldId())));
        ClientPlayNetworking.registerGlobalReceiver(WaypointClearS2CPacket.ID, (payload, context) -> Optional.ofNullable(WorldRendererManager.getOnlyRenderer(WaypointRenderer.class, renderer -> renderer.getRenderType() == WaypointRendererType.NAVIGATOR)).ifPresent(WaypointRenderer::setFade));
        ClientPlayNetworking.registerGlobalReceiver(UnavailableSlotSyncS2CPacket.ID, (payload, context) -> {
            class_1703 screen = context.player().field_7512;
            if (screen.field_7763 == payload.syncId() && screen instanceof UnavailableSlotImplInterface) {
                UnavailableSlotImplInterface anInterface = (UnavailableSlotImplInterface)screen;
                anInterface.sync((UnavailableSlotSyncS2CPacket)payload);
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(BackgroundSpriteSyncS2CPacket.ID, (payload, context) -> {
            class_1735 patt0$temp;
            class_1703 screen = context.player().field_7512;
            if (screen.field_7763 == payload.syncId() && (patt0$temp = screen.method_7611(payload.slotIndex())) instanceof BackgroundSpriteSyncSlot) {
                BackgroundSpriteSyncSlot slot = (BackgroundSpriteSyncSlot)patt0$temp;
                slot.setIdentifier(payload.identifier());
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(BeaconBoxUpdateS2CPacket.ID, (payload, context) -> {
            if (BeaconBoxUpdateS2CPacket.ZERO.equals((Object)payload.box())) {
                WorldRendererManager.remove(BeaconBoxRenderer.class, renderer -> renderer.getBlockPos().equals((Object)payload.blockPos()));
                return;
            }
            BeaconBoxRenderer beaconBoxRenderer = WorldRendererManager.getOrCreate(BeaconBoxRenderer.class, renderer -> renderer.getBlockPos().equals((Object)payload.blockPos()), () -> new BeaconBoxRenderer(payload.blockPos(), payload.box()));
            beaconBoxRenderer.setSizeModifier(payload.box());
        });
        ClientPlayNetworking.registerGlobalReceiver(VillagerPoiSyncS2CPacket.ID, (payload, context) -> {
            class_1297 patt0$temp = context.client().field_1687.method_8469(payload.info().geVillagerId());
            if (patt0$temp instanceof class_1646) {
                class_1646 villager = (class_1646)patt0$temp;
                VillagerPoiSyncS2CPacket.VillagerInfo villagerInfo = payload.info();
                VillagerPoiRenderer render = new VillagerPoiRenderer(villager, villagerInfo.getBedPos(), villagerInfo.getJobSitePos(), villagerInfo.getPotentialJobSite());
                WorldRendererManager.addOrUpdate(render);
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(LoggerUpdateS2CPacket.ID, (packet, context) -> ClientLogger.onPacketReceive(packet));
    }

    private static void registerRender() {
        WorldRenderEvents.LAST.register(context -> WorldRendererManager.getRenderer(WaypointRenderer.class).forEach(renderer -> renderer.render(context)));
        WorldRenderEvents.BEFORE_DEBUG_RENDER.register(context -> {
            WorldRendererManager.getRenderer(BeaconBoxRenderer.class).forEach(renderer -> renderer.render(context));
            WorldRendererManager.getRenderer(VillagerPoiRenderer.class).forEach(renderer -> renderer.render(context));
        });
    }

    private static void developed() {
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            HudDebugRendererRegister.register();
            SelectionAreaCommand.register();
        }
    }
}

