/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.client.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.carpetorgaddition.client.command.argument.ClientObjectArgumentType;
import org.carpetorgaddition.client.util.ClientMessageUtils;
import org.carpetorgaddition.util.EnchantmentUtils;
import org.carpetorgaddition.util.TextUtils;
import org.jetbrains.annotations.NotNull;

public class DictionaryCommand {
    public static void register() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            LiteralArgumentBuilder builder = ClientCommandManager.literal((String)"dictionary");
            for (DictionaryType value : DictionaryType.values()) {
                builder.then(ClientCommandManager.literal((String)value.name).then(ClientCommandManager.argument((String)value.name, value.getArgumentType()).executes(context -> DictionaryCommand.getId((CommandContext<FabricClientCommandSource>)context, value))));
            }
            dispatcher.register(builder);
        });
    }

    private static int getId(CommandContext<FabricClientCommandSource> context, DictionaryType type) {
        List<?> list = ClientObjectArgumentType.getType(context, type.name);
        if (list.size() == 1) {
            Object t = list.getFirst();
            String id = type.id(t);
            DictionaryCommand.sendFeedback(type.name(t), id);
        } else {
            DictionaryCommand.sendFeedback(list.size());
            for (Object t : list) {
                DictionaryCommand.sendFeedback(type.id(t));
            }
        }
        return list.size();
    }

    private static void sendFeedback(class_2561 text, String id) {
        ClientMessageUtils.sendMessage("carpet.client.commands.dictionary.id", text, DictionaryCommand.canCopyId(id));
    }

    private static void sendFeedback(int count) {
        ClientMessageUtils.sendMessage("carpet.client.commands.dictionary.multiple.id", count);
    }

    private static void sendFeedback(String id) {
        ClientMessageUtils.sendMessage("carpet.client.commands.dictionary.multiple.each", DictionaryCommand.canCopyId(id));
    }

    @NotNull
    private static class_5250 canCopyId(String id) {
        return TextUtils.copy(id, id, (class_2561)TextUtils.translate("chat.copy.click", new Object[0]), class_124.field_1060);
    }

    private static enum DictionaryType {
        ITEM("item"),
        BLOCK("block"),
        ENTITY("entity"),
        ENCHANTMENT("enchantment"),
        STATUS_EFFECT("statusEffect"),
        BIOME("biome");

        private final String name;

        private DictionaryType(String name) {
            this.name = name;
        }

        private String id(Object obj) {
            class_746 player = Objects.requireNonNull(class_310.method_1551().field_1724);
            class_5455.class_6890 registry = player.field_3944.method_29091();
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> class_7923.field_41178.method_10221((Object)((class_1792)obj)).toString();
                case 1 -> class_7923.field_41175.method_10221((Object)((class_2248)obj)).toString();
                case 2 -> class_7923.field_41177.method_10221((Object)((class_1299)obj)).toString();
                case 3 -> {
                    class_2960 id = registry.method_30530(class_7924.field_41265).method_10221((Object)((class_1887)obj));
                    yield Objects.requireNonNull(id, "\u65e0\u6cd5\u83b7\u53d6\u9644\u9b54id").toString();
                }
                case 4 -> {
                    class_2960 id = registry.method_30530(class_7924.field_41208).method_10221((Object)((class_1291)obj));
                    yield Objects.requireNonNull(id, "\u65e0\u6cd5\u83b7\u53d6\u72b6\u6001\u6548\u679cid").toString();
                }
                case 5 -> {
                    class_2960 id = registry.method_30530(class_7924.field_41236).method_10221((Object)((class_1959)obj));
                    yield Objects.requireNonNull(id, "\u65e0\u6cd5\u83b7\u53d6\u751f\u7269\u7fa4\u7cfbid").toString();
                }
            };
        }

        private class_2561 name(Object obj) {
            class_746 player = Objects.requireNonNull(class_310.method_1551().field_1724);
            class_5455.class_6890 registry = player.field_3944.method_29091();
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> ((class_1792)obj).method_7848();
                case 1 -> ((class_2248)obj).method_9518();
                case 2 -> ((class_1299)obj).method_5897();
                case 3 -> EnchantmentUtils.getName((class_1887)obj);
                case 4 -> ((class_1291)obj).method_5560();
                case 5 -> {
                    class_2960 id = Objects.requireNonNull(registry.method_30530(class_7924.field_41236).method_10221((Object)((class_1959)obj)), "\u65e0\u6cd5\u83b7\u53d6\u751f\u7269\u7fa4\u7cfbid");
                    String key = id.method_42093("biome");
                    yield TextUtils.translate(key, new Object[0]);
                }
            };
        }

        private ArgumentType<?> getArgumentType() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> new ClientObjectArgumentType.ClientItemArgumentType();
                case 1 -> new ClientObjectArgumentType.ClientBlockArgumentType();
                case 2 -> new ClientObjectArgumentType.ClientEntityArgumentType();
                case 3 -> new ClientObjectArgumentType.ClientEnchantmentArgumentType();
                case 4 -> new ClientObjectArgumentType.ClientStatusEffectArgumentType();
                case 5 -> new ClientObjectArgumentType.ClientBiomeArgumentType();
            };
        }
    }
}

