/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.client.renderer.beaconbox;

import java.util.Objects;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.carpetorgaddition.client.renderer.BoxRenderer;
import org.carpetorgaddition.client.renderer.WorldRenderer;
import org.carpetorgaddition.client.renderer.beaconbox.SizeModifier;
import org.carpetorgaddition.util.MathUtils;
import org.jetbrains.annotations.NotNull;

public class BeaconBoxRenderer
extends BoxRenderer
implements WorldRenderer {
    private SizeModifier sizeModifier;
    private final class_2338 blockPos;

    public BeaconBoxRenderer(class_2338 blockPos, @NotNull class_238 box) {
        super(box);
        this.blockPos = blockPos;
    }

    @Override
    public void render(WorldRenderContext context) {
        this.resize();
        super.render(Objects.requireNonNull(context.matrixStack()));
    }

    private void resize() {
        if (this.sizeModifier == null) {
            return;
        }
        long timeDifference = System.currentTimeMillis() - this.sizeModifier.timeMillis;
        if ((double)timeDifference > 1500.0) {
            this.setBox(this.sizeModifier.targetBox);
            return;
        }
        double x = (double)timeDifference / 1500.0;
        double factor = x < 0.5 ? 2.0 * Math.pow(x, 2.0) : 1.0 - Math.pow(-2.0 * x + 2.0, 2.0) / 2.0;
        class_238 box = new class_238(MathUtils.approach(this.sizeModifier.originalBox.field_1323, this.sizeModifier.targetBox.field_1323, factor), MathUtils.approach(this.sizeModifier.originalBox.field_1322, this.sizeModifier.targetBox.field_1322, factor), MathUtils.approach(this.sizeModifier.originalBox.field_1321, this.sizeModifier.targetBox.field_1321, factor), MathUtils.approach(this.sizeModifier.originalBox.field_1320, this.sizeModifier.targetBox.field_1320, factor), MathUtils.approach(this.sizeModifier.originalBox.field_1325, this.sizeModifier.targetBox.field_1325, factor), MathUtils.approach(this.sizeModifier.originalBox.field_1324, this.sizeModifier.targetBox.field_1324, factor));
        this.setBox(box);
    }

    public void setSizeModifier(class_238 targetBox) {
        if (this.sizeModifier != null && targetBox.equals((Object)this.sizeModifier.targetBox)) {
            return;
        }
        this.sizeModifier = new SizeModifier(targetBox, this.getBox());
    }

    @Override
    public boolean shouldStop() {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return true;
        }
        class_2680 blockState = world.method_8320(this.blockPos);
        return blockState == null || !blockState.method_27852(class_2246.field_10327);
    }

    public class_2338 getBlockPos() {
        return this.blockPos;
    }

    public boolean equals(Object o) {
        return o != null && this.getClass() == o.getClass() && this.blockPos.equals((Object)((BeaconBoxRenderer)o).blockPos);
    }

    public int hashCode() {
        return this.blockPos.hashCode();
    }
}

