/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.client.renderer.waypoint;

import java.util.function.Consumer;
import net.minecraft.class_2960;
import org.carpetorgaddition.client.renderer.WorldRendererManager;
import org.carpetorgaddition.client.renderer.waypoint.WaypointRenderer;
import org.carpetorgaddition.client.util.ClientCommandUtils;

public enum WaypointRendererType {
    HIGHLIGHT(class_2960.method_60656((String)"textures/map/decorations/red_x.png"), 60000L),
    NAVIGATOR(class_2960.method_60656((String)"textures/map/decorations/target_x.png"), -1L);

    private final class_2960 icon;
    private final long defaultDurationTime;
    private static final long VANISHING_TIME = 800L;

    private WaypointRendererType(class_2960 identifier, long defaultDurationTime) {
        this.icon = identifier;
        this.defaultDurationTime = defaultDurationTime;
    }

    public class_2960 getIcon() {
        return this.icon;
    }

    public float getScale(double distance, long startTime, long durationTime, boolean fade, long fadeTime) {
        float scale = (float)distance / 30.0f;
        scale = Math.max(scale * (1.0f - (float)distance / 40.0f * 0.1f), scale * 0.75f);
        if (fade) {
            long currentTimeMillis = System.currentTimeMillis();
            long remainingTime = fadeTime + 800L - currentTimeMillis;
            return this.fade(remainingTime, scale);
        }
        if (durationTime > 0L) {
            long duration;
            long currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis < (duration = startTime + durationTime)) {
                return scale;
            }
            long remainingTime = duration + 800L - currentTimeMillis;
            return this.fade(remainingTime, scale);
        }
        return scale;
    }

    private float fade(long remainingTime, float scale) {
        if (remainingTime < 0L) {
            return 0.0f;
        }
        float x = (float)remainingTime / 800.0f;
        float cubic = x * x * x;
        return scale * cubic;
    }

    public void clear() {
        Consumer<WaypointRendererType> consumer = type -> WorldRendererManager.remove(WaypointRenderer.class, renderer -> renderer.getRenderType() == type);
        switch (this.ordinal()) {
            case 0: {
                consumer.accept(HIGHLIGHT);
                break;
            }
            case 1: {
                ClientCommandUtils.sendCommand("navigate stop");
                consumer.accept(NAVIGATOR);
            }
        }
    }

    public long getDefaultDurationTime() {
        return this.defaultDurationTime;
    }

    public String getLogName() {
        String name = switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "\u9ad8\u4eae";
            case 1 -> "\u5bfc\u822a";
        };
        return "\u8def\u5f84\u70b9\uff08" + name + "\uff09";
    }
}

