/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.command;

import carpet.utils.CommandHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2247;
import net.minecraft.class_2257;
import net.minecraft.class_2262;
import net.minecraft.class_2293;
import net.minecraft.class_2338;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3312;
import net.minecraft.class_3619;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import net.minecraft.class_7924;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.periodic.ServerPeriodicTaskManager;
import org.carpetorgaddition.periodic.task.findtask.BlockFindTask;
import org.carpetorgaddition.periodic.task.findtask.ItemFindTask;
import org.carpetorgaddition.periodic.task.findtask.MayAffectWorldEaterBlockFindTask;
import org.carpetorgaddition.periodic.task.findtask.OfflinePlayerEnderChestFindTask;
import org.carpetorgaddition.periodic.task.findtask.OfflinePlayerFindTask;
import org.carpetorgaddition.periodic.task.findtask.TradeEnchantedBookFindTask;
import org.carpetorgaddition.periodic.task.findtask.TradeItemFindTask;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.TextUtils;
import org.carpetorgaddition.util.constant.TextConstants;
import org.carpetorgaddition.util.wheel.ItemStackPredicate;
import org.carpetorgaddition.util.wheel.SelectionArea;

public class FinderCommand {
    public static final int MAXIMUM_STATISTICAL_COUNT = 30000;
    public static final long MAX_FIND_TIME = 200L;
    public static final int MAX_TICK_COUNT = 50;
    public static final class_5250 VILLAGER = TextUtils.translate("entity.minecraft.villager", new Object[0]);
    public static final String TIME_OUT = "carpet.commands.finder.timeout";

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"finder").requires(source -> CommandHelper.canUseCommand((class_2168)source, (Object)CarpetOrgAdditionSettings.commandFinder))).then(class_2170.method_9247((String)"block").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"blockState", (ArgumentType)class_2257.method_9653((class_7157)commandRegistryAccess)).executes(context -> FinderCommand.blockFinder((CommandContext<class_2168>)context, 64))).then(class_2170.method_9244((String)"range", (ArgumentType)IntegerArgumentType.integer((int)0, (int)256)).suggests(FinderCommand.suggestionDefaultDistance()).executes(context -> FinderCommand.blockFinder((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"range"))))).then(class_2170.method_9247((String)"from").then(class_2170.method_9244((String)"from", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9247((String)"to").then(class_2170.method_9244((String)"to", (ArgumentType)class_2262.method_9698()).executes(FinderCommand::areaBlockFinder)))))))).then(class_2170.method_9247((String)"item").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"itemStack", (ArgumentType)class_2293.method_9801((class_7157)commandRegistryAccess)).executes(context -> FinderCommand.findItem((CommandContext<class_2168>)context, 64))).then(class_2170.method_9244((String)"range", (ArgumentType)IntegerArgumentType.integer((int)0, (int)256)).suggests(FinderCommand.suggestionDefaultDistance()).executes(context -> FinderCommand.findItem((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"range"))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"from").then(class_2170.method_9244((String)"from", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9247((String)"to").then(class_2170.method_9244((String)"to", (ArgumentType)class_2262.method_9698()).executes(FinderCommand::areaItemFinder))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"offline_player").executes(FinderCommand::findItemFromOfflinePlayer)).then(class_2170.method_9247((String)"inventory").executes(FinderCommand::findItemFromOfflinePlayer))).then(class_2170.method_9247((String)"ender_chest").executes(FinderCommand::findItemFromOfflinePlayerEnderChest))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"trade").then(class_2170.method_9247((String)"item").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"itemStack", (ArgumentType)class_2293.method_9801((class_7157)commandRegistryAccess)).executes(context -> FinderCommand.findTradeItem((CommandContext<class_2168>)context, 64))).then(class_2170.method_9244((String)"range", (ArgumentType)IntegerArgumentType.integer((int)0, (int)256)).suggests(FinderCommand.suggestionDefaultDistance()).executes(context -> FinderCommand.findTradeItem((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"range"))))))).then(class_2170.method_9247((String)"enchanted_book").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"enchantment", (ArgumentType)class_7733.method_45603((class_7157)commandRegistryAccess, (class_5321)class_7924.field_41265)).executes(context -> FinderCommand.findEnchantedBookTrade((CommandContext<class_2168>)context, 64))).then(class_2170.method_9244((String)"range", (ArgumentType)IntegerArgumentType.integer((int)0, (int)256)).suggests(FinderCommand.suggestionDefaultDistance()).executes(context -> FinderCommand.findEnchantedBookTrade((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"range")))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"worldEater").requires(source -> CarpetOrgAddition.ENABLE_HIDDEN_FUNCTION)).then(class_2170.method_9244((String)"from", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"to", (ArgumentType)class_2262.method_9698()).executes(FinderCommand::mayAffectWorldEater)))));
    }

    private static SuggestionProvider<class_2168> suggestionDefaultDistance() {
        return (context, builder) -> class_2172.method_9253((String[])new String[]{"64", "128", "256"}, (SuggestionsBuilder)builder);
    }

    private static int findItem(CommandContext<class_2168> context, int range) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        ItemStackPredicate predicate = new ItemStackPredicate(context, "itemStack");
        class_2338 sourceBlockPos = player.method_24515();
        class_1937 world = player.method_37908();
        ItemFindTask task = new ItemFindTask(world, predicate, new SelectionArea(world, sourceBlockPos, range), context);
        ServerPeriodicTaskManager.getManager(context).getServerTaskManager().addTask(task);
        return 1;
    }

    private static int areaItemFinder(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        class_2338 from = class_2262.method_48299(context, (String)"from");
        class_2338 to = class_2262.method_48299(context, (String)"to");
        ItemStackPredicate predicate = new ItemStackPredicate(context, "itemStack");
        SelectionArea selectionArea = new SelectionArea(from, to);
        ItemFindTask task = new ItemFindTask(player.method_37908(), predicate, selectionArea, context);
        ServerPeriodicTaskManager.getManager(context).getServerTaskManager().addTask(task);
        return 1;
    }

    private static int findItemFromOfflinePlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        FinderCommand.findItemFromOfflinePlayer(context, false);
        return 1;
    }

    private static int findItemFromOfflinePlayerEnderChest(CommandContext<class_2168> context) throws CommandSyntaxException {
        FinderCommand.findItemFromOfflinePlayer(context, true);
        return 0;
    }

    private static void findItemFromOfflinePlayer(CommandContext<class_2168> context, boolean enderChest) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        File[] files = player.field_13995.method_27050(class_5218.field_24182).toFile().listFiles();
        if (files == null) {
            throw CommandUtils.createException("carpet.commands.finder.item.offline_player.unable_read_files", new Object[0]);
        }
        class_3312 userCache = player.field_13995.method_3793();
        if (userCache == null) {
            throw CommandUtils.createException("carpet.commands.finder.item.offline_player.unable_read_usercache", new Object[0]);
        }
        OfflinePlayerFindTask task = enderChest ? new OfflinePlayerEnderChestFindTask(context, userCache, player, files) : new OfflinePlayerFindTask(context, userCache, player, files);
        ServerPeriodicTaskManager.getManager(context).getServerTaskManager().addTask(task);
    }

    private static int blockFinder(CommandContext<class_2168> context, int range) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        class_2247 argument = class_2257.method_9655(context, (String)"blockState");
        class_2338 sourceBlockPos = player.method_24515();
        class_3218 world = player.method_51469();
        SelectionArea selectionArea = new SelectionArea((class_1937)world, sourceBlockPos, range);
        ArgumentBlockPredicate predicate = new ArgumentBlockPredicate(argument);
        BlockFindTask task = new BlockFindTask(world, sourceBlockPos, selectionArea, context, predicate);
        ServerPeriodicTaskManager.getManager(context).getServerTaskManager().addTask(task);
        return 1;
    }

    private static int mayAffectWorldEater(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        class_2338 from = class_2262.method_48299(context, (String)"from");
        class_2338 to = class_2262.method_48299(context, (String)"to");
        class_2338 sourceBlockPos = player.method_24515();
        class_3218 world = player.method_51469();
        SelectionArea selectionArea = new SelectionArea(from, to);
        BlockBlockPredicate predicate = new BlockBlockPredicate();
        MayAffectWorldEaterBlockFindTask task = new MayAffectWorldEaterBlockFindTask(world, sourceBlockPos, selectionArea, context, predicate);
        ServerPeriodicTaskManager.getManager(context).getServerTaskManager().addTask(task);
        return 0;
    }

    private static int areaBlockFinder(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        class_2338 from = class_2262.method_48299(context, (String)"from");
        class_2338 to = class_2262.method_48299(context, (String)"to");
        class_2247 argument = class_2257.method_9655(context, (String)"blockState");
        SelectionArea selectionArea = new SelectionArea(from, to);
        ArgumentBlockPredicate predicate = new ArgumentBlockPredicate(argument);
        BlockFindTask task = new BlockFindTask(player.method_51469(), player.method_24515(), selectionArea, context, predicate);
        ServerPeriodicTaskManager.getManager(context).getServerTaskManager().addTask(task);
        return 1;
    }

    private static int findTradeItem(CommandContext<class_2168> context, int range) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        ItemStackPredicate predicate = new ItemStackPredicate(context, "itemStack");
        class_2338 sourcePos = player.method_24515();
        class_1937 world = player.method_37908();
        SelectionArea area = new SelectionArea(world, sourcePos, range);
        TradeItemFindTask task = new TradeItemFindTask(world, area, sourcePos, predicate, context);
        ServerPeriodicTaskManager.getManager(context).getServerTaskManager().addTask(task);
        return 1;
    }

    private static int findEnchantedBookTrade(CommandContext<class_2168> context, int range) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        class_1887 enchantment = (class_1887)class_7733.method_45612(context, (String)"enchantment").comp_349();
        class_2338 sourcePos = player.method_24515();
        class_1937 world = player.method_37908();
        SelectionArea area = new SelectionArea(world, sourcePos, range);
        TradeEnchantedBookFindTask task = new TradeEnchantedBookFindTask(world, area, sourcePos, context, enchantment);
        ServerPeriodicTaskManager.getManager(context).getServerTaskManager().addTask(task);
        return 1;
    }

    public static class_5250 showCount(class_1799 itemStack, int count, boolean inTheShulkerBox) {
        class_5250 text = TextConstants.itemCount(count, itemStack.method_7914());
        return inTheShulkerBox ? TextUtils.toItalic(text) : text;
    }

    private record ArgumentBlockPredicate(class_2247 argument) implements BlockPredicate
    {
        @Override
        public boolean test(class_3218 world, class_2338 pos) {
            return this.argument.method_35758(world, pos);
        }

        @Override
        public class_5250 getName() {
            return this.argument.method_9494().method_26204().method_9518();
        }
    }

    public static interface BlockPredicate {
        public boolean test(class_3218 var1, class_2338 var2);

        public class_5250 getName();
    }

    private record BlockBlockPredicate() implements BlockPredicate
    {
        @Override
        public boolean test(class_3218 world, class_2338 pos) {
            boolean hasWater;
            class_2680 blockState = world.method_8320(pos);
            if (blockState.method_27852(class_2246.field_9987) || blockState.method_26215() || blockState.method_26204() instanceof class_2404) {
                return false;
            }
            if (blockState.method_26223() == class_3619.field_15971) {
                return false;
            }
            if (blockState.method_26204().method_9520() > 17.0f) {
                return true;
            }
            boolean blockPiston = blockState.method_26204() instanceof class_2237 || blockState.method_26223() == class_3619.field_15972;
            boolean bl = hasWater = !blockState.method_26227().method_15769();
            if (blockPiston && hasWater) {
                return true;
            }
            return hasWater && this.canPush(world, pos);
        }

        private boolean canPush(class_3218 world, class_2338 pos) {
            for (int i = 1; i <= 8; ++i) {
                class_2680 blockState = world.method_8320(pos.method_10087(i));
                class_3619 pistonBehavior = blockState.method_26223();
                if (pistonBehavior == class_3619.field_15972) {
                    return true;
                }
                if (pistonBehavior != class_3619.field_15971) continue;
                return false;
            }
            return true;
        }

        @Override
        public class_5250 getName() {
            return TextUtils.translate("carpet.commands.finder.may_affect_world_eater_block.name", new Object[0]);
        }
    }
}

