/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.command;

import carpet.utils.CommandHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.GameUtils;
import org.carpetorgaddition.util.IOUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.util.TextUtils;
import org.carpetorgaddition.util.WorldUtils;
import org.carpetorgaddition.util.wheel.Waypoint;
import org.carpetorgaddition.util.wheel.WorldFormat;
import org.jetbrains.annotations.Nullable;

public class LocationsCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"locations").requires(source -> CommandHelper.canUseCommand((class_2168)source, (Object)CarpetOrgAdditionSettings.commandLocations))).then(class_2170.method_9247((String)"add").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> LocationsCommand.addWayPoint((CommandContext<class_2168>)context, null))).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(context -> LocationsCommand.addWayPoint((CommandContext<class_2168>)context, class_2262.method_48299((CommandContext)context, (String)"pos"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(context -> LocationsCommand.listWayPoint((CommandContext<class_2168>)context, null))).then(class_2170.method_9244((String)"filter", (ArgumentType)StringArgumentType.string()).executes(context -> LocationsCommand.listWayPoint((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"filter")))))).then(class_2170.method_9247((String)"supplement").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(LocationsCommand.suggestion()).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"illustrate").executes(context -> LocationsCommand.addIllustrateText((CommandContext<class_2168>)context, null))).then(class_2170.method_9244((String)"illustrate", (ArgumentType)StringArgumentType.string()).executes(context -> LocationsCommand.addIllustrateText((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"illustrate")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"another_pos").executes(context -> LocationsCommand.addAnotherPos((CommandContext<class_2168>)context, null))).then(class_2170.method_9244((String)"anotherPos", (ArgumentType)class_2262.method_9698()).executes(context -> LocationsCommand.addAnotherPos((CommandContext<class_2168>)context, class_2262.method_48299((CommandContext)context, (String)"anotherPos")))))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(LocationsCommand.suggestion()).executes(LocationsCommand::deleteWayPoint)))).then(class_2170.method_9247((String)"set").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(LocationsCommand.suggestion()).executes(context -> LocationsCommand.setWayPoint((CommandContext<class_2168>)context, null))).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(context -> LocationsCommand.setWayPoint((CommandContext<class_2168>)context, class_2262.method_48299((CommandContext)context, (String)"pos")))))));
    }

    public static SuggestionProvider<class_2168> suggestion() {
        return (context, builder) -> {
            WorldFormat worldFormat = new WorldFormat(((class_2168)context.getSource()).method_9211(), "waypoint", new String[0]);
            return class_2172.method_9264(worldFormat.toImmutableFileList().stream().map(File::getName).filter(name -> name.endsWith(".json")).map(IOUtils::removeExtension).map(StringArgumentType::escapeIfRequired), (SuggestionsBuilder)builder);
        };
    }

    private static int addWayPoint(CommandContext<class_2168> context, @Nullable class_2338 blockPos) throws CommandSyntaxException {
        MinecraftServer server;
        WorldFormat worldFormat;
        class_3222 player = CommandUtils.getSourcePlayer(context);
        String name = StringArgumentType.getString(context, (String)"name");
        if (blockPos == null) {
            blockPos = player.method_24515();
        }
        if ((worldFormat = new WorldFormat(server = ((class_2168)context.getSource()).method_9211(), "waypoint", new String[0])).fileExists(name)) {
            throw CommandUtils.createException("carpet.commands.locations.add.fail.already_exists", name);
        }
        Waypoint waypoint = new Waypoint(blockPos, name, WorldUtils.getDimensionId((class_1937)((class_2168)context.getSource()).method_9225()), player.method_5477().getString());
        try {
            waypoint.save(server);
            MessageUtils.sendMessage((class_2168)context.getSource(), "carpet.commands.locations.add.success", name, WorldUtils.toPosString(blockPos));
        }
        catch (IOException e) {
            CarpetOrgAddition.LOGGER.error("{}\u5728\u5c1d\u8bd5\u5c06\u8def\u5f84\u70b9\u5199\u5165\u672c\u5730\u6587\u4ef6\u65f6\u51fa\u73b0\u610f\u5916\u95ee\u9898:", (Object)GameUtils.getPlayerName((class_1657)player), (Object)e);
        }
        return 1;
    }

    private static int listWayPoint(CommandContext<class_2168> context, @Nullable String filter) {
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        WorldFormat worldFormat = new WorldFormat(server, "waypoint", new String[0]);
        List<File> list = worldFormat.toImmutableFileList();
        if (list.isEmpty()) {
            MessageUtils.sendMessage(context, "carpet.commands.locations.list.no_waypoint", new Object[0]);
            return 0;
        }
        class_5250 dividerLine = TextUtils.createText("------------------------------");
        MessageUtils.sendMessage((class_2168)context.getSource(), (class_2561)dividerLine);
        int count = 0;
        for (File file : list) {
            Optional<Waypoint> optional;
            String name = file.getName();
            if (filter != null && !name.contains(filter)) continue;
            try {
                optional = Waypoint.load(server, name);
            }
            catch (IOException | NullPointerException e) {
                CarpetOrgAddition.LOGGER.warn("\u65e0\u6cd5\u89e3\u6790\u8def\u5f84\u70b9[{}]", (Object)IOUtils.removeExtension(name), (Object)e);
                continue;
            }
            if (!optional.isPresent()) continue;
            optional.get().show((class_2168)context.getSource());
            ++count;
        }
        MessageUtils.sendMessage((class_2168)context.getSource(), (class_2561)dividerLine);
        return count;
    }

    private static int addIllustrateText(CommandContext<class_2168> context, @Nullable String illustrate) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        String name = StringArgumentType.getString(context, (String)"name");
        try {
            Optional<Waypoint> optional = Waypoint.load(server, name);
            if (optional.isPresent()) {
                boolean remove = false;
                if (illustrate == null || illustrate.isEmpty()) {
                    illustrate = null;
                    remove = true;
                }
                Waypoint waypoint = optional.get();
                waypoint.setIllustrate(illustrate);
                waypoint.save(server);
                if (remove) {
                    MessageUtils.sendMessage(source, "carpet.commands.locations.illustrate.remove", name);
                } else {
                    MessageUtils.sendMessage(source, "carpet.commands.locations.illustrate.add", illustrate, name);
                }
            }
        }
        catch (IOException | NullPointerException e) {
            CarpetOrgAddition.LOGGER.error("\u65e0\u6cd5\u4e3a\u8def\u5f84\u70b9[{}]\u6dfb\u52a0\u8bf4\u660e\u6587\u672c", (Object)name, (Object)e);
            throw CommandUtils.createException("carpet.commands.locations.illustrate.io", name);
        }
        return 1;
    }

    private static int addAnotherPos(CommandContext<class_2168> context, @Nullable class_2338 blockPos) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        class_2168 source = (class_2168)context.getSource();
        if (blockPos == null) {
            blockPos = player.method_24515();
        }
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        String name = StringArgumentType.getString(context, (String)"name");
        try {
            Optional<Waypoint> optional = Waypoint.load(server, name);
            if (optional.isPresent()) {
                Waypoint waypoint = optional.get();
                if (!waypoint.canAddAnother()) {
                    throw CommandUtils.createException("carpet.commands.locations.another.add.fail", new Object[0]);
                }
                waypoint.setAnotherBlockPos(blockPos);
                waypoint.save(server);
                MessageUtils.sendMessage(source, "carpet.commands.locations.another.add", new Object[0]);
            }
        }
        catch (IOException | NullPointerException e) {
            CarpetOrgAddition.LOGGER.error("\u65e0\u6cd5\u89e3\u6790\u8def\u5f84\u70b9[{}]:", (Object)name, (Object)e);
            throw CommandUtils.createException("carpet.commands.locations.another.io", name);
        }
        return 1;
    }

    private static int deleteWayPoint(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        String name = StringArgumentType.getString(context, (String)"name");
        WorldFormat worldFormat = new WorldFormat(((class_2168)context.getSource()).method_9211(), "waypoint", new String[0]);
        File file = worldFormat.file(name);
        if (!file.delete()) {
            throw CommandUtils.createException("carpet.commands.locations.remove.fail", name);
        }
        MessageUtils.sendMessage(source, "carpet.commands.locations.remove.success", name);
        return 1;
    }

    private static int setWayPoint(CommandContext<class_2168> context, @Nullable class_2338 blockPos) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        class_2168 source = (class_2168)context.getSource();
        if (blockPos == null) {
            blockPos = player.method_24515();
        }
        String fileName = StringArgumentType.getString(context, (String)"name");
        try {
            Optional<Waypoint> optional = Waypoint.load(((class_2168)context.getSource()).method_9211(), fileName);
            if (optional.isPresent()) {
                Waypoint waypoint = optional.get();
                waypoint.setBlockPos(blockPos);
                waypoint.save(((class_2168)context.getSource()).method_9211());
                MessageUtils.sendMessage(source, "carpet.commands.locations.set", fileName);
            }
        }
        catch (IOException | NullPointerException e) {
            throw CommandUtils.createException("carpet.commands.locations.set.io", fileName);
        }
        return 1;
    }
}

