/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.command;

import carpet.patches.EntityPlayerMPFake;
import carpet.utils.CommandHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.exception.CommandExecuteIOException;
import org.carpetorgaddition.periodic.ServerPeriodicTaskManager;
import org.carpetorgaddition.periodic.fakeplayer.FakePlayerSafeAfkInterface;
import org.carpetorgaddition.periodic.fakeplayer.FakePlayerSerial;
import org.carpetorgaddition.periodic.task.ServerTaskManager;
import org.carpetorgaddition.periodic.task.playerscheduletask.DelayedLoginTask;
import org.carpetorgaddition.periodic.task.playerscheduletask.DelayedLogoutTask;
import org.carpetorgaddition.periodic.task.playerscheduletask.PlayerScheduleTask;
import org.carpetorgaddition.periodic.task.playerscheduletask.ReLoginTask;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.IOUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.util.TextUtils;
import org.carpetorgaddition.util.constant.TextConstants;
import org.carpetorgaddition.util.wheel.WorldFormat;
import org.jetbrains.annotations.NotNull;

public class PlayerManagerCommand {
    private static final String SAFEAFK_PROPERTIES = "safeafk.properties";

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        RequiredArgumentBuilder loginNode = class_2170.method_9244((String)"delayed", (ArgumentType)IntegerArgumentType.integer((int)1));
        for (TimeUnit unit : TimeUnit.values()) {
            loginNode.then(class_2170.method_9247((String)unit.getName()).executes(context -> PlayerManagerCommand.addDelayedLoginTask((CommandContext<class_2168>)context, unit)));
        }
        RequiredArgumentBuilder logoutNode = class_2170.method_9244((String)"delayed", (ArgumentType)IntegerArgumentType.integer((int)1));
        for (TimeUnit unit : TimeUnit.values()) {
            logoutNode.then(class_2170.method_9247((String)unit.getName()).executes(context -> PlayerManagerCommand.addDelayedLogoutTask((CommandContext<class_2168>)context, unit)));
        }
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"playerManager").requires(source -> CommandHelper.canUseCommand((class_2168)source, (Object)CarpetOrgAdditionSettings.commandPlayerManager))).then(class_2170.method_9247((String)"save").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> PlayerManagerCommand.savePlayer((CommandContext<class_2168>)context, false))).then(class_2170.method_9244((String)"annotation", (ArgumentType)StringArgumentType.string()).executes(context -> PlayerManagerCommand.withAnnotationSavePlayer((CommandContext<class_2168>)context, false)))))).then(class_2170.method_9247((String)"spawn").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(PlayerManagerCommand.defaultSuggests()).executes(PlayerManagerCommand::spawnPlayer)))).then(class_2170.method_9247((String)"annotation").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(PlayerManagerCommand.defaultSuggests()).executes(context -> PlayerManagerCommand.setAnnotation((CommandContext<class_2168>)context, true))).then(class_2170.method_9244((String)"annotation", (ArgumentType)StringArgumentType.string()).executes(context -> PlayerManagerCommand.setAnnotation((CommandContext<class_2168>)context, false)))))).then(class_2170.method_9247((String)"autologin").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(PlayerManagerCommand.defaultSuggests()).then(class_2170.method_9244((String)"autologin", (ArgumentType)BoolArgumentType.bool()).executes(PlayerManagerCommand::setAutoLogin))))).then(class_2170.method_9247((String)"resave").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> PlayerManagerCommand.savePlayer((CommandContext<class_2168>)context, true))).then(class_2170.method_9244((String)"annotation", (ArgumentType)StringArgumentType.string()).executes(context -> PlayerManagerCommand.withAnnotationSavePlayer((CommandContext<class_2168>)context, true)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(context -> PlayerManagerCommand.list((CommandContext<class_2168>)context, s -> true))).then(class_2170.method_9244((String)"filter", (ArgumentType)StringArgumentType.string()).executes(context -> PlayerManagerCommand.list((CommandContext<class_2168>)context, s -> s.contains(StringArgumentType.getString((CommandContext)context, (String)"filter").toLowerCase(Locale.ROOT))))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(PlayerManagerCommand.defaultSuggests()).executes(PlayerManagerCommand::delete)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"schedule").then(class_2170.method_9247((String)"relogin").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(PlayerManagerCommand.reLoginTaskSuggests()).then(class_2170.method_9244((String)"interval", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests((context, builder) -> class_2172.method_9253((String[])new String[]{"1", "3", "5"}, (SuggestionsBuilder)builder)).executes(PlayerManagerCommand::setReLogin))).then(class_2170.method_9247((String)"stop").executes(PlayerManagerCommand::stopReLogin))))).then(class_2170.method_9247((String)"login").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(PlayerManagerCommand.defaultSuggests()).then((ArgumentBuilder)loginNode)))).then(class_2170.method_9247((String)"logout").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then((ArgumentBuilder)logoutNode)))).then(class_2170.method_9247((String)"cancel").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(PlayerManagerCommand.cancelSuggests()).executes(PlayerManagerCommand::cancelScheduleTask)))).then(class_2170.method_9247((String)"list").executes(PlayerManagerCommand::listScheduleTask)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"safeafk").then(class_2170.method_9247((String)"set").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> PlayerManagerCommand.safeAfk((CommandContext<class_2168>)context, 5.0f, false))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"threshold", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> PlayerManagerCommand.safeAfk((CommandContext<class_2168>)context, FloatArgumentType.getFloat((CommandContext)context, (String)"threshold"), false))).then(class_2170.method_9244((String)"save", (ArgumentType)BoolArgumentType.bool()).executes(context -> PlayerManagerCommand.safeAfk((CommandContext<class_2168>)context, FloatArgumentType.getFloat((CommandContext)context, (String)"threshold"), BoolArgumentType.getBool((CommandContext)context, (String)"save")))))))).then(class_2170.method_9247((String)"list").executes(PlayerManagerCommand::listSafeAfk))).then(class_2170.method_9247((String)"cancel").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> PlayerManagerCommand.cancelSafeAfk((CommandContext<class_2168>)context, false))).then(class_2170.method_9244((String)"save", (ArgumentType)BoolArgumentType.bool()).executes(context -> PlayerManagerCommand.cancelSafeAfk((CommandContext<class_2168>)context, true)))))).then(class_2170.method_9247((String)"query").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(PlayerManagerCommand::querySafeAfk)))));
    }

    @NotNull
    private static SuggestionProvider<class_2168> cancelSuggests() {
        return (context, builder) -> {
            ServerTaskManager manager = ServerPeriodicTaskManager.getManager((CommandContext<class_2168>)context).getServerTaskManager();
            Stream<String> stream = manager.stream(PlayerScheduleTask.class).map(PlayerScheduleTask::getPlayerName);
            return class_2172.method_9264(stream, (SuggestionsBuilder)builder);
        };
    }

    private static SuggestionProvider<class_2168> defaultSuggests() {
        return (context, builder) -> class_2172.method_9264(new WorldFormat(((class_2168)context.getSource()).method_9211(), "player_data", new String[0]).toImmutableFileList().stream().filter(file -> file.getName().endsWith(".json")).map(file -> IOUtils.removeExtension(file.getName())).map(StringArgumentType::escapeIfRequired), (SuggestionsBuilder)builder);
    }

    @NotNull
    public static SuggestionProvider<class_2168> reLoginTaskSuggests() {
        return (context, builder) -> {
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            ServerTaskManager manager = ServerPeriodicTaskManager.getManager(server).getServerTaskManager();
            List<String> taskList = manager.stream(ReLoginTask.class).map(ReLoginTask::getPlayerName).toList();
            List<String> onlineList = server.method_3760().method_14571().stream().map(player -> player.method_5477().getString()).toList();
            HashSet<String> players = new HashSet<String>();
            players.addAll(taskList);
            players.addAll(onlineList);
            return class_2172.method_9264(players.stream(), (SuggestionsBuilder)builder);
        };
    }

    private static int safeAfk(CommandContext<class_2168> context, float threshold, boolean save) throws CommandSyntaxException {
        EntityPlayerMPFake fakePlayer = CommandUtils.getArgumentFakePlayer(context);
        if (threshold >= fakePlayer.method_6063()) {
            throw CommandUtils.createException("carpet.commands.playerManager.safeafk.threshold_too_high", new Object[0]);
        }
        if (threshold <= 0.0f) {
            threshold = -1.0f;
        }
        FakePlayerSafeAfkInterface safeAfk = (FakePlayerSafeAfkInterface)fakePlayer;
        safeAfk.setHealthThreshold(threshold);
        if (save) {
            try {
                PlayerManagerCommand.saveSafeAfkThreshold(context, threshold, fakePlayer);
            }
            catch (IOException e) {
                throw CommandExecuteIOException.of(e);
            }
        } else {
            String command = "/playerManager safeafk set " + fakePlayer.method_5477().getString() + " " + threshold + " true";
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.safeafk.successfully_set_up", fakePlayer.method_5476(), Float.valueOf(threshold), TextConstants.clickRun(command));
        }
        return (int)threshold;
    }

    private static int listSafeAfk(CommandContext<class_2168> context) {
        List<class_3222> list = ((class_2168)context.getSource()).method_9211().method_3760().method_14571().stream().filter(player -> player instanceof EntityPlayerMPFake).toList();
        int count = 0;
        for (class_3222 player2 : list) {
            float threshold = ((FakePlayerSafeAfkInterface)player2).getHealthThreshold();
            if (threshold < 0.0f) continue;
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.safeafk.list.each", player2.method_5476(), Float.valueOf(threshold));
            ++count;
        }
        if (count == 0) {
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.safeafk.list.empty", new Object[0]);
        }
        return count;
    }

    private static int cancelSafeAfk(CommandContext<class_2168> context, boolean remove) throws CommandSyntaxException {
        EntityPlayerMPFake fakePlayer = CommandUtils.getArgumentFakePlayer(context);
        FakePlayerSafeAfkInterface safeAfk = (FakePlayerSafeAfkInterface)fakePlayer;
        safeAfk.setHealthThreshold(-1.0f);
        if (remove) {
            try {
                PlayerManagerCommand.saveSafeAfkThreshold(context, -1.0f, fakePlayer);
            }
            catch (IOException e) {
                throw CommandExecuteIOException.of(e);
            }
        } else {
            String key = "carpet.commands.playerManager.safeafk.successfully_set_up.cancel";
            class_5250 command = TextConstants.clickRun("/playerManager safeafk set " + fakePlayer.method_5477().getString() + " -1 true");
            MessageUtils.sendMessage(context, key, fakePlayer.method_5476(), command);
        }
        return 1;
    }

    private static int querySafeAfk(CommandContext<class_2168> context) throws CommandSyntaxException {
        EntityPlayerMPFake fakePlayer = CommandUtils.getArgumentFakePlayer(context);
        float threshold = ((FakePlayerSafeAfkInterface)fakePlayer).getHealthThreshold();
        String key = "carpet.commands.playerManager.safeafk.list.each";
        MessageUtils.sendMessage(context, key, fakePlayer.method_5476(), Float.valueOf(threshold));
        return (int)threshold;
    }

    private static void saveSafeAfkThreshold(CommandContext<class_2168> context, float threshold, EntityPlayerMPFake fakePlayer) throws IOException {
        String playerName = fakePlayer.method_5477().getString();
        WorldFormat worldFormat = new WorldFormat(((class_2168)context.getSource()).method_9211(), null, new String[0]);
        File file = worldFormat.file(SAFEAFK_PROPERTIES);
        if (file.isFile() || file.createNewFile()) {
            BufferedWriter writer;
            BufferedReader reader;
            Properties properties = new Properties();
            try (BufferedReader bufferedReader = reader = IOUtils.toReader(file);){
                properties.load(reader);
            }
            if (threshold > 0.0f) {
                properties.setProperty(playerName, String.valueOf(threshold));
                MessageUtils.sendMessage(context, "carpet.commands.playerManager.safeafk.successfully_set_up.save", fakePlayer.method_5476(), Float.valueOf(threshold));
            } else {
                properties.remove(playerName);
                MessageUtils.sendMessage(context, "carpet.commands.playerManager.safeafk.successfully_set_up.remove", fakePlayer.method_5476());
            }
            try (BufferedWriter bufferedWriter = writer = IOUtils.toWriter(file);){
                properties.store(writer, null);
            }
        }
    }

    public static void loadSafeAfk(class_3222 player) {
        WorldFormat worldFormat;
        File file;
        if (player instanceof EntityPlayerMPFake && (file = (worldFormat = new WorldFormat(player.field_13995, null, new String[0])).file(SAFEAFK_PROPERTIES)).isFile()) {
            Properties properties = new Properties();
            try {
                BufferedReader reader;
                try (BufferedReader bufferedReader = reader = IOUtils.toReader(file);){
                    properties.load(reader);
                }
            }
            catch (IOException e) {
                CarpetOrgAddition.LOGGER.error("\u5047\u73a9\u5bb6\u5b89\u5168\u6302\u673a\u9608\u503c\u52a0\u8f7d\u65f6\u51fa\u9519", (Throwable)e);
                return;
            }
            try {
                FakePlayerSafeAfkInterface safeAfk = (FakePlayerSafeAfkInterface)player;
                String value = properties.getProperty(player.method_5477().getString());
                if (value == null) {
                    return;
                }
                float threshold = Float.parseFloat(value);
                safeAfk.setHealthThreshold(threshold);
                String key = "carpet.commands.playerManager.safeafk.successfully_set_up.auto";
                class_5250 message = TextUtils.translate(key, player.method_5476(), Float.valueOf(threshold));
                MessageUtils.broadcastMessage(player.field_13995, (class_2561)TextUtils.toGrayItalic(message));
            }
            catch (NumberFormatException e) {
                CarpetOrgAddition.LOGGER.error("{}\u5b89\u5168\u6302\u673a\u9608\u503c\u8bbe\u7f6e\u5931\u8d25", (Object)player.method_5477().getString(), (Object)e);
            }
        }
    }

    private static int list(CommandContext<class_2168> context, Predicate<String> filter) {
        WorldFormat worldFormat = new WorldFormat(((class_2168)context.getSource()).method_9211(), "player_data", new String[0]);
        int count = FakePlayerSerial.list(context, worldFormat, filter);
        if (count == 0) {
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.list.no_player", new Object[0]);
            return 0;
        }
        return count;
    }

    private static int savePlayer(CommandContext<class_2168> context, boolean resave) throws CommandSyntaxException {
        EntityPlayerMPFake fakePlayer = CommandUtils.getArgumentFakePlayer(context);
        FakePlayerSerial fakePlayerSerial = new FakePlayerSerial(fakePlayer);
        PlayerManagerCommand.savePlayer(context, fakePlayerSerial, fakePlayer, resave);
        return 1;
    }

    private static int withAnnotationSavePlayer(CommandContext<class_2168> context, boolean resave) throws CommandSyntaxException {
        EntityPlayerMPFake fakePlayer = CommandUtils.getArgumentFakePlayer(context);
        String annotation = StringArgumentType.getString(context, (String)"annotation");
        FakePlayerSerial fakePlayerSerial = new FakePlayerSerial(fakePlayer, annotation);
        return PlayerManagerCommand.savePlayer(context, fakePlayerSerial, fakePlayer, resave);
    }

    private static int setAnnotation(CommandContext<class_2168> context, boolean remove) throws CommandSyntaxException {
        FakePlayerSerial serial;
        String name = StringArgumentType.getString(context, (String)"name");
        WorldFormat worldFormat = new WorldFormat(((class_2168)context.getSource()).method_9211(), "player_data", new String[0]);
        String annotation = remove ? null : StringArgumentType.getString(context, (String)"annotation");
        try {
            serial = new FakePlayerSerial(worldFormat, name);
            serial.setAnnotation(annotation);
            serial.save(context, true);
        }
        catch (FileNotFoundException e) {
            throw CommandUtils.createException("carpet.commands.playerManager.cannot_find_file", name);
        }
        catch (IOException e) {
            throw CommandExecuteIOException.of(e);
        }
        if (remove) {
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.annotation.remove", serial.getDisplayName());
        } else {
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.annotation.modify", serial.getDisplayName(), annotation);
        }
        return 1;
    }

    private static int setAutoLogin(CommandContext<class_2168> context) throws CommandSyntaxException {
        FakePlayerSerial serial;
        WorldFormat worldFormat = new WorldFormat(((class_2168)context.getSource()).method_9211(), "player_data", new String[0]);
        String name = StringArgumentType.getString(context, (String)"name");
        boolean autologin = BoolArgumentType.getBool(context, (String)"autologin");
        try {
            serial = new FakePlayerSerial(worldFormat, name);
            serial.setAutologin(autologin);
            serial.save(context, true);
        }
        catch (FileNotFoundException e) {
            throw CommandUtils.createException("carpet.commands.playerManager.cannot_find_file", name);
        }
        catch (IOException e) {
            throw CommandExecuteIOException.of(e);
        }
        if (autologin) {
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.autologin.setup", serial.getDisplayName());
        } else {
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.autologin.cancel", serial.getDisplayName());
        }
        return 1;
    }

    private static int savePlayer(CommandContext<class_2168> context, FakePlayerSerial fakePlayerSerial, EntityPlayerMPFake fakePlayer, boolean resave) throws CommandSyntaxException {
        try {
            int result = fakePlayerSerial.save(context, resave);
            if (result == 0) {
                MessageUtils.sendMessage((class_2168)context.getSource(), "carpet.commands.playerManager.save.success", fakePlayer.method_5476());
            } else if (result == 1) {
                MessageUtils.sendMessage((class_2168)context.getSource(), "carpet.commands.playerManager.save.resave", fakePlayer.method_5476());
            }
            return result < 0 ? 0 : 1;
        }
        catch (IOException e) {
            throw CommandUtils.createException("carpet.commands.playerManager.save.fail", fakePlayer.method_5476());
        }
    }

    private static int spawnPlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        String name = StringArgumentType.getString(context, (String)"name");
        WorldFormat worldFormat = new WorldFormat(((class_2168)context.getSource()).method_9211(), "player_data", new String[0]);
        try {
            FakePlayerSerial serial = new FakePlayerSerial(worldFormat, name);
            serial.spawn(((class_2168)context.getSource()).method_9211());
        }
        catch (FileNotFoundException e) {
            throw CommandUtils.createException("carpet.commands.playerManager.cannot_find_file", name);
        }
        catch (IOException | RuntimeException e) {
            throw CommandUtils.createException(e, "carpet.commands.playerManager.spawn.fail", new Object[0]);
        }
        return 1;
    }

    private static int delete(CommandContext<class_2168> context) throws CommandSyntaxException {
        String name;
        WorldFormat worldFormat = new WorldFormat(((class_2168)context.getSource()).method_9211(), "player_data", new String[0]);
        File file = worldFormat.getFile(name = StringArgumentType.getString(context, (String)"name"));
        if (!file.isFile() || !file.delete()) {
            throw CommandUtils.createException("carpet.commands.playerManager.delete.fail", new Object[0]);
        }
        MessageUtils.sendMessage((class_2168)context.getSource(), "carpet.commands.playerManager.delete.success", new Object[0]);
        return 1;
    }

    private static int setReLogin(CommandContext<class_2168> context) throws CommandSyntaxException {
        if (PlayerManagerCommand.fixMemoryLeak(context)) {
            String name = StringArgumentType.getString(context, (String)"name");
            int interval = IntegerArgumentType.getInteger(context, (String)"interval");
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            ServerTaskManager manager = ServerPeriodicTaskManager.getManager(context).getServerTaskManager();
            Optional<ReLoginTask> optional = manager.stream(ReLoginTask.class).filter(task -> Objects.equals(task.getPlayerName(), name)).findFirst();
            if (optional.isEmpty()) {
                class_3222 player = server.method_3760().method_14566(name);
                if (player == null) {
                    throw CommandUtils.createException("argument.entity.notfound.player", new Object[0]);
                }
                CommandUtils.checkFakePlayer((class_1657)player);
                manager.addTask(new ReLoginTask(name, interval, server, (class_5321<class_1937>)player.method_51469().method_27983(), context));
            } else {
                optional.get().setInterval(interval);
                MessageUtils.sendMessage(context, "carpet.commands.playerManager.schedule.relogin.set_interval", name, interval);
            }
            return interval;
        }
        return 0;
    }

    private static boolean fixMemoryLeak(CommandContext<class_2168> context) {
        if (CarpetOrgAdditionSettings.fakePlayerSpawnMemoryLeakFix) {
            return true;
        }
        class_5250 here = TextUtils.translate("carpet.command.text.click.here", new Object[0]);
        String command = "/carpet fakePlayerSpawnMemoryLeakFix true";
        class_5250 input = TextUtils.translate("carpet.command.text.click.input", command);
        here = TextUtils.suggest(here, command, (class_2561)input, class_124.field_1075);
        MessageUtils.sendMessage(context, "carpet.commands.playerManager.schedule.relogin.condition", here);
        return false;
    }

    private static int stopReLogin(CommandContext<class_2168> context) throws CommandSyntaxException {
        String name = StringArgumentType.getString(context, (String)"name");
        ServerTaskManager manager = ServerPeriodicTaskManager.getManager(context).getServerTaskManager();
        Optional<ReLoginTask> optional = manager.stream(ReLoginTask.class).filter(task -> Objects.equals(task.getPlayerName(), name)).findFirst();
        if (optional.isEmpty()) {
            throw CommandUtils.createException("carpet.commands.playerManager.schedule.cancel.fail", new Object[0]);
        }
        optional.ifPresent(task -> task.onCancel(context));
        return 1;
    }

    private static int addDelayedLoginTask(CommandContext<class_2168> context, TimeUnit unit) throws CommandSyntaxException {
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        ServerTaskManager manager = ServerPeriodicTaskManager.getManager(context).getServerTaskManager();
        String name = StringArgumentType.getString(context, (String)"name");
        Optional<DelayedLoginTask> optional = manager.stream(DelayedLoginTask.class).filter(task -> Objects.equals(name, task.getPlayerName())).findFirst();
        long tick = unit.getDelayed(context);
        class_5250 time = TextUtils.hoverText((class_2561)TextConstants.tickToTime(tick), (class_2561)TextConstants.tickToRealTime(tick));
        if (optional.isEmpty()) {
            FakePlayerSerial serial;
            WorldFormat worldFormat = new WorldFormat(server, "player_data", new String[0]);
            try {
                serial = new FakePlayerSerial(worldFormat, name);
            }
            catch (IOException e) {
                throw CommandUtils.createException("carpet.commands.playerManager.schedule.read_file", new Object[0]);
            }
            manager.addTask(new DelayedLoginTask(server, serial, tick));
            String key = server.method_3760().method_14566(name) == null ? "carpet.commands.playerManager.schedule.login" : "carpet.commands.playerManager.schedule.login.try";
            MessageUtils.sendMessage(context, key, serial.getDisplayName(), time);
        } else {
            DelayedLoginTask task2 = optional.get();
            class_5250 info = TextUtils.hoverText(name, task2.getInfo());
            task2.setDelayed(tick);
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.schedule.login.modify", info, time);
        }
        return (int)tick;
    }

    private static int addDelayedLogoutTask(CommandContext<class_2168> context, TimeUnit unit) throws CommandSyntaxException {
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        EntityPlayerMPFake fakePlayer = CommandUtils.getArgumentFakePlayer(context);
        long tick = unit.getDelayed(context);
        class_5250 time = TextUtils.hoverText((class_2561)TextConstants.tickToTime(tick), (class_2561)TextConstants.tickToRealTime(tick));
        ServerTaskManager manager = ServerPeriodicTaskManager.getManager(server).getServerTaskManager();
        Optional<DelayedLogoutTask> optional = manager.stream(DelayedLogoutTask.class).filter(task -> fakePlayer.equals((Object)task.getFakePlayer())).findFirst();
        if (optional.isEmpty()) {
            manager.addTask(new DelayedLogoutTask(server, fakePlayer, tick));
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.schedule.logout", fakePlayer.method_5476(), time);
        } else {
            optional.get().setDelayed(tick);
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.schedule.logout.modify", fakePlayer.method_5476(), time);
        }
        return (int)tick;
    }

    private static int cancelScheduleTask(CommandContext<class_2168> context) throws CommandSyntaxException {
        ServerTaskManager manager = ServerPeriodicTaskManager.getManager(context).getServerTaskManager();
        String name = StringArgumentType.getString(context, (String)"name");
        List<PlayerScheduleTask> list = manager.stream(PlayerScheduleTask.class).filter(task -> Objects.equals(task.getPlayerName(), name)).toList();
        if (list.isEmpty()) {
            throw CommandUtils.createException("carpet.commands.playerManager.schedule.cancel.fail", new Object[0]);
        }
        list.forEach(task -> task.onCancel(context));
        return list.size();
    }

    private static int listScheduleTask(CommandContext<class_2168> context) {
        ServerTaskManager manager = ServerPeriodicTaskManager.getManager(context).getServerTaskManager();
        List<PlayerScheduleTask> list = manager.stream(PlayerScheduleTask.class).toList();
        if (list.isEmpty()) {
            MessageUtils.sendMessage(context, "carpet.commands.playerManager.schedule.list.empty", new Object[0]);
        } else {
            list.forEach(task -> task.sendEachMessage((class_2168)context.getSource()));
        }
        return list.size();
    }

    private static enum TimeUnit {
        TICK,
        SECOND,
        MINUTE,
        HOUR;


        private String getName() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "t";
                case 1 -> "s";
                case 2 -> "min";
                case 3 -> "h";
            };
        }

        private long getDelayed(CommandContext<class_2168> context) {
            int delayed = IntegerArgumentType.getInteger(context, (String)"delayed");
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> delayed;
                case 1 -> (long)delayed * 20L;
                case 2 -> (long)delayed * 1200L;
                case 3 -> (long)delayed * 72000L;
            };
        }
    }
}

