/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.command;

import carpet.patches.EntityPlayerMPFake;
import carpet.utils.CommandHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3908;
import net.minecraft.class_7134;
import net.minecraft.class_747;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.MathUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.util.TextUtils;
import org.carpetorgaddition.util.constant.TextConstants;
import org.carpetorgaddition.util.screen.PlayerEnderChestScreenHandler;
import org.carpetorgaddition.util.screen.PlayerInventoryScreenHandler;

public class PlayerToolsCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"playerTools").requires(source -> CommandHelper.canUseCommand((class_2168)source, (Object)CarpetOrgAdditionSettings.commandPlayerTools))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9247((String)"enderChest").executes(context -> PlayerToolsCommand.openEnderChest((CommandContext<class_2168>)context, CommandUtils.getArgumentPlayer((CommandContext<class_2168>)context))))).then(class_2170.method_9247((String)"inventory").executes(PlayerToolsCommand::openFakePlayerInventory))).then(class_2170.method_9247((String)"teleport").executes(PlayerToolsCommand::fakePlayerTp))).then(class_2170.method_9247((String)"isFakePlayer").executes(PlayerToolsCommand::isFakePlayer))).then(class_2170.method_9247((String)"position").executes(PlayerToolsCommand::getFakePlayerPos))).then(class_2170.method_9247((String)"heal").executes(PlayerToolsCommand::fakePlayerHeal))));
    }

    private static int fakePlayerHeal(CommandContext<class_2168> context) throws CommandSyntaxException {
        EntityPlayerMPFake fakePlayer = CommandUtils.getArgumentFakePlayer(context);
        float health = fakePlayer.method_6063() - fakePlayer.method_6032();
        fakePlayer.method_6025(fakePlayer.method_6063());
        fakePlayer.method_7344().method_7580(20);
        MessageUtils.sendMessage((class_2168)context.getSource(), "carpet.commands.playerTools.heal", fakePlayer.method_5476());
        return (int)health;
    }

    private static int openEnderChest(CommandContext<class_2168> context, class_3222 fakePlayer) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        if (!(fakePlayer instanceof EntityPlayerMPFake) && fakePlayer != player) {
            throw CommandUtils.createException("carpet.commands.playerTools.self_or_fake_player", new Object[0]);
        }
        class_747 screen = new class_747((i, inventory, playerEntity1) -> new PlayerEnderChestScreenHandler(i, inventory, fakePlayer), fakePlayer.method_5477());
        player.method_17355((class_3908)screen);
        return 1;
    }

    private static int fakePlayerTp(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        EntityPlayerMPFake fakePlayer = CommandUtils.getArgumentFakePlayer(context);
        fakePlayer.method_37908().method_43128(null, fakePlayer.field_6014, fakePlayer.field_6036, fakePlayer.field_5969, class_3417.field_14915, fakePlayer.method_5634(), 1.0f, 1.0f);
        fakePlayer.method_14251(player.method_51469(), player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455());
        class_2561 fakePlayerName = fakePlayer.method_5476();
        class_2561 playerName = player.method_5476();
        MessageUtils.sendMessage((class_2168)context.getSource(), "carpet.commands.playerTools.tp.success", fakePlayerName, playerName);
        return 1;
    }

    private static int isFakePlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getArgumentPlayer(context);
        class_2561 playerName = player.method_5476();
        if (player instanceof EntityPlayerMPFake) {
            MessageUtils.sendMessage(context, "carpet.commands.playerTools.is_fake_player", playerName);
            return 0;
        }
        MessageUtils.sendMessage(context, "carpet.commands.playerTools.is_player", playerName);
        return 1;
    }

    private static int getFakePlayerPos(CommandContext<class_2168> context) throws CommandSyntaxException {
        EntityPlayerMPFake fakePlayer = CommandUtils.getArgumentFakePlayer(context);
        class_2168 source = (class_2168)context.getSource();
        MessageUtils.sendMessage(source, "carpet.commands.playerTools.pos", fakePlayer.method_5476(), PlayerToolsCommand.getDimensionText(fakePlayer.method_37908()).getString(), TextConstants.blockPos(new class_2338((class_2382)fakePlayer.method_24515()), class_124.field_1060));
        class_3222 player = source.method_44023();
        if (player != null) {
            return MathUtils.getBlockIntegerDistance(player.method_24515(), fakePlayer.method_24515());
        }
        return 0;
    }

    private static class_2561 getDimensionText(class_1937 world) {
        class_2960 value = world.method_8597().comp_655();
        if (value.equals((Object)class_7134.field_37670)) {
            return TextUtils.translate("carpet.commands.playerTools.pos.overworld", new Object[0]);
        }
        if (value.equals((Object)class_7134.field_37671)) {
            return TextUtils.translate("carpet.commands.playerTools.pos.the_nether", new Object[0]);
        }
        if (value.equals((Object)class_7134.field_37672)) {
            return TextUtils.translate("carpet.commands.playerTools.pos.the_end", new Object[0]);
        }
        return TextUtils.translate("carpet.commands.playerTools.pos.default", new Object[0]);
    }

    private static int openFakePlayerInventory(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        EntityPlayerMPFake fakePlayer = CommandUtils.getArgumentFakePlayer(context);
        class_747 screen = new class_747((arg_0, arg_1, arg_2) -> PlayerToolsCommand.lambda$openFakePlayerInventory$3((class_3222)fakePlayer, arg_0, arg_1, arg_2), fakePlayer.method_5477());
        player.method_17355((class_3908)screen);
        return 1;
    }

    private static /* synthetic */ class_1703 lambda$openFakePlayerInventory$3(class_3222 fakePlayer, int syncId, class_1661 playerInventory, class_1657 playerEntity) {
        return new PlayerInventoryScreenHandler(syncId, playerInventory, fakePlayer);
    }
}

