/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.command;

import carpet.CarpetServer;
import carpet.api.settings.CarpetRule;
import carpet.api.settings.RuleHelper;
import carpet.utils.CommandHelper;
import carpet.utils.Messenger;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_5250;
import org.apache.commons.lang3.mutable.MutableInt;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.mixin.rule.carpet.SettingsManagerAccessor;
import org.carpetorgaddition.util.TextUtils;

public class RuleSearchCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ruleSearch").requires(source -> CommandHelper.canUseCommand((class_2168)source, (Object)CarpetOrgAdditionSettings.commandRuleSearch))).then(class_2170.method_9244((String)"rule", (ArgumentType)StringArgumentType.greedyString()).executes(RuleSearchCommand::listRule)));
    }

    private static int listRule(CommandContext<class_2168> context) {
        String rule = StringArgumentType.getString(context, (String)"rule");
        if (rule.matches("\".*\"")) {
            rule = rule.substring(1, rule.length() - 1);
        }
        if (CarpetServer.settingsManager == null) {
            return 0;
        }
        class_5250 text = TextUtils.translate("carpet.commands.ruleSearch.feedback", rule);
        text.method_27694(style -> style.method_10982(Boolean.valueOf(true)));
        ((class_2168)context.getSource()).method_9226(() -> text, true);
        if (rule.isEmpty()) {
            return 0;
        }
        return RuleSearchCommand.listRule(context, rule);
    }

    private static int listRule(CommandContext<class_2168> context, String rule) {
        MutableInt ruleCount = new MutableInt(0);
        CarpetServer.forEachManager(settingsManager -> {
            SettingsManagerAccessor accessor = (SettingsManagerAccessor)settingsManager;
            Collection rules = settingsManager.getCarpetRules();
            for (CarpetRule carpetRule : rules) {
                if (!RuleHelper.translatedName((CarpetRule)carpetRule).contains(rule)) continue;
                Messenger.m((class_2168)((class_2168)context.getSource()), (Object[])new Object[]{accessor.displayInteractiveSettings(carpetRule)});
                ruleCount.add(1);
            }
        });
        return ruleCount.getValue();
    }
}

