/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.command;

import carpet.utils.CommandHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2177;
import net.minecraft.class_2287;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.MathUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.util.TextUtils;
import org.carpetorgaddition.util.WorldUtils;
import org.carpetorgaddition.util.constant.TextConstants;

public class SendMessageCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sendMessage").requires(source -> CommandHelper.canUseCommand((class_2168)source, (Object)CarpetOrgAdditionSettings.commandSendMessage))).then(class_2170.method_9247((String)"copy").then(class_2170.method_9244((String)"text", (ArgumentType)StringArgumentType.string()).executes(SendMessageCommand::sendReplicableText)))).then(class_2170.method_9247((String)"url").then(class_2170.method_9244((String)"url", (ArgumentType)StringArgumentType.string()).executes(SendMessageCommand::sendClickableLink)))).then(class_2170.method_9247((String)"location").executes(SendMessageCommand::sendSelfLocation))).then(class_2170.method_9247((String)"color").then(class_2170.method_9244((String)"color", (ArgumentType)class_2177.method_9276()).then(class_2170.method_9244((String)"text", (ArgumentType)StringArgumentType.string()).executes(SendMessageCommand::sendColorText))))).then(class_2170.method_9247((String)"strikethrough").then(class_2170.method_9244((String)"text", (ArgumentType)StringArgumentType.string()).executes(SendMessageCommand::sendStrikethroughText)))).then(class_2170.method_9247((String)"formatting").then(class_2170.method_9244((String)"text", (ArgumentType)StringArgumentType.string()).executes(SendMessageCommand::sendFormattingText)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"item").executes(context -> SendMessageCommand.sendItemHoverableText((CommandContext<class_2168>)context, true))).then(class_2170.method_9244((String)"itemStack", (ArgumentType)class_2287.method_9776((class_7157)commandRegistryAccess)).executes(context -> SendMessageCommand.sendItemHoverableText((CommandContext<class_2168>)context, false)))));
    }

    private static int sendReplicableText(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String text = StringArgumentType.getString(context, (String)"text");
        class_5250 copy = TextUtils.copy(text, text, (class_2561)TextUtils.translate("chat.copy.click", new Object[0]), class_124.field_1060);
        MessageUtils.broadcastMessage(source.method_9211(), (class_2561)SendMessageCommand.appendPlayerName(source, copy));
        return 1;
    }

    private static int sendClickableLink(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String text = StringArgumentType.getString(context, (String)"url");
        class_5250 url = TextUtils.url(text, text, TextUtils.translate("carpet.commands.sendMessage.url.click_open_url", new Object[0]).getString(), null);
        MessageUtils.broadcastMessage(source.method_9211(), (class_2561)SendMessageCommand.appendPlayerName(source, url));
        return 1;
    }

    private static int sendSelfLocation(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        class_2338 blockPos = player.method_24515();
        class_5250 mutableText = switch (WorldUtils.getDimensionId(player.method_37908())) {
            case "minecraft:overworld" -> TextUtils.translate("carpet.commands.sendMessage.location.overworld", player.method_5476(), TextConstants.blockPos(blockPos, class_124.field_1060), TextConstants.blockPos(MathUtils.getTheNetherPos((class_1297)player), class_124.field_1061));
            case "minecraft:the_nether" -> TextUtils.translate("carpet.commands.sendMessage.location.the_nether", player.method_5476(), TextConstants.blockPos(blockPos, class_124.field_1061), TextConstants.blockPos(MathUtils.getOverworldPos((class_1297)player), class_124.field_1060));
            case "minecraft:the_end" -> TextUtils.translate("carpet.commands.sendMessage.location.the_end", player.method_5476(), TextConstants.blockPos(blockPos, class_124.field_1064));
            default -> TextUtils.translate("carpet.commands.sendMessage.location.default", player.method_5476(), WorldUtils.getDimensionId(player.method_37908()), TextConstants.blockPos(blockPos, null));
        };
        MessageUtils.broadcastMessage(((class_2168)context.getSource()).method_9211(), (class_2561)mutableText);
        return 1;
    }

    private static int sendColorText(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_124 color = class_2177.method_9277(context, (String)"color");
        String text = StringArgumentType.getString(context, (String)"text");
        MessageUtils.broadcastMessage(source.method_9211(), (class_2561)SendMessageCommand.appendPlayerName(source, TextUtils.setColor(TextUtils.createText(text), color)));
        return 1;
    }

    private static int sendStrikethroughText(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String text = StringArgumentType.getString(context, (String)"text");
        MessageUtils.broadcastMessage(source.method_9211(), (class_2561)SendMessageCommand.appendPlayerName(source, TextUtils.regularStyle(text, class_124.field_1068, false, false, false, true)));
        return 1;
    }

    private static int sendFormattingText(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String text = StringArgumentType.getString(context, (String)"text").replaceAll("\\$", "\u00a7");
        MessageUtils.broadcastMessage(source.method_9211(), (class_2561)SendMessageCommand.appendPlayerName(source, TextUtils.createText(text)));
        return 1;
    }

    private static class_5250 appendPlayerName(class_2168 source, class_5250 text) {
        class_3222 player = source.method_44023();
        if (player == null) {
            return text;
        }
        return TextUtils.appendAll(player.method_5476(), ": ", text);
    }

    private static int sendItemHoverableText(CommandContext<class_2168> context, boolean requiredPlayer) throws CommandSyntaxException {
        class_1799 itemStack;
        class_3222 player = CommandUtils.getSourcePlayer(context);
        if (requiredPlayer) {
            class_1799 mainHandStack = player.method_6047();
            class_1799 class_17992 = itemStack = mainHandStack.method_7960() ? player.method_6079() : mainHandStack;
            if (itemStack.method_7960()) {
                throw CommandUtils.createException("carpet.commands.sendMessage.item.empty", new Object[0]);
            }
        } else {
            itemStack = class_2287.method_9777(context, (String)"itemStack").method_9781(1, false);
        }
        class_5250 message = TextUtils.appendAll(player.method_5476(), "\uff1a", itemStack.method_7954());
        MessageUtils.broadcastMessage(((class_2168)context.getSource()).method_9211(), (class_2561)message);
        return 1;
    }
}

