/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.command;

import carpet.patches.EntityPlayerMPFake;
import carpet.utils.CommandHelper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2186;
import net.minecraft.class_2277;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.GameUtils;
import org.carpetorgaddition.util.IOUtils;
import org.carpetorgaddition.util.MathUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.util.WorldUtils;
import org.carpetorgaddition.util.wheel.WorldFormat;

public class SpectatorCommand {
    private static final String SPECTATOR = "spectator";

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)SPECTATOR).requires(source -> CommandHelper.canUseCommand((class_2168)source, (Object)CarpetOrgAdditionSettings.commandSpectator))).executes(context -> SpectatorCommand.setGameMode((CommandContext<class_2168>)context, false))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> SpectatorCommand.setGameMode((CommandContext<class_2168>)context, true)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"teleport").then(class_2170.method_9247((String)"dimension").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).executes(SpectatorCommand::tpToDimension)).then(class_2170.method_9244((String)"location", (ArgumentType)class_2277.method_9737()).executes(SpectatorCommand::tpToDimensionLocation))))).then(class_2170.method_9247((String)"entity").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).executes(SpectatorCommand::tpToEntity)))));
    }

    private static int setGameMode(CommandContext<class_2168> context, boolean isFakePlayer) throws CommandSyntaxException {
        class_1934 gameMode;
        EntityPlayerMPFake player;
        Object object = player = isFakePlayer ? CommandUtils.getArgumentFakePlayer(context) : CommandUtils.getSourcePlayer(context);
        if (player.method_7325()) {
            gameMode = class_1934.field_9215;
            if (!isFakePlayer) {
                SpectatorCommand.loadPlayerPos(player.method_5682(), (class_3222)player);
            }
        } else {
            gameMode = class_1934.field_9219;
            if (isFakePlayer) {
                player.method_45166(0.0, 0.2, 0.0);
            } else {
                SpectatorCommand.savePlayerPos(player.method_5682(), (class_3222)player);
            }
        }
        player.method_7336(gameMode);
        class_5250 text = class_2561.method_43471((String)("gameMode." + gameMode.method_8381()));
        player.method_7353((class_2561)class_2561.method_43469((String)"commands.gamemode.success.self", (Object[])new Object[]{text}), true);
        return gameMode == class_1934.field_9215 ? 1 : 0;
    }

    private static int tpToDimension(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        SpectatorCommand.requireSpectator(player);
        class_3218 dimension = class_2181.method_9289(context, (String)"dimension");
        if (player.method_37908().method_27983() == class_1937.field_25179 && dimension.method_27983() == class_1937.field_25180) {
            player.method_14251(dimension, player.method_23317() / 8.0, player.method_23318(), player.method_23321() / 8.0, player.method_36454(), player.method_36455());
        } else if (player.method_37908().method_27983() == class_1937.field_25180 && dimension.method_27983() == class_1937.field_25179) {
            player.method_14251(dimension, player.method_23317() * 8.0, player.method_23318(), player.method_23321() * 8.0, player.method_36454(), player.method_36455());
        } else {
            player.method_14251(dimension, player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455());
        }
        MessageUtils.sendMessage(context, "carpet.commands.spectator.teleport.success.dimension", player.method_5476(), WorldUtils.getDimensionId((class_1937)dimension));
        return 1;
    }

    private static int tpToDimensionLocation(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        SpectatorCommand.requireSpectator(player);
        class_3218 dimension = class_2181.method_9289(context, (String)"dimension");
        class_243 location = class_2277.method_9736(context, (String)"location");
        player.method_14251(dimension, location.method_10216(), location.method_10214(), location.method_10215(), player.method_36454(), player.method_36455());
        MessageUtils.sendMessage(context, "commands.teleport.success.location.single", player.method_5476(), SpectatorCommand.formatFloat(location.method_10216()), SpectatorCommand.formatFloat(location.method_10214()), SpectatorCommand.formatFloat(location.method_10215()));
        return 1;
    }

    private static int tpToEntity(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        SpectatorCommand.requireSpectator(player);
        class_1297 entity = class_2186.method_9313(context, (String)"entity");
        player.method_14251((class_3218)entity.method_37908(), entity.method_23317(), entity.method_23318(), entity.method_23321(), entity.method_36454(), entity.method_36455());
        MessageUtils.sendMessage(context, "commands.teleport.success.entity.single", player.method_5476(), entity.method_5476());
        return 1;
    }

    private static void requireSpectator(class_3222 player) throws CommandSyntaxException {
        if (player.method_7325()) {
            return;
        }
        throw CommandUtils.createException("carpet.commands.spectator.teleport.fail", class_2561.method_43471((String)("gameMode." + class_1934.field_9219.method_8381())));
    }

    private static void savePlayerPos(MinecraftServer server, class_3222 player) {
        WorldFormat worldFormat = new WorldFormat(server, SPECTATOR, new String[0]);
        JsonObject json = new JsonObject();
        json.addProperty("x", MathUtils.numberToTwoDecimalString(player.method_23317()));
        json.addProperty("y", MathUtils.numberToTwoDecimalString(player.method_23318()));
        json.addProperty("z", MathUtils.numberToTwoDecimalString(player.method_23321()));
        json.addProperty("yaw", MathUtils.numberToTwoDecimalString(player.method_36454()));
        json.addProperty("pitch", MathUtils.numberToTwoDecimalString(player.method_36455()));
        json.addProperty("dimension", WorldUtils.getDimensionId(player.method_37908()));
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String jsonString = gson.toJson((Object)json, JsonObject.class);
        File file = worldFormat.file(player.method_5845() + ".json");
        try (BufferedWriter writer = IOUtils.toWriter(file);){
            writer.write(jsonString);
        }
        catch (IOException e) {
            CarpetOrgAddition.LOGGER.warn("\u65e0\u6cd5\u6b63\u5e38\u5c06{}\u7684\u4f4d\u7f6e\u4fe1\u606f\u5199\u5165\u6587\u4ef6", (Object)GameUtils.getPlayerName((class_1657)player), (Object)e);
        }
    }

    private static void loadPlayerPos(MinecraftServer server, class_3222 player) {
        WorldFormat worldFormat = new WorldFormat(server, SPECTATOR, new String[0]);
        File file = worldFormat.file(player.method_5845() + ".json");
        try {
            BufferedReader reader;
            try (BufferedReader bufferedReader = reader = IOUtils.toReader(file);){
                Gson gson = new Gson();
                JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                double x = json.get("x").getAsDouble();
                double y = json.get("y").getAsDouble();
                double z = json.get("z").getAsDouble();
                float yaw = json.get("yaw").getAsFloat();
                float pitch = json.get("pitch").getAsFloat();
                String dimension = json.get("dimension").getAsString();
                class_3218 world = WorldUtils.getWorld(server, dimension);
                player.method_14251(world, x, y, z, yaw, pitch);
            }
        }
        catch (IOException | NullPointerException e) {
            CarpetOrgAddition.LOGGER.warn("\u65e0\u6cd5\u6b63\u5e38\u8bfb\u53d6{}\u7684\u4f4d\u7f6e\u4fe1\u606f", (Object)GameUtils.getPlayerName((class_1657)player));
        }
    }

    private static String formatFloat(double d) {
        return String.format(Locale.ROOT, "%f", d);
    }
}

