/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.command;

import carpet.patches.EntityPlayerMPFake;
import carpet.utils.CommandHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.util.TextUtils;
import org.carpetorgaddition.util.wheel.TextBuilder;
import org.jetbrains.annotations.Nullable;

public class XpTransferCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"xpTransfer").requires(source -> CommandHelper.canUseCommand((class_2168)source, (Object)CarpetOrgAdditionSettings.commandXpTransfer))).then(class_2170.method_9244((String)"outputPlayer", (ArgumentType)class_2186.method_9305()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"inputPlayer", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9247((String)"all").executes(XpTransferCommand::xpAllTransfer))).then(class_2170.method_9247((String)"half").executes(XpTransferCommand::xpHalfTransfer))).then(class_2170.method_9247((String)"points").then(class_2170.method_9244((String)"number", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> XpTransferCommand.xpPointTransfer((CommandContext<class_2168>)context, null))))).then(class_2170.method_9247((String)"level").then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> XpTransferCommand.xpPointTransfer((CommandContext<class_2168>)context, XpTransferCommand.getTotalExperience(IntegerArgumentType.getInteger((CommandContext)context, (String)"level"), 0))))))));
    }

    private static int xpAllTransfer(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 sourcePlayer = source.method_44023();
        class_3222 outputPlayer = XpTransferCommand.getOutputPlayer(context);
        class_3222 inputPlayer = XpTransferCommand.getInputPlayer(context);
        if (outputPlayer instanceof EntityPlayerMPFake || outputPlayer == sourcePlayer) {
            int outputBeforeLevel = outputPlayer.field_7520;
            int inputBeforeLevel = inputPlayer.field_7520;
            int points = class_3532.method_15375((float)(outputPlayer.field_7510 * (float)outputPlayer.method_7349()));
            int totalExperience = XpTransferCommand.getTotalExperience(outputPlayer.field_7520, points);
            outputPlayer.method_14252(0);
            outputPlayer.method_14228(0);
            inputPlayer.method_7255(totalExperience);
            int outputCurrentLevel = outputPlayer.field_7520;
            int inputCurrentLevel = inputPlayer.field_7520;
            class_5250 message = TextUtils.translate("carpet.commands.xpTransfer.all", outputPlayer.method_5476(), totalExperience, inputPlayer.method_5476());
            class_5250 hover = XpTransferCommand.getHover(inputPlayer, inputCurrentLevel, inputBeforeLevel, outputPlayer, outputBeforeLevel, outputCurrentLevel);
            MessageUtils.sendMessage(source, (class_2561)TextUtils.hoverText((class_2561)message, (class_2561)hover));
            XpTransferCommand.writeLog(source, inputPlayer, outputPlayer, totalExperience);
            return totalExperience;
        }
        throw CommandUtils.createException("carpet.commands.xpTransfer.self_or_fake_player", new Object[0]);
    }

    private static int xpHalfTransfer(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 sourcePlayer = source.method_44023();
        class_3222 outputPlayer = XpTransferCommand.getOutputPlayer(context);
        class_3222 inputPlayer = XpTransferCommand.getInputPlayer(context);
        if (outputPlayer instanceof EntityPlayerMPFake || outputPlayer == sourcePlayer) {
            int outputBeforeLevel = outputPlayer.field_7520;
            int inputBeforeLevel = inputPlayer.field_7520;
            int points = class_3532.method_15375((float)(outputPlayer.field_7510 * (float)outputPlayer.method_7349()));
            int totalExperience = XpTransferCommand.getTotalExperience(outputPlayer.field_7520, points);
            int halfExperience = totalExperience / 2;
            outputPlayer.method_14252(0);
            outputPlayer.method_14228(0);
            inputPlayer.method_7255(halfExperience);
            outputPlayer.method_7255(totalExperience - halfExperience);
            int outputCurrentLevel = outputPlayer.field_7520;
            int inputCurrentLevel = inputPlayer.field_7520;
            class_5250 hover = XpTransferCommand.getHover(inputPlayer, inputCurrentLevel, inputBeforeLevel, outputPlayer, outputBeforeLevel, outputCurrentLevel);
            class_5250 message = TextUtils.translate("carpet.commands.xpTransfer.half", outputPlayer.method_5476(), halfExperience, inputPlayer.method_5476());
            MessageUtils.sendMessage(source, (class_2561)TextUtils.hoverText((class_2561)message, (class_2561)hover));
            XpTransferCommand.writeLog(source, inputPlayer, outputPlayer, halfExperience);
            return halfExperience;
        }
        throw CommandUtils.createException("carpet.commands.xpTransfer.self_or_fake_player", new Object[0]);
    }

    private static int xpPointTransfer(CommandContext<class_2168> context, @Nullable Integer number) throws CommandSyntaxException {
        int xpNumber;
        class_2168 source = (class_2168)context.getSource();
        class_3222 serverCommandSourcePlayer = source.method_44023();
        class_3222 outputPlayer = XpTransferCommand.getOutputPlayer(context);
        class_3222 inputPlayer = XpTransferCommand.getInputPlayer(context);
        int n = xpNumber = number == null ? IntegerArgumentType.getInteger(context, (String)"number") : number;
        if (outputPlayer instanceof EntityPlayerMPFake || outputPlayer == serverCommandSourcePlayer) {
            int outputBeforeLevel = outputPlayer.field_7520;
            int inputBeforeLevel = inputPlayer.field_7520;
            int points = class_3532.method_15375((float)(outputPlayer.field_7510 * (float)outputPlayer.method_7349()));
            int totalExperience = XpTransferCommand.getTotalExperience(outputPlayer.field_7520, points);
            if (xpNumber > totalExperience) {
                throw CommandUtils.createException("carpet.commands.xpTransfer.point.fail", outputPlayer.method_5476(), xpNumber, totalExperience);
            }
            outputPlayer.method_14252(0);
            outputPlayer.method_14228(0);
            inputPlayer.method_7255(xpNumber);
            outputPlayer.method_7255(totalExperience - xpNumber);
            int outputCurrentLevel = outputPlayer.field_7520;
            int inputCurrentLevel = inputPlayer.field_7520;
            class_5250 message = TextUtils.translate("carpet.commands.xpTransfer.point", outputPlayer.method_5476(), xpNumber, inputPlayer.method_5476());
            class_5250 hover = XpTransferCommand.getHover(inputPlayer, inputCurrentLevel, inputBeforeLevel, outputPlayer, outputBeforeLevel, outputCurrentLevel);
            MessageUtils.sendMessage(source, (class_2561)TextUtils.hoverText((class_2561)message, (class_2561)hover));
            XpTransferCommand.writeLog(source, inputPlayer, outputPlayer, xpNumber);
            return xpNumber;
        }
        throw CommandUtils.createException("carpet.commands.xpTransfer.self_or_fake_player", new Object[0]);
    }

    private static class_3222 getOutputPlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        return class_2186.method_9315(context, (String)"outputPlayer");
    }

    private static class_3222 getInputPlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        return class_2186.method_9315(context, (String)"inputPlayer");
    }

    private static void writeLog(class_2168 source, class_3222 inputPlayer, class_3222 outputPlayer, int point) {
        class_3222 player = source.method_44023();
        String output = player == outputPlayer ? "\u81ea\u5df1" : outputPlayer.method_5477().getString();
        String input = player == inputPlayer ? "\u81ea\u5df1" : inputPlayer.method_5477().getString();
        CarpetOrgAddition.LOGGER.info("{}\u5c06{}\u7684{}\u70b9\u7ecf\u9a8c\u8f6c\u79fb\u7ed9{}", new Object[]{source.method_9214(), output, point, input});
    }

    private static class_5250 getHover(class_3222 inputPlayer, int inputCurrentLevel, int inputBeforeLevel, class_3222 outputPlayer, int outputBeforeLevel, int outputCurrentLevel) {
        TextBuilder builder = new TextBuilder();
        builder.append(inputPlayer.method_5476()).appendString(" (+").appendNumber(inputCurrentLevel - inputBeforeLevel).appendString(") [").appendNumber(inputBeforeLevel).appendString("->").appendNumber(inputCurrentLevel).appendString("]").newLine().append(outputPlayer.method_5476()).appendString(" (-").appendNumber(outputBeforeLevel - outputCurrentLevel).appendString(") [").appendNumber(outputBeforeLevel).appendString("->").appendNumber(outputCurrentLevel).appendString("]");
        return builder.toLine();
    }

    private static int getTotalExperience(int level, int xp) {
        int totalExp = level <= 16 ? level * level + 6 * level : (level <= 31 ? (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0) : (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0));
        int sum = totalExp + xp;
        return sum < 0 ? totalExp : sum;
    }
}

