/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.debug.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_1041;
import net.minecraft.class_1132;
import net.minecraft.class_1301;
import net.minecraft.class_1542;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2599;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3917;
import net.minecraft.class_3965;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import org.carpetorgaddition.client.renderer.Tooltip;
import org.carpetorgaddition.debug.DebugSettings;
import org.carpetorgaddition.debug.client.render.HudDebugRenderer;
import org.carpetorgaddition.exception.ProductionEnvironmentError;
import org.carpetorgaddition.mixin.debug.HandledScreenAccessor;
import org.carpetorgaddition.mixin.debug.ScreenAccessor;
import org.carpetorgaddition.util.TextUtils;
import org.carpetorgaddition.util.wheel.Counter;
import org.jetbrains.annotations.Contract;

public class HudDebugRendererRegister {
    private static final HashSet<HudDebugRenderer> renders = new HashSet();

    public static void register() {
        HudRenderCallback.EVENT.register((drawContext, tickCounter) -> {
            RenderSystem.enableDepthTest();
            renders.forEach(renderer -> renderer.render(drawContext, tickCounter));
            RenderSystem.disableDepthTest();
        });
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (DebugSettings.HUDInformationDisplay && screen instanceof class_465) {
                class_465 handledScreen = (class_465)screen;
                class_2371 slots = handledScreen.method_17577().field_7761;
                slots.forEach(slot -> ((ScreenAccessor)screen).putDrawable((context, mouseX, mouseY, delta) -> {
                    HandledScreenAccessor accessor = (HandledScreenAccessor)handledScreen;
                    int x = accessor.getX();
                    int y = accessor.getY();
                    context.method_51433(Screens.getTextRenderer((class_437)screen), String.valueOf(slot.field_7874), slot.field_7873 + x + 1, slot.field_7872 + y, -91904, true);
                }));
            }
        });
    }

    private static boolean showSoulSandItemCount(class_310 client) {
        if (DebugSettings.showSoulSandItemCount) {
            if (client.method_1576() == null) {
                return false;
            }
            if (client.field_1755 == null) {
                return true;
            }
            return client.field_1755 instanceof class_408;
        }
        return false;
    }

    @Contract(value="-> !null")
    private static class_638 getClientWorld() {
        return class_310.method_1551().field_1687;
    }

    @Contract(value="-> !null")
    private static class_1132 getServer() {
        return class_310.method_1551().method_1576();
    }

    @Contract(value="-> !null")
    private static class_746 getPlayer() {
        return class_310.method_1551().field_1724;
    }

    static {
        ProductionEnvironmentError.assertDevelopmentEnvironment();
        renders.add((context, tickCounter) -> {
            if (DebugSettings.showBlockBreakingSpeed) {
                class_310 client = class_310.method_1551();
                class_239 hitResult = client.field_1765;
                if (hitResult == null) {
                    return;
                }
                if (hitResult instanceof class_3965) {
                    class_3965 blockHitResult = (class_3965)hitResult;
                    class_2338 blockPos = blockHitResult.method_17777();
                    class_746 player = HudDebugRendererRegister.getPlayer();
                    class_3218 world = HudDebugRendererRegister.getServer().method_3847(player.method_37908().method_27983());
                    if (world == null) {
                        return;
                    }
                    class_2680 blockState = world.method_8320(blockPos);
                    if (blockState.method_26215()) {
                        return;
                    }
                    float speed = player.method_7351(blockState);
                    String formatted = "%.2f".formatted(Float.valueOf(speed));
                    if (formatted.endsWith(".00")) {
                        formatted = formatted.substring(0, formatted.length() - 3);
                    } else if (formatted.endsWith("0")) {
                        formatted = formatted.substring(0, formatted.length() - 1);
                    }
                    Tooltip.drawTooltip(context, (class_2561)TextUtils.createText("\u6316\u6398\u901f\u5ea6\uff1a" + formatted));
                }
            }
        });
        renders.add((context, tickCounter) -> {
            if (DebugSettings.showComparatorLevel) {
                class_310 client = class_310.method_1551();
                class_239 hitResult = client.field_1765;
                if (hitResult == null) {
                    return;
                }
                if (hitResult instanceof class_3965) {
                    class_3965 blockHitResult = (class_3965)hitResult;
                    class_2338 blockPos = blockHitResult.method_17777();
                    class_746 player = HudDebugRendererRegister.getPlayer();
                    class_3218 world = HudDebugRendererRegister.getServer().method_3847(player.method_37908().method_27983());
                    if (world == null) {
                        return;
                    }
                    class_2586 blockEntity = world.method_8500(blockPos).method_12201(blockPos, class_2818.class_2819.field_12860);
                    if (blockEntity instanceof class_2599) {
                        class_2599 comparator = (class_2599)blockEntity;
                        int level = comparator.method_11071();
                        if (level == 0) {
                            return;
                        }
                        Tooltip.drawTooltip(context, (class_2561)TextUtils.createText("\u7ea2\u77f3\u4fe1\u53f7\u7b49\u7ea7\uff1a" + level));
                    }
                }
            }
        });
        renders.add((context, tickCounter) -> {
            class_310 client = class_310.method_1551();
            if (HudDebugRendererRegister.showSoulSandItemCount(client)) {
                class_239 hitResult = client.field_1765;
                if (hitResult == null) {
                    return;
                }
                if (hitResult instanceof class_3965) {
                    class_3965 blockHitResult = (class_3965)hitResult;
                    class_2338 blockPos = blockHitResult.method_17777();
                    class_2680 blockState = HudDebugRendererRegister.getClientWorld().method_8320(blockPos);
                    if (blockState.method_26215()) {
                        return;
                    }
                    if (blockState.method_27852(class_2246.field_10114)) {
                        class_238 box = new class_238(blockPos.method_10084());
                        List entities = HudDebugRendererRegister.getClientWorld().method_8390(class_1542.class, box, class_1301.field_6154);
                        if (entities.isEmpty()) {
                            return;
                        }
                        Counter<class_1792> counter = new Counter<class_1792>();
                        for (class_1542 itemEntity : entities) {
                            class_1799 itemStack = itemEntity.method_6983();
                            counter.add(itemStack.method_7909(), itemStack.method_7947());
                        }
                        ArrayList<class_2561> list = new ArrayList<class_2561>();
                        for (class_1792 item : counter) {
                            int count = counter.getCount(item);
                            list.add((class_2561)TextUtils.appendAll(item.method_7848(), "*", count));
                        }
                        Tooltip.drawTooltip(context, list);
                    }
                }
            }
        });
        renders.add((context, tickCounter) -> {
            if (DebugSettings.HUDInformationDisplay) {
                class_310 client = class_310.method_1551();
                class_437 screen = client.field_1755;
                if (screen == null) {
                    return;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                String name = screen.getClass().getSimpleName();
                list.add("\u7c7b\u540d\uff1a" + name);
                double mouseX = client.field_1729.method_1603();
                double mouseY = client.field_1729.method_1604();
                list.add("\u9f20\u6807X\uff1a" + (int)mouseX);
                list.add("\u9f20\u6807Y\uff1a" + (int)mouseY);
                if (screen instanceof class_465) {
                    class_465 handledScreen = (class_465)screen;
                    try {
                        class_3917 type = handledScreen.method_17577().method_17358();
                        class_2960 id = class_7923.field_41187.method_10221((Object)type);
                        if (id != null) {
                            list.add("\u5c4f\u5e55\u7c7b\u578bid\uff1a" + String.valueOf(id));
                        }
                    }
                    catch (UnsupportedOperationException e) {
                        list.add("\u5c4f\u5e55\u7c7b\u578bid\uff1anull");
                    }
                    HandledScreenAccessor accessor = (HandledScreenAccessor)handledScreen;
                    class_1041 window = client.method_22683();
                    class_1735 slot = accessor.invokerGetSlotAt(mouseX * (double)window.method_4486() / (double)window.method_4480(), mouseY * (double)window.method_4502() / (double)window.method_4507());
                    if (slot != null) {
                        list.add("\u69fd\u4f4d\u7d22\u5f15\uff1a" + slot.field_7874);
                        list.add("\u69fd\u4f4d\u7269\u54c1\u680f\uff1a" + slot.field_7871.getClass().getSimpleName());
                    }
                }
                context.method_51434(client.field_1772, list.stream().map(class_2561::method_30163).toList(), 3, 25);
            }
        });
    }
}

