/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.mixin.rule;

import carpet.patches.EntityPlayerMPFake;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2580;
import net.minecraft.class_3222;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.logger.LoggerNames;
import org.carpetorgaddition.logger.LoggerRegister;
import org.carpetorgaddition.logger.NetworkPacketLogger;
import org.carpetorgaddition.network.s2c.BeaconBoxUpdateS2CPacket;
import org.carpetorgaddition.util.wheel.BeaconRangeBox;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={class_2580.class})
public abstract class BeaconBlockEntityMixin {
    @Shadow
    private static int method_20293(class_1937 world, int x, int y, int z) {
        return 0;
    }

    @WrapOperation(method={"applyPlayerEffects"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;getNonSpectatingEntities(Ljava/lang/Class;Lnet/minecraft/util/math/Box;)Ljava/util/List;")})
    private static List<class_1657> box(class_1937 world, Class<class_1657> aClass, class_238 box, Operation<List<class_1657>> original, @Local(argsOnly=true) class_2338 pos) {
        BeaconRangeBox beaconRangeBox = new BeaconRangeBox(box);
        if (CarpetOrgAdditionSettings.beaconRangeExpand != 0 && CarpetOrgAdditionSettings.beaconRangeExpand <= 1024) {
            beaconRangeBox = beaconRangeBox.modify(CarpetOrgAdditionSettings.beaconRangeExpand);
        }
        if (CarpetOrgAdditionSettings.beaconWorldHeight) {
            beaconRangeBox = beaconRangeBox.worldHeight(world);
        }
        if (LoggerRegister.beaconRange) {
            BeaconBlockEntityMixin.sendBoxUpdate(world, pos, beaconRangeBox);
        }
        return (List)original.call(new Object[]{world, aClass, beaconRangeBox});
    }

    @WrapOperation(method={"tick"}, at={@At(value="INVOKE", target="Ljava/util/List;isEmpty()Z", ordinal=1)})
    private static boolean tick(List<?> list, Operation<Boolean> original, @Local(argsOnly=true) class_2580 blockEntity) {
        class_2338 pos = blockEntity.method_11016();
        if (LoggerRegister.beaconRange && (list.isEmpty() || BeaconBlockEntityMixin.method_20293(blockEntity.method_10997(), pos.method_10263(), pos.method_10264(), pos.method_10260()) == 0)) {
            NetworkPacketLogger logger = (NetworkPacketLogger)LoggerNames.getLogger("beaconRange");
            logger.sendPacket(() -> new BeaconBoxUpdateS2CPacket(pos, BeaconBoxUpdateS2CPacket.ZERO));
        }
        return (Boolean)original.call(new Object[]{list});
    }

    @Unique
    private static void sendBoxUpdate(class_1937 world, class_2338 pos, BeaconRangeBox beaconRangeBox) {
        int viewDistance = world.method_8503().method_3760().method_14568();
        for (class_1657 player : world.method_18456()) {
            class_243 playerPos = player.method_19538();
            class_243 blockPos = pos.method_46558();
            double x = playerPos.method_10216() - blockPos.method_10216();
            double z = playerPos.method_10215() - blockPos.method_10215();
            double sqrt = Math.sqrt(x * x + z * z);
            if (player instanceof EntityPlayerMPFake || sqrt > (double)(viewDistance * 16) || !(player instanceof class_3222)) continue;
            class_3222 serverPlayerEntity = (class_3222)player;
            NetworkPacketLogger logger = (NetworkPacketLogger)LoggerNames.getLogger("beaconRange");
            logger.sendPacketIfOnline(serverPlayerEntity, () -> new BeaconBoxUpdateS2CPacket(pos, beaconRangeBox));
        }
    }
}

