/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.fakeplayer.action;

import carpet.patches.EntityPlayerMPFake;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.periodic.fakeplayer.action.FakePlayerAction;
import org.carpetorgaddition.periodic.fakeplayer.action.FakePlayerBreakBedrock;
import org.carpetorgaddition.periodic.fakeplayer.action.FakePlayerClean;
import org.carpetorgaddition.periodic.fakeplayer.action.FakePlayerCraft;
import org.carpetorgaddition.periodic.fakeplayer.action.FakePlayerFarm;
import org.carpetorgaddition.periodic.fakeplayer.action.FakePlayerFill;
import org.carpetorgaddition.periodic.fakeplayer.action.FakePlayerFishing;
import org.carpetorgaddition.periodic.fakeplayer.action.FakePlayerRename;
import org.carpetorgaddition.periodic.fakeplayer.action.FakePlayerSorting;
import org.carpetorgaddition.periodic.fakeplayer.action.FakePlayerStonecutting;
import org.carpetorgaddition.periodic.fakeplayer.action.FakePlayerTrade;
import org.carpetorgaddition.periodic.fakeplayer.action.context.AbstractActionContext;
import org.carpetorgaddition.periodic.fakeplayer.action.context.BreakBedrockContext;
import org.carpetorgaddition.periodic.fakeplayer.action.context.CleanContext;
import org.carpetorgaddition.periodic.fakeplayer.action.context.CraftingTableCraftContext;
import org.carpetorgaddition.periodic.fakeplayer.action.context.FarmContext;
import org.carpetorgaddition.periodic.fakeplayer.action.context.FillContext;
import org.carpetorgaddition.periodic.fakeplayer.action.context.FishingContext;
import org.carpetorgaddition.periodic.fakeplayer.action.context.InventoryCraftContext;
import org.carpetorgaddition.periodic.fakeplayer.action.context.RenameContext;
import org.carpetorgaddition.periodic.fakeplayer.action.context.SortingContext;
import org.carpetorgaddition.periodic.fakeplayer.action.context.StonecuttingContext;
import org.carpetorgaddition.periodic.fakeplayer.action.context.StopContext;
import org.carpetorgaddition.periodic.fakeplayer.action.context.TradeContext;
import org.carpetorgaddition.util.GenericFetcherUtils;
import org.carpetorgaddition.util.MessageUtils;

public class FakePlayerActionManager {
    private final EntityPlayerMPFake fakePlayer;
    private final ActionFunction function = new ActionFunction();

    public FakePlayerActionManager(EntityPlayerMPFake fakePlayer) {
        this.fakePlayer = fakePlayer;
    }

    public void tick() {
        try {
            this.executeAction();
        }
        catch (RuntimeException e) {
            CarpetOrgAddition.LOGGER.error("{}\u5728\u6267\u884c\u64cd\u4f5c\u201c{}\u201d\u65f6\u9047\u5230\u610f\u5916\u9519\u8bef:", new Object[]{this.fakePlayer.method_5477().getString(), this.getAction().toString(), e});
            MessageUtils.broadcastErrorMessage(this.fakePlayer.field_13995, e, "carpet.commands.playerAction.exception.runtime", this.fakePlayer.method_5476(), this.getAction().getDisplayName());
            this.stop();
        }
    }

    private void executeAction() {
        FakePlayerAction action = this.function.getAction();
        if (action == FakePlayerAction.STOP) {
            return;
        }
        switch (action) {
            case SORTING: {
                FakePlayerSorting.sorting((SortingContext)this.function.getActionContext(), this.fakePlayer);
                break;
            }
            case CLEAN: {
                FakePlayerClean.clean((CleanContext)this.function.getActionContext(), this.fakePlayer);
                break;
            }
            case FILL: {
                FakePlayerFill.fill((FillContext)this.function.getActionContext(), this.fakePlayer);
                break;
            }
            case INVENTORY_CRAFTING: {
                FakePlayerCraft.inventoryCraft((InventoryCraftContext)this.function.getActionContext(), this.fakePlayer);
                break;
            }
            case CRAFTING_TABLE_CRAFT: {
                FakePlayerCraft.craftingTableCraft((CraftingTableCraftContext)this.function.getActionContext(), this.fakePlayer);
                break;
            }
            case RENAME: {
                FakePlayerRename.rename((RenameContext)this.function.getActionContext(), this.fakePlayer);
                break;
            }
            case STONECUTTING: {
                FakePlayerStonecutting.stonecutting((StonecuttingContext)this.function.actionContext, this.fakePlayer);
                break;
            }
            case TRADE: {
                FakePlayerTrade.trade((TradeContext)this.function.actionContext, this.fakePlayer);
                break;
            }
            case FISHING: {
                FakePlayerFishing.fishing((FishingContext)this.function.getActionContext(), this.fakePlayer);
                break;
            }
            case FARM: {
                FakePlayerFarm.farm((FarmContext)this.function.getActionContext(), this.fakePlayer);
                break;
            }
            case BEDROCK: {
                FakePlayerBreakBedrock.breakBedrock((BreakBedrockContext)this.function.getActionContext(), this.fakePlayer);
                break;
            }
            default: {
                CarpetOrgAddition.LOGGER.error("\u884c\u4e3a\u201c{}\u201d\u6ca1\u6709\u9884\u5148\u5b9a\u4e49", (Object)action);
                this.stop();
            }
        }
    }

    public FakePlayerAction getAction() {
        return this.function.getAction();
    }

    public AbstractActionContext getActionContext() {
        return this.function.getActionContext();
    }

    public void setAction(FakePlayerAction action, AbstractActionContext context) {
        this.function.setAction(action, context);
    }

    public void stop() {
        this.function.setAction(FakePlayerAction.STOP, StopContext.STOP);
    }

    public void setActionFromOldPlayer(EntityPlayerMPFake oldPlayer) {
        FakePlayerActionManager actionManager = GenericFetcherUtils.getFakePlayerActionManager(oldPlayer);
        this.setAction(actionManager.getAction(), actionManager.getActionContext());
    }

    private static class ActionFunction {
        private FakePlayerAction action = FakePlayerAction.STOP;
        private AbstractActionContext actionContext = StopContext.STOP;

        private ActionFunction() {
        }

        private void setAction(FakePlayerAction action, AbstractActionContext actionContext) {
            if (actionContext.getClass() != action.getContextClass()) {
                throw new IllegalArgumentException();
            }
            this.action = action;
            this.actionContext = actionContext;
        }

        private FakePlayerAction getAction() {
            return this.action;
        }

        private AbstractActionContext getActionContext() {
            return this.actionContext;
        }
    }
}

