/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.fakeplayer.action;

import carpet.patches.EntityPlayerMPFake;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2341;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2401;
import net.minecraft.class_243;
import net.minecraft.class_2665;
import net.minecraft.class_2671;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import net.minecraft.class_3481;
import net.minecraft.class_3619;
import net.minecraft.class_3965;
import org.carpetorgaddition.exception.InfiniteLoopException;
import org.carpetorgaddition.periodic.fakeplayer.BlockBreakManager;
import org.carpetorgaddition.periodic.fakeplayer.FakePlayerUtils;
import org.carpetorgaddition.periodic.fakeplayer.action.context.BreakBedrockContext;
import org.carpetorgaddition.util.EnchantmentUtils;
import org.carpetorgaddition.util.GenericFetcherUtils;
import org.carpetorgaddition.util.MathUtils;
import org.carpetorgaddition.util.wheel.SelectionArea;

public class FakePlayerBreakBedrock {
    public static void breakBedrock(BreakBedrockContext context, EntityPlayerMPFake fakePlayer) {
        class_1937 world = fakePlayer.method_37908();
        context.removeIf(destructor -> {
            if (destructor.getState() == State.COMPLETE) {
                return true;
            }
            if (world.method_8320(destructor.getBedrockPos()).method_27852(class_2246.field_9987)) {
                return !fakePlayer.method_56093(destructor.getBedrockPos(), 0.0);
            }
            return destructor.getState() != State.CLEAN_PISTON;
        });
        double range = fakePlayer.method_55754();
        class_238 box = new class_238(fakePlayer.method_24515()).method_1014(Math.min(range, 10.0));
        SelectionArea area = new SelectionArea(box);
        for (class_2338 blockPos : area) {
            if (!world.method_8320(blockPos).method_27852(class_2246.field_9987) || !fakePlayer.method_56093(blockPos, 0.0) || !context.contains(blockPos)) continue;
            context.add(new BedrockDestructor(blockPos));
        }
        block5: for (BedrockDestructor destructor2 : context) {
            int loopCount = 0;
            while (true) {
                if (++loopCount > 10) {
                    throw new InfiniteLoopException();
                }
                StepResult stepResult = FakePlayerBreakBedrock.start(destructor2, fakePlayer, context);
                switch (stepResult.ordinal()) {
                    case 1: {
                        continue block5;
                    }
                    case 2: {
                        return;
                    }
                }
            }
        }
    }

    private static StepResult start(BedrockDestructor destructor, EntityPlayerMPFake fakePlayer, BreakBedrockContext context) {
        class_2338 bedrockPos = destructor.getBedrockPos();
        switch (destructor.getState().ordinal()) {
            case 0: {
                if (FakePlayerBreakBedrock.hasMaterial(fakePlayer)) {
                    StepResult stepResult = FakePlayerBreakBedrock.placePiston(fakePlayer, bedrockPos);
                    if (stepResult == StepResult.CONTINUE) {
                        destructor.nextStep();
                        break;
                    }
                    return stepResult;
                }
                return StepResult.TICK_COMPLETION;
            }
            case 1: {
                StepResult stepResult = FakePlayerBreakBedrock.placeAndActivateTheLever(destructor, fakePlayer, context);
                if (stepResult != StepResult.CONTINUE) {
                    return stepResult;
                }
                destructor.nextStep();
                return StepResult.COMPLETION;
            }
            case 2: {
                StepResult stepResult = FakePlayerBreakBedrock.pistonBreakBedrock(destructor, fakePlayer);
                switch (stepResult.ordinal()) {
                    case 1: {
                        destructor.nextStep();
                        return StepResult.COMPLETION;
                    }
                    case 2: {
                        return StepResult.TICK_COMPLETION;
                    }
                    case 3: {
                        destructor.fail();
                        return StepResult.COMPLETION;
                    }
                }
                throw new IllegalStateException();
            }
            case 3: {
                if (FakePlayerBreakBedrock.cleanPiston(fakePlayer, bedrockPos.method_10084())) {
                    destructor.nextStep();
                    break;
                }
                return StepResult.TICK_COMPLETION;
            }
            default: {
                return StepResult.COMPLETION;
            }
        }
        return StepResult.CONTINUE;
    }

    private static boolean hasMaterial(EntityPlayerMPFake fakePlayer) {
        int pistonCount = 0;
        int levelCount = 0;
        ArrayList list = new ArrayList(fakePlayer.method_31548().field_7547);
        list.addAll(fakePlayer.method_31548().field_7544);
        for (class_1799 itemStack : list) {
            if (itemStack.method_31574(class_1802.field_8249)) {
                pistonCount += itemStack.method_7947();
            } else if (itemStack.method_31574(class_1802.field_8865)) {
                levelCount += itemStack.method_7947();
            }
            if (pistonCount < 2 || levelCount < 1) continue;
            return true;
        }
        return false;
    }

    private static StepResult placePiston(EntityPlayerMPFake fakePlayer, class_2338 bedrockPos) {
        class_1937 world = fakePlayer.method_37908();
        class_2338 up = bedrockPos.method_10086(1);
        class_2680 blockState = world.method_8320(up);
        BlockBreakManager breakManager = GenericFetcherUtils.getBlockBreakManager(fakePlayer);
        boolean isPiston = false;
        if (!blockState.method_26215() && !blockState.method_26164(class_3481.field_44471)) {
            if (blockState.method_27852(class_2246.field_10560)) {
                isPiston = true;
            } else {
                if (FakePlayerBreakBedrock.canMine(fakePlayer, blockState, world, up)) {
                    return FakePlayerBreakBedrock.tickBreakBlock(breakManager, up);
                }
                return StepResult.COMPLETION;
            }
        }
        up = bedrockPos.method_10086(2);
        blockState = world.method_8320(up);
        if (isPiston && blockState.method_27852(class_2246.field_10379) && blockState.method_11654((class_2769)class_2671.field_10927) == class_2350.field_11036) {
            return StepResult.CONTINUE;
        }
        if (blockState.method_26215() || blockState.method_26223() == class_3619.field_15971) {
            if (isPiston) {
                return StepResult.CONTINUE;
            }
            if (FakePlayerBreakBedrock.placePiston(fakePlayer, bedrockPos, class_2350.field_11036).method_23665()) {
                return StepResult.CONTINUE;
            }
            return StepResult.COMPLETION;
        }
        if (FakePlayerBreakBedrock.canMine(fakePlayer, blockState, world, up)) {
            return FakePlayerBreakBedrock.tickBreakBlock(breakManager, up);
        }
        return StepResult.COMPLETION;
    }

    private static boolean canMine(EntityPlayerMPFake fakePlayer, class_2680 blockState, class_1937 world, class_2338 blockPos) {
        if (blockState.method_26215()) {
            return true;
        }
        boolean isPiston = blockState.method_27852(class_2246.field_10560);
        if (isPiston && ((class_2350)blockState.method_11654((class_2769)class_2665.field_10927)).method_10166() != class_2350.class_2351.field_11052) {
            return true;
        }
        if (isPiston && !world.method_8320(blockPos.method_10074()).method_27852(class_2246.field_9987)) {
            return true;
        }
        if (blockState.method_27852(class_2246.field_10363)) {
            return blockState.method_11654((class_2769)class_2401.field_11007) != class_2738.field_12471;
        }
        if (isPiston || blockState.method_27852(class_2246.field_10379)) {
            return false;
        }
        return blockState.method_26214((class_1922)world, blockPos) != -1.0f && BlockBreakManager.canBreak(fakePlayer, blockPos);
    }

    private static StepResult placeAndActivateTheLever(BedrockDestructor destructor, EntityPlayerMPFake fakePlayer, BreakBedrockContext context) {
        class_2338 bedrockPos = destructor.getBedrockPos();
        class_1937 world = fakePlayer.method_37908();
        class_3225 interactionManager = fakePlayer.field_13974;
        class_2350 direction = null;
        for (class_2350 value : MathUtils.HORIZONTAL) {
            class_2338 offset = bedrockPos.method_10093(value);
            class_2680 blockState = world.method_8320(offset);
            if (blockState.method_26215() || blockState.method_26164(class_3481.field_44471)) {
                direction = value;
                continue;
            }
            BlockBreakManager breakManager = GenericFetcherUtils.getBlockBreakManager(fakePlayer);
            if (blockState.method_27852(class_2246.field_10363)) {
                if (blockState.method_11654((class_2769)class_2341.field_11007) != class_2738.field_12471) {
                    return FakePlayerBreakBedrock.tickBreakBlock(breakManager, offset);
                }
                if (bedrockPos.equals((Object)offset.method_10079((class_2350)blockState.method_11654((class_2769)class_2401.field_11177), -1))) {
                    if (destructor.getLeverPos() == null) {
                        destructor.setLeverPos(offset);
                        if (((Boolean)blockState.method_11654((class_2769)class_2401.field_11265)).booleanValue()) continue;
                        FakePlayerBreakBedrock.interactionLever(fakePlayer, offset);
                        continue;
                    }
                    return FakePlayerBreakBedrock.tickBreakBlock(breakManager, offset);
                }
                class_2338 supportBlockPos = offset.method_10079((class_2350)blockState.method_11654((class_2769)class_2401.field_11177), -1);
                if (world.method_8320(supportBlockPos).method_27852(class_2246.field_9987) && context.contains(supportBlockPos)) continue;
                return FakePlayerBreakBedrock.tickBreakBlock(breakManager, offset);
            }
            if (!FakePlayerBreakBedrock.canMine(fakePlayer, blockState, world, offset)) continue;
            return FakePlayerBreakBedrock.tickBreakBlock(breakManager, offset);
        }
        if (destructor.getLeverPos() != null) {
            return StepResult.CONTINUE;
        }
        if (direction == null) {
            return StepResult.COMPLETION;
        }
        class_2338 offset = bedrockPos.method_10093(direction);
        class_2680 blockState = world.method_8320(offset.method_10074());
        if (blockState.method_27852(class_2246.field_10560) && blockState.method_11654((class_2769)class_2665.field_10927) == class_2350.field_11036) {
            return StepResult.COMPLETION;
        }
        if (blockState.method_27852(class_2246.field_10008)) {
            return StepResult.COMPLETION;
        }
        FakePlayerUtils.replenishment(fakePlayer, class_1268.field_5810, stack -> stack.method_31574(class_1802.field_8865));
        FakePlayerUtils.look(fakePlayer, direction.method_10153());
        class_3965 hitResult = new class_3965(bedrockPos.method_46558(), direction, bedrockPos, false);
        interactionManager.method_14262((class_3222)fakePlayer, world, fakePlayer.method_6079(), class_1268.field_5810, hitResult);
        FakePlayerBreakBedrock.interactionLever(fakePlayer, offset);
        destructor.setLeverPos(offset);
        return StepResult.CONTINUE;
    }

    private static StepResult pistonBreakBedrock(BedrockDestructor destructor, EntityPlayerMPFake fakePlayer) {
        class_2338 bedrockPos = destructor.getBedrockPos();
        class_2338 up = bedrockPos.method_10084();
        class_1937 world = fakePlayer.method_37908();
        class_2680 blockState = world.method_8320(up);
        if (blockState.method_27852(class_2246.field_10560) && ((Boolean)blockState.method_11654((class_2769)class_2665.field_12191)).booleanValue()) {
            BlockBreakManager breakManager = GenericFetcherUtils.getBlockBreakManager(fakePlayer);
            FakePlayerBreakBedrock.switchTool(blockState, world, up, fakePlayer);
            int currentTime = breakManager.getCurrentBreakingTime(up);
            if (currentTime == 1) {
                class_2338 leverPos = destructor.getLeverPos();
                class_2680 leverState = world.method_8320(leverPos);
                if (leverState.method_27852(class_2246.field_10363)) {
                    if (((Boolean)leverState.method_11654((class_2769)class_2401.field_11265)).booleanValue()) {
                        FakePlayerBreakBedrock.interactionLever(fakePlayer, leverPos);
                    }
                    FakePlayerBreakBedrock.closeTheSurroundingLevers(up, fakePlayer);
                    destructor.setLeverPos(null);
                    FakePlayerBreakBedrock.breakBlock(breakManager, up, false);
                    if (FakePlayerBreakBedrock.placePiston(fakePlayer, bedrockPos, class_2350.field_11033).method_23665()) {
                        return StepResult.COMPLETION;
                    }
                }
                return StepResult.COMPLETION;
            }
            FakePlayerBreakBedrock.breakBlock(breakManager, up, false);
            return StepResult.TICK_COMPLETION;
        }
        return StepResult.FAIL;
    }

    private static void closeTheSurroundingLevers(class_2338 pistonPos, EntityPlayerMPFake fakePlayer) {
        class_2338 down;
        class_2680 downBlockState;
        class_2338 offset;
        class_1937 world = fakePlayer.method_37908();
        Consumer<class_2338> consumer = blockPos -> {
            class_2680 blockState = world.method_8320(blockPos);
            if (blockState.method_26215()) {
                return;
            }
            if (blockState.method_27852(class_2246.field_10363) && ((Boolean)blockState.method_11654((class_2769)class_2401.field_11265)).booleanValue()) {
                FakePlayerBreakBedrock.interactionLever(fakePlayer, blockPos);
            }
        };
        for (class_2350 direction : MathUtils.HORIZONTAL) {
            offset = pistonPos.method_10093(direction);
            consumer.accept(offset);
            for (class_2350 value : MathUtils.HORIZONTAL) {
                consumer.accept(offset.method_10093(value));
            }
        }
        for (class_2350 direction : MathUtils.HORIZONTAL) {
            offset = pistonPos.method_10084().method_10093(direction);
            consumer.accept(offset);
            for (class_2350 value : MathUtils.HORIZONTAL) {
                consumer.accept(offset.method_10093(value));
            }
        }
        consumer.accept(pistonPos.method_10086(2));
        for (class_2350 direction : MathUtils.HORIZONTAL) {
            consumer.accept(pistonPos.method_10086(2).method_10093(direction));
        }
        class_2338 up = pistonPos.method_10086(3);
        class_2680 upBlockState = world.method_8320(up);
        if (upBlockState.method_27852(class_2246.field_10363) && ((Boolean)upBlockState.method_11654((class_2769)class_2401.field_11265)).booleanValue() && upBlockState.method_11654((class_2769)class_2401.field_11007) == class_2738.field_12475) {
            FakePlayerBreakBedrock.interactionLever(fakePlayer, up);
        }
        if ((downBlockState = world.method_8320(down = pistonPos.method_10087(2))).method_27852(class_2246.field_10363) && ((Boolean)downBlockState.method_11654((class_2769)class_2401.field_11265)).booleanValue() && downBlockState.method_11654((class_2769)class_2401.field_11007) == class_2738.field_12473) {
            FakePlayerBreakBedrock.interactionLever(fakePlayer, down);
        }
    }

    private static boolean cleanPiston(EntityPlayerMPFake fakePlayer, class_2338 blockPos) {
        BlockBreakManager breakManager = GenericFetcherUtils.getBlockBreakManager(fakePlayer);
        class_2680 blockState = fakePlayer.method_37908().method_8320(blockPos);
        if (blockState.method_26215()) {
            return true;
        }
        if (blockState.method_27852(class_2246.field_10008)) {
            return false;
        }
        if (blockState.method_27852(class_2246.field_10560)) {
            return FakePlayerBreakBedrock.breakBlock(breakManager, blockPos, true);
        }
        return true;
    }

    private static StepResult tickBreakBlock(BlockBreakManager breakManager, class_2338 blockPos) {
        return FakePlayerBreakBedrock.breakBlock(breakManager, blockPos, true) ? StepResult.COMPLETION : StepResult.TICK_COMPLETION;
    }

    private static boolean breakBlock(BlockBreakManager breakManager, class_2338 blockPos, boolean switchTool) {
        EntityPlayerMPFake player = breakManager.getPlayer();
        class_1937 world = player.method_37908();
        class_2680 blockState = world.method_8320(blockPos);
        if (switchTool) {
            FakePlayerBreakBedrock.switchTool(blockState, world, blockPos, player);
        }
        return breakManager.breakBlock(blockPos, class_2350.field_11033, false);
    }

    private static void switchTool(class_2680 blockState, class_1937 world, class_2338 blockPos, EntityPlayerMPFake player) {
        boolean replenishment = FakePlayerUtils.replenishment(player, itemStack -> {
            if (player.method_7337()) {
                return itemStack.method_7909().method_7885(blockState, world, blockPos, (class_1657)player);
            }
            if (itemStack.method_7960()) {
                return false;
            }
            if (FakePlayerBreakBedrock.isDamaged(itemStack)) {
                return false;
            }
            return itemStack.method_7924(blockState) > 1.0f;
        });
        if (replenishment) {
            return;
        }
        FakePlayerUtils.replenishment(player, itemStack -> !FakePlayerBreakBedrock.isDamaged(itemStack));
    }

    private static boolean isDamaged(class_1799 itemStack) {
        return itemStack.method_7963() && itemStack.method_7936() - itemStack.method_7919() <= 10 && EnchantmentUtils.canRepairWithXp(itemStack);
    }

    private static class_1269 placePiston(EntityPlayerMPFake fakePlayer, class_2338 bedrockPos, class_2350 direction) {
        class_3225 interactionManager = fakePlayer.field_13974;
        FakePlayerUtils.look(fakePlayer, direction.method_10153());
        FakePlayerUtils.replenishment(fakePlayer, class_1268.field_5810, itemStack -> itemStack.method_31574(class_1802.field_8249));
        class_3965 hitResult = new class_3965(class_243.method_26410((class_2382)bedrockPos, (double)1.0), direction, bedrockPos.method_10084(), false);
        return interactionManager.method_14262((class_3222)fakePlayer, fakePlayer.method_37908(), fakePlayer.method_6079(), class_1268.field_5810, hitResult);
    }

    private static void interactionLever(EntityPlayerMPFake fakePlayer, class_2338 leverPos) {
        class_3225 interactionManager = fakePlayer.field_13974;
        class_3965 hitResult = new class_3965(leverPos.method_46558(), class_2350.field_11036, leverPos, false);
        interactionManager.method_14262((class_3222)fakePlayer, fakePlayer.method_37908(), fakePlayer.method_6047(), class_1268.field_5808, hitResult);
    }

    public static class BedrockDestructor {
        private final class_2338 bedrockPos;
        private class_2338 leverPos;
        private State state = State.PLACE_THE_PISTON_FACING_UP;

        private BedrockDestructor(class_2338 bedrockPos) {
            this.bedrockPos = bedrockPos;
        }

        public class_2338 getBedrockPos() {
            return this.bedrockPos;
        }

        public class_2338 getLeverPos() {
            return this.leverPos;
        }

        public void setLeverPos(class_2338 leverPos) {
            this.leverPos = leverPos;
        }

        public State getState() {
            return this.state;
        }

        public void nextStep() {
            State[] values = State.values();
            if (this.state.ordinal() == values.length) {
                throw new IllegalStateException();
            }
            this.state = values[this.state.ordinal() + 1];
        }

        public void fail() {
            this.state = State.COMPLETE;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BedrockDestructor that = (BedrockDestructor)o;
            return Objects.equals(this.bedrockPos, that.bedrockPos);
        }

        public int hashCode() {
            return Objects.hashCode(this.bedrockPos);
        }
    }

    private static enum StepResult {
        CONTINUE,
        COMPLETION,
        TICK_COMPLETION,
        FAIL;

    }

    public static enum State {
        PLACE_THE_PISTON_FACING_UP,
        PLACE_AND_ACTIVATE_THE_LEVER,
        PISTON_BREAK_BEDROCK,
        CLEAN_PISTON,
        COMPLETE;

    }
}

