/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.fakeplayer.action;

import carpet.patches.EntityPlayerMPFake;
import net.minecraft.class_1703;
import net.minecraft.class_1714;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.exception.InfiniteLoopException;
import org.carpetorgaddition.periodic.fakeplayer.FakePlayerUtils;
import org.carpetorgaddition.periodic.fakeplayer.action.context.CraftingTableCraftContext;
import org.carpetorgaddition.periodic.fakeplayer.action.context.InventoryCraftContext;
import org.carpetorgaddition.util.InventoryUtils;
import org.carpetorgaddition.util.inventory.AutoGrowInventory;
import org.carpetorgaddition.util.wheel.ItemStackPredicate;

public class FakePlayerCraft {
    private static final int MAX_LOOP_COUNT = 1200;

    private FakePlayerCraft() {
    }

    public static void craftingTableCraft(CraftingTableCraftContext context, EntityPlayerMPFake fakePlayer) {
        class_1703 class_17032 = fakePlayer.field_7512;
        if (class_17032 instanceof class_1714) {
            class_1714 craftingScreenHandler = (class_1714)class_17032;
            AutoGrowInventory inventory = new AutoGrowInventory();
            FakePlayerCraft.craftingTableCraft(context, fakePlayer, inventory, craftingScreenHandler);
            FakePlayerCraft.dropCraftOut(fakePlayer, inventory);
        }
    }

    public static void inventoryCraft(InventoryCraftContext context, EntityPlayerMPFake fakePlayer) {
        AutoGrowInventory inventory = new AutoGrowInventory();
        FakePlayerCraft.inventoryCraft(context, fakePlayer, inventory);
        FakePlayerCraft.dropCraftOut(fakePlayer, inventory);
    }

    private static void craftingTableCraft(CraftingTableCraftContext craftData, EntityPlayerMPFake fakePlayer, AutoGrowInventory inventory, class_1714 craftingScreenHandler) {
        int successCount;
        block12: {
            block13: {
                ItemStackPredicate[] items = craftData.getPredicates();
                int craftCount = 0;
                int loopCount = 0;
                do {
                    if (++loopCount > 1200) {
                        throw new InfiniteLoopException();
                    }
                    successCount = 0;
                    block1: for (int index = 1; index <= 9; ++index) {
                        ItemStackPredicate predicate = items[index - 1];
                        class_1735 slot = craftingScreenHandler.method_7611(index);
                        if (slot.method_7681()) {
                            class_1799 itemStack = slot.method_7677();
                            if (predicate.test(itemStack)) {
                                ++successCount;
                                continue;
                            }
                            FakePlayerUtils.throwItem((class_1703)craftingScreenHandler, index, fakePlayer);
                            continue;
                        }
                        if (predicate.isEmpty()) {
                            ++successCount;
                            continue;
                        }
                        int size = craftingScreenHandler.field_7761.size();
                        for (int inventoryIndex = 10; inventoryIndex < size; ++inventoryIndex) {
                            class_1799 contentItemStack;
                            class_1799 itemStack = craftingScreenHandler.method_7611(inventoryIndex).method_7677();
                            if (predicate.test(itemStack)) {
                                if (FakePlayerUtils.withKeepPickupAndMoveItemStack((class_1703)craftingScreenHandler, inventoryIndex, index, fakePlayer)) {
                                    ++successCount;
                                    continue block1;
                                }
                            } else if (CarpetOrgAdditionSettings.fakePlayerCraftPickItemFromShulkerBox && InventoryUtils.isShulkerBoxItem(itemStack) && !(contentItemStack = InventoryUtils.pickItemFromShulkerBox(itemStack, predicate)).method_7960()) {
                                FakePlayerUtils.dropCursorStack((class_1703)craftingScreenHandler, fakePlayer);
                                craftingScreenHandler.method_34254(contentItemStack);
                                FakePlayerUtils.pickupCursorStack((class_1703)craftingScreenHandler, index, fakePlayer);
                                ++successCount;
                                continue block1;
                            }
                            if (index != 9 || inventoryIndex != size - 1) continue;
                            return;
                        }
                    }
                    if (successCount != 9) break block12;
                    if (!craftingScreenHandler.method_7611(0).method_7681()) break block13;
                    FakePlayerUtils.collectItem((class_1703)craftingScreenHandler, 0, inventory, fakePlayer);
                } while (!FakePlayerCraft.shouldStop(++craftCount));
                return;
            }
            FakePlayerCraft.stopCraftAction(fakePlayer.method_5671(), fakePlayer);
            return;
        }
        if (successCount > 9) {
            throw new IllegalStateException(fakePlayer.method_5477().getString() + "\u627e\u5230\u6b63\u786e\u5408\u6210\u6750\u6599\u7684\u6b21\u6570\u4e3a" + successCount + "\uff0c\u6b63\u5e38\u4e0d\u5e94\u8be5\u8d85\u8fc79");
        }
    }

    private static void inventoryCraft(InventoryCraftContext craftData, EntityPlayerMPFake fakePlayer, AutoGrowInventory inventory) {
        int successCount;
        block13: {
            block14: {
                class_1723 playerScreenHandler = fakePlayer.field_7498;
                ItemStackPredicate[] items = craftData.getPredicates();
                int craftCount = 0;
                int loopCount = 0;
                do {
                    if (++loopCount > 1200) {
                        throw new InfiniteLoopException();
                    }
                    successCount = 0;
                    block1: for (int craftIndex = 1; craftIndex <= 4; ++craftIndex) {
                        ItemStackPredicate matcher = items[craftIndex - 1];
                        class_1735 slot = playerScreenHandler.method_7611(craftIndex);
                        if (slot.method_7681()) {
                            if (matcher.test(slot.method_7677())) {
                                ++successCount;
                                continue;
                            }
                            FakePlayerUtils.throwItem((class_1703)playerScreenHandler, craftIndex, fakePlayer);
                        } else if (matcher.isEmpty()) {
                            ++successCount;
                            continue;
                        }
                        int size = playerScreenHandler.field_7761.size();
                        for (int inventoryIndex = 5; inventoryIndex < size; ++inventoryIndex) {
                            class_1799 contentItemStack;
                            class_1799 itemStack = playerScreenHandler.method_7611(inventoryIndex).method_7677();
                            if (matcher.test(itemStack)) {
                                if (FakePlayerUtils.withKeepPickupAndMoveItemStack((class_1703)playerScreenHandler, inventoryIndex, craftIndex, fakePlayer)) {
                                    ++successCount;
                                    continue block1;
                                }
                            } else if (CarpetOrgAdditionSettings.fakePlayerCraftPickItemFromShulkerBox && InventoryUtils.isShulkerBoxItem(itemStack) && !(contentItemStack = InventoryUtils.pickItemFromShulkerBox(itemStack, matcher)).method_7960()) {
                                FakePlayerUtils.dropCursorStack((class_1703)playerScreenHandler, fakePlayer);
                                playerScreenHandler.method_34254(contentItemStack);
                                FakePlayerUtils.pickupCursorStack((class_1703)playerScreenHandler, craftIndex, fakePlayer);
                                ++successCount;
                                continue block1;
                            }
                            if (craftIndex != 4 || inventoryIndex != size - 1) continue;
                            return;
                        }
                    }
                    if (successCount != 4) break block13;
                    if (!playerScreenHandler.method_7611(0).method_7681()) break block14;
                    FakePlayerUtils.collectItem((class_1703)playerScreenHandler, 0, inventory, fakePlayer);
                } while (!FakePlayerCraft.shouldStop(++craftCount));
                return;
            }
            FakePlayerCraft.stopCraftAction(fakePlayer.method_5671(), fakePlayer);
            return;
        }
        if (successCount > 4) {
            throw new IllegalStateException(fakePlayer.method_5477().getString() + "\u627e\u5230\u6b63\u786e\u5408\u6210\u6750\u6599\u7684\u6b21\u6570\u4e3a" + successCount + "\uff0c\u6b63\u5e38\u4e0d\u5e94\u8be5\u8d85\u8fc74");
        }
    }

    private static void dropCraftOut(EntityPlayerMPFake fakePlayer, AutoGrowInventory inventory) {
        for (class_1799 itemStack : inventory) {
            fakePlayer.method_7329(itemStack, false, true);
        }
    }

    private static boolean shouldStop(int craftCount) {
        if (CarpetOrgAdditionSettings.fakePlayerMaxCraftCount < 0) {
            return false;
        }
        return craftCount >= CarpetOrgAdditionSettings.fakePlayerMaxCraftCount;
    }

    private static void stopCraftAction(class_2168 source, EntityPlayerMPFake playerMPFake) {
        FakePlayerUtils.stopAction(source, playerMPFake, "carpet.commands.playerAction.craft", new Object[0]);
    }
}

